#!/bin/csh
#
# This hncogp3d processing script was created using AGNuS 2.1.
#
# 3D Processing Script.


xyz2pipe -in ./pipe_conversion/HNCO%03d.fid  -x -verb \
| nmrPipe  -fn SOL  \
| nmrPipe  -fn SP -off 0.45 -end 0.98 -pow 2 -c 0.5  \
| nmrPipe  -fn ZF -size 1024   \
| nmrPipe  -fn FT   \
| nmrPipe  -fn PS -p0 250 -p1 0 -di    \
| nmrPipe  -fn EXT -left -sw  \
| nmrPipe  -fn TP  \
| nmrPipe  -fn SP -off 0.45 -end 0.98 -pow 2 -c 0.5  \
| nmrPipe  -fn ZF -size 256   \
| nmrPipe  -fn FT   \
| nmrPipe  -fn PS -p0 90 -p1 0 -di    \
| pipe2xyz -out ./pipe_processing/HNCO%03d.ft2  -y -ov -verb      

xyz2pipe -in  ./pipe_processing/HNCO%03d.ft2  -z  -verb    \
| nmrPipe  -fn SP -off 0.45 -end 0.98 -pow 2 -c 0.5  \
| nmrPipe  -fn ZF -size 256   \
| nmrPipe  -fn FT -alt   \
| nmrPipe  -fn PS -p0 0 -p1 0 -di    \
| pipe2xyz -out ./pipe_processing/HNCO%03d.ft3  -z  -ov -verb     

xyz2pipe -in ./pipe_processing/HNCO%03d.ft3  -y -verb  \
  > ./HNCO.pipe 

