#!/bin/csh
#
# This noesyhsqcetgp3d processing script was created using AGNuS 2.1.
#
# XZ Processing Script.

# Extraction and Processing of an X-Axis/Z-Axis 2D Plane from 3D:
#  Extract the first XZ Plane.
#  Process the plane with a 2D scheme.

$NMRTXT/ext.xz.com ./pipe_conversion/C13_noesy_HSQC%03d.fid ./C13_noesy_HSQC_xz001.fid 2 

nmrPipe -in ./C13_noesy_HSQC_xz001.fid   \
| nmrPipe  -fn SOL  \
| nmrPipe  -fn SP -off 0.45 -end 0.98 -pow 2 -c 0.5  \
| nmrPipe  -fn ZF -auto   \
| nmrPipe  -fn FT   \
| nmrPipe  -fn PS -p0 70.4 -p1 0 -di    \
| nmrPipe  -fn TP  \
| nmrPipe  -fn SP -off 0.45 -end 0.98 -pow 2 -c 0.5  \
| nmrPipe  -fn ZF -auto   \
| nmrPipe  -fn FT -alt   \
| nmrPipe  -fn PS -p0 0 -p1 0 -di    \
   -verb -ov -out ./C13_noesy_HSQC_xz.pipe

rm ./C13_noesy_HSQC_xz001.fid 

