#!/bin/csh
#
# This hncogp3d processing script was created using AGNuS 2.1.
#
# 3D Processing Script.


xyz2pipe -in ./pipe_conversion/HNCO%03d.fid  -x -verb \
| nmrPipe  -fn POLY -time  \
| nmrPipe  -fn SP -off 0.45 -end 0.98 -pow 2 -c 0.5  \
| nmrPipe  -fn ZF -auto   \
| nmrPipe  -fn FT   \
| nmrPipe  -fn PS -p0 -14 -p1 0 -di    \
| nmrPipe  -fn POLY -auto -ord 1   \
| nmrPipe  -fn EXT -left -sw   \
| nmrPipe  -fn TP  \
| nmrPipe  -fn SP -off 0.45 -end 0.98 -pow 2 -c 0.5  \
| nmrPipe  -fn ZF -auto   \
| nmrPipe  -fn FT   \
| nmrPipe  -fn PS -p0 90 -p1 0 -di    \
| pipe2xyz -out ./pipe_processing/HNCO%03d.ft2  -y -ov -verb      

xyz2pipe -in  ./pipe_processing/HNCO%03d.ft2  -z  -verb    \
| nmrPipe  -fn SP -off 0.45 -end 0.98 -pow 2 -c 0.5  \
| nmrPipe  -fn ZF -auto   \
| nmrPipe  -fn FT -alt   \
| nmrPipe  -fn PS -p0 0 -p1 0 -di    \
| nmrPipe  -fn POLY -auto -ord 1   \
| pipe2xyz -out ./pipe_processing/HNCO%03d.ft3  -z  -ov -verb     

xyz2pipe -in ./pipe_processing/HNCO%03d.ft3  -y -verb  \
| nmrPipe  -fn POLY -auto -ord 1   \
  > ./HNCO.pipe 

