#!/bin/csh
#
# This noesyhsqcetgp3d processing script was created using AGNuS 2.1.
#
# 3D Processing Script.


xyz2pipe -in ./pipe_conversion/C13_noesy_HSQC%03d.fid  -x -verb \
| nmrPipe  -fn POLY -avg -nw 64  -fx1 NW+4 -nc 64   \
| nmrPipe  -fn SP -off 0.45 -end 0.98 -pow 2 -c 0.5  \
| nmrPipe  -fn ZF -auto   \
| nmrPipe  -fn FT   \
| nmrPipe  -fn PS -p0   -92.0 -p1  -39.0 -di    \
| nmrPipe  -fn TP  \
| nmrPipe  -fn SP -off 0.45 -end 0.98 -pow 2 -c 0.5  \
| nmrPipe  -fn ZF -auto   \
| nmrPipe  -fn FT   \
| nmrPipe  -fn PS -p0 -96 -p1 6 -di    \
| pipe2xyz -out ./pipe_processing/C13_noesy_HSQC%03d.ft2  -y -ov -verb      

xyz2pipe -in  ./pipe_processing/C13_noesy_HSQC%03d.ft2  -z  -verb    \
| nmrPipe  -fn SP -off 0.45 -end 0.98 -pow 2 -c 0.5  \
| nmrPipe  -fn ZF -auto   \
| nmrPipe  -fn FT -alt   \
| nmrPipe  -fn PS -p0 -2 -p1 0 -di    \
| pipe2xyz -out ./pipe_processing/C13_noesy_HSQC%03d.ft3  -z  -ov -verb     

xyz2pipe -in ./pipe_processing/C13_noesy_HSQC%03d.ft3  -y -verb  \
  > ./C13_noesy_HSQC.pipe 

