#!/bin/csh
#
# This noesyhsqcetgp3d processing script was created using AGNuS 2.0.
#
# 3D Processing Script.


xyz2pipe -in ./pipe_conversion/C13_noesy_HSQC%03d.fid  -x -verb \
| nmrPipe  -fn POLY -avg -nw 64  -fx1 NW+4 -nc 64   \
| nmrPipe  -fn SP -off 0.45 -end 0.98 -pow 2 -c 0.5  \
| nmrPipe  -fn ZF -auto   \
| nmrPipe  -fn FT   \
| nmrPipe  -fn PS -p0  -90.0 -p1 -39.0 -di    \
| nmrPipe  -fn TP  \
| nmrPipe  -fn ZF -auto   \
| nmrPipe  -fn FT -auto  \
| nmrPipe  -fn PS -p0 -96.0 -p1  6.0 -di    \
|pipe2xyz -out lp1/testlp%03d.ft1 -z 

xyz2pipe -in lp1/testlp%03d.ft1 -y -verb \
|nmrPipe -fn LP -ord 16 -fb -after -x1 1 -xn  128 -pred   80   \
|pipe2xyz -out lpt1/testlp%03d.ft1 -y

xyz2pipe -in lpt1/testlp%03d.ft1 -y -verb \
| nmrPipe  -fn SP -off 0.45 -end 0.98 -pow 2 -c 0.5  \
| nmrPipe  -fn ZF -size 512   \
| nmrPipe  -fn FT -alt   \
| nmrPipe  -fn PS -p0 -2.0 -p1 0 -di    \
|pipe2xyz -out lp1/testlp%03d.ft2 -y -inPlance

xyz2pipe -in lp1/testlp%03d.ft2 -z -verb \
|nmrPipe -fn HT -auto                                           \
|nmrPipe -fn PS -p0  -90.0 -p1 -0.0  -inv                         \
|nmrPipe -fn FT -auto -inv                                      \
|nmrPipe -fn ZF -auto -inv                                   \
|nmrPipe  -fn LP -fb -after -x1 1 -xn  32 -pred  24    \
|pipe2xyz -out lpt1/testlp%03d.ft2 -y


xyz2pipe -in lpt1/testlp%03d.ft2 -y -verb                  \
|nmrPipe -fn SP -off 0.45  -end 0.98 -pow 2 -c 0.5      \
|nmrPipe -fn ZF -size 64                                 \
|nmrPipe -fn FT -auto                                        \
|nmrPipe -fn PS -p0  -90 -p1 -0  -di                              \
|pipe2xyz -out lp1/testlp%03d.ft3 -z 

