# ==== setting output and test-flag ====
sp:=SP1           # SP1 or SP2
output      := gft43hncabca_{$sp}_6755
test_ft     := n         # test-ft for phasing with XEASY
reduce_flag := n         # reduce size for test-ft by factor of 2
plane := n              # can be 12, 13 or 'n'
lp := y
np := 512
ni := 98
ni2:= 38


# ASSUMED TEMPERATURE FOR CALIBRATION:  290.0

#  can not read temperature from Eurotherm,
#  please check sample temperature and chemical shift calibration!

# ==== reading of data ====
#readvnmr3d fid $np $ni $ni2 byteswap
#readGFT3D.3 fid $np $ni $ni2 byteswap
trosy_t1t2 integer {$sp} {$np}c {$ni}c {$ni2}c

if ('$plane' == '12') then
   dim 3
   reduce 2..2
   dim 1 2 3
   write integer tmp
   read integer tmp {$np}c {$ni}c
end if
if ('$plane' == '13') then
   dim 2
   reduce 1..1
   dim 1 3 2
   write integer tmp
   read integer tmp {$np}c {$ni2}c
end if


dim 1
reduce 1..512 
#decim      = 12
#gdp        = 69.551          # group delay in points


# ==== setting of parameters ====
#DIMENSION: 1
si(1)      = 1024             # frequency domain size
aqm(1)    := RSH              # acquisition mode (ST/TP, TPPI, RSH)
w0(1)      = 750.6180944      # frequency
delta(1)   = 0.00011110        # increment in time domain
ppmmax(1)  = 10.775           # maximum ppm for calibration

#DIMENSION: 2 (13C)
si(2)      = 256               # frequency domain size
aqm(2)    := RSH           # acquisition mode (ST/TP, TPPI, RSH)
w0(2)      = 188.7425670     # frequency
delta(2)   = 0.000066675    # increment in time domain
ppmmax(2)  = 95.243          # maximum ppm for calibration

#DIMENSION: 3 (15N)
si(3)      = 128             # frequency domain size
aqm(3)    := RSH            # acquisition mode (ST/TP, TPPI, RSH)
w0(3)      = 76.05946946      # frequency
delta(3)   = 0.000476120      # increment in time domain
ppmmax(3)  = 131.997          # maximum ppm for calibration


if ('$plane' == '13') then
#   si(2)      = $si(3)
   aqm(2)    := $aqm(3)
   w0(2)      = $w0(3)
   delta(2)   = $delta(3)
   ppmmax(2)  = $ppmmax(3)
end if


#ns         = 4                # number of scans
set dim_order= 1              # order of dimensions

if ('$plane' == 'n') then
   set n_dim= 3
else
   set n_dim= 2
end if



window1 := "window sin 90"
window2 := "window sin 90"
if ('$plane' == 'n') then
   window3 := "window sin 90"
end if



ph0_d(1) = -90+36
ph1_d(1) = 0
#if ('$sp' == 'SP1') then
#   ph0_d(2) = 22
#else
#   ph0_d(2) = 58
#end if
ph0_d(2) = 0  
ph1_d(2) = 0
ph0_d(3) = -90
ph1_d(3) = 0
if ('$plane' == '13') then
   ph0_d(2) = $ph0_d(3)
   ph1_d(2) = $ph1_d(3)
end if


# ====================
# ==== processing ====
# ====================

dim 1
conjugate
#phase 90
#dim 2
#conjugate



# ==== ft ====
strip_ft 1 1..$si(1)/2
if ('$lp'!='y') then
   dim 2
   mul 0.5 1
   strip_ft 2 1..$si(2)
   if ('$plane' == 'n') then
      dim 3
      mul 0.5 1
      strip_ft 3 1..$si(3)
   end if
else
   dim 2 
   ft $si(2)
   dim 3
   predict lpsvd 8 16
   mul 0.5 1
   strip_ft 3 1..$si(3)
   dim 2
   ift $si(2) 1 $ni
   predict lpsvd 8 30
   mul 0.5 1
   strip_ft 2 1..$si(2)
end if


if ('$test_ft'!='y') then

  dimension 1
  #cflatt iterative cftw 3 $si(1)
  cflatt iterative polynom 5
  dimension 2
  cflatt iterative polynom 5
  if ('$plane' == 'n') then 
     dimension 3
     cflatt iterative polynom 5
  end if
else
  if ('$plane' == 'n') then
     select r r r
     dimension 1
     cflatt flatt 10 5 polynom 5
     dimension 2
     cflatt flatt 10 5 polynom 5
     dimension 3
     cflatt iterative polynom 5

     select i r r
     dimension 1
     cflatt flatt 10 5 polynom 5
     dimension 2
     cflatt flatt 10 5 polynom 5
     dimension 3
     cflatt iterative polynom 5

     select r i r
     dimension 1
     cflatt flatt 10 5 polynom 5
     dimension 2
     cflatt flatt 10 5 polynom 5
     dimension 3
     cflatt iterative polynom 5

     select r r i
     dimension 1
     cflatt flatt 10 5 polynom 5
     dimension 2
     cflatt flatt 10 5 polynom 5
     dimension 3
     cflatt iterative polynom 5
  else
     select r r
     dimension 1
     cflatt flatt 10 5 polynom 5
     dimension 2
     cflatt flatt 10 5 polynom 5

     select i r
     dimension 1
     cflatt flatt 10 5 polynom 5
     dimension 2
     cflatt flatt 10 5 polynom 5

     select r i
     dimension 1
     cflatt flatt 10 5 polynom 5
     dimension 2
     cflatt flatt 10 5 polynom 5
  end if
end if

select


if ('$plane' == 'n') then
   dim 1 2 3
else
   dim 1 2
end if

scale noise
#multiply -1


if ('$test_ft'.eq.'y') then
   if ('$plane' == 'n') then
      write easy16 $output.rrr r r r byteswap
      write easy16 $output.rri r r i byteswap         #phase 15n
      write easy16 $output.irr i r r byteswap         #phase 13c
      write easy16 $output.rir r i r byteswap         #phase 13c
   else
      write easy16 {$output}.{$plane}.rr r r byteswap
      write easy16 {$output}.{$plane}.ir i r byteswap
      write easy16 {$output}.{$plane}.ri r i byteswap
   end if
else
   if ('$plane' == 'n') then
      write easy16 $output byteswap
      system project -d 1 -n -1 $output {$output}_23 > project.out
      system project -d 2 -n -1 $output {$output}_13 > project.out
   else
      write easy16 {$output}.{$plane} byteswap
   end if
end if


