/*
 * FILE:         $Source: /cvs_archive/cvs/blast/blastConfig.cc,v $
 * 
 * DESCRIPTION:  This file contains constructor for class blastConfig and 
 *               initializers for static const members of blastConfig.
 *               BlastConfig's job in life is to store configuration
 *               settings.
 *
 * AUTHOR:       $Author: dmaziuk $
 *
 * DATE:         $Date: 2001/03/15 22:33:34 $
 *
 * UPDATE HISTORY
 * --------------
 * $Log: blastConfig.cc,v $
 * Revision 2.3  2001/03/15 22:33:34  dmaziuk
 * Disabled deposition of PDB entries in molecular system description frame.
 *
 * Revision 2.2  2001/02/20 21:00:07  dmaziuk
 * Few minor changes
 *
 * Revision 2.1  2001/01/17 22:52:35  dmaziuk
 * Fixed a bug where wrong sequence length was deposited into starfile.
 *
 * Revision 2.0  2001/01/11 23:44:43  dmaziuk
 * Version 2 of blast contains complete rewrite of blastParser and major rewrite
 * of (almost) everything else.
 *
// Revision 1.1  2000/11/28  20:14:47  dmaziuk
// Added new class blastConfig. It reads in parameters from blastrc file.
// Changed blastDeposit::make_pdb_list() to public because it is called
// from main(). Changed main() to return int (was: void). Changed Makefile
// to use platform-specific headers ($BMRBMAKEHEADER). Removed some hard-coded
// stuff from the source and put it in Makefile instead.
//
 */

#include "blastConfig.h"

const string blastConfig::strFlag = string( "Sequences producing significant alignments:" );

const string blastConfig::endFlag = string( "<PRE>  Database: nr" );

const string blastConfig::fDbNames[blastConfig::NumDbs] =
{ string( "PDB" ), string( "DBJ" ), string( "EMBL" ), string( "GenBank" ),
  string( "GI" ),  string( "PIR" ), string( "PRF" ), string( "REF" ), 
  string( "SWISS_PROT" ), string( "?" ) };

const string blastConfig::fDbCodes[blastConfig::NumDbs] =
{ string( "pdb" ), string( "dbj" ), string( "emb" ), string( "gb" ), 
  string( "gi" ), string( "pir" ), string( "prf" ), string( "ref" ),
  string( "sp" ), string( "?" ) };

//    returns quote style for a string.
/*
    Quote styles are defined in starlib (ast.h), they're just
    an enum of none, single quote, double quote or semicolon 
    (for multi-line entries).
    It is static so we don't need an object to call it.
    
    @param searchMe string to check
    @return quote style
  */ 
static DataValueNode::ValType blastConfig::findNeededQuoteStyle( const string& searchMe )
{
    int length = searchMe.length();
    bool has_squote  = false;
    bool has_dquote  = false;
    bool has_wspace  = false;
    bool has_newline = false;
    char* tmpString  = new char[length+1];
    int retVal       = DataValueNode::NON;   // return value.  assume 'space'
                                             // by default.

    strcpy( tmpString, searchMe.c_str() );
    if( strchr( tmpString, '\'' ) )
	has_squote = true;
    if( strchr( tmpString, '\"' ) )	     //" this is a stupid trick to turn off
	has_dquote = true;                   //  colorisation in some dumb editors
    if( strchr( tmpString, ' ' ) || strchr( tmpString, '\t' ) )
	has_wspace = true;
    if( strchr( tmpString, '\n' ) )
	has_newline = true;
 
    if( has_newline || (has_dquote && has_squote) ) retVal = DataValueNode::SEMICOLON; 
    else if( has_dquote ) retVal = DataValueNode::SINGLE;
    else if( has_squote || has_wspace ) retVal = DataValueNode::DOUBLE;
    else DataValueNode::NON;
    
    return retVal;
    
} //----------- end-FindNeededQuoteStyle() -------------------------------------

// constructor
/*
    Set blast host, program etc. to compile-time defaults,
    try opening blastrc file and read new values from it,
    see if TMPDIR envvar is set,
        if so, set temporary file to $TMPDIR/blast_out
	else set it to P_tmpdir/blast_out
    (P_tmpdir is defined in stdio.h)
  */
blastConfig::blastConfig()
{
    ifstream fin;
    char tmp[MAX_STRLEN];

    // set defaults
    sprintf( fBlastHost, "%s", ENGINE_HOST );
    sprintf( fBlastProg, "%s", PROGRAM_NAME );
    fBlastPort = ENGINE_PORT;
    sprintf( fCommentFile, "%s", COMMENT_FILE_NAME );
    sprintf( fLogFile, "%s", LOG_FILE_NAME );
    fQuiet = false;
    fSeqDet = false;
    

    // now try to read in rc file
    fin.open( RC_FILE_NAME );
    if( !fin ) 
        cerr << "Error opening " << RC_FILE_NAME << ". Using compile-time defaults." << endl;
    else
    {
        while( !fin.eof() )
        {
            memset( tmp, 0, MAX_STRLEN );
            fin.getline( tmp, MAX_STRLEN - 1, '\n' );
// blast host
            if( strncasecmp( tmp, "blasthost", 9 ) == 0 )
            {
                for (unsigned i = 9; i < strlen( tmp ); i++)
                {
                    if( tmp[i] == '=' )
                    {
                        do
                            i++;
                        while( (tmp[i] == ' ') || (tmp[i] == '\t') ); // skip blanks
                        if( tmp[i] != '\0' )
                            sprintf( fBlastHost, "%s", &(tmp[i]) );
                    }
                }
            }
            else if( strncasecmp( tmp, "blastprog", 9 ) == 0 )
// blast program
            {
                for (unsigned i = 9; i < strlen( tmp ); i++)
                {
                    if( tmp[i] == '=' )
                    {
                        do
                            i++;
                        while( (tmp[i] == ' ') || (tmp[i] == '\t') ); // skip blanks
                        if( tmp[i] != '\0' )
                            sprintf( fBlastProg, "%s", &(tmp[i]) );
                    }
                }
            }
            else if( strncasecmp( tmp, "blastport", 9 ) == 0 )
// blast port
            {
                char s[MAX_STRLEN];
                memset( s, 0, MAX_STRLEN );
                for (unsigned i = 9; i < strlen( tmp ); i++)
                {
                    if( tmp[i] == '=' )
                    {
                        do
                            i++;
                        while( (tmp[i] == ' ') || (tmp[i] == '\t') ); // skip blanks
                        if( tmp[i] != '\0' )
                            sprintf( s, "%s", &(tmp[i]) );
                    }
                }
                fBlastPort = (unsigned) atoi( s );
            }
            else if( strncasecmp( tmp, "commentfile", 11 ) == 0 )
// comment file
            {
                for (unsigned i = 9; i < strlen( tmp ); i++)
                {
                    if( tmp[i] == '=' )
                    {
                        do
                            i++;
                        while( (tmp[i] == ' ') || (tmp[i] == '\t') ); // skip blanks
                        if( tmp[i] != '\0' )
                            sprintf( fCommentFile, "%s", &(tmp[i]) );
                    }
                }
            }
            else if( strncasecmp( tmp, "logfile", 11 ) == 0 )
// log file
            {
                for (unsigned i = 9; i < strlen( tmp ); i++)
                {
                    if( tmp[i] == '=' )
                    {
                        do
                            i++;
                        while( (tmp[i] == ' ') || (tmp[i] == '\t') ); // skip blanks
                        if( tmp[i] != '\0' )
                            sprintf( fLogFile, "%s", &(tmp[i]) );
                    }
                }
            }
        } // endwhile
        fin.close();
    }
// query file where query results are saved
    char *tmpstr;

// try opening file in $TMPDIR, fall back on P_tmpdir if that's not set
    memset( fQueryFile, 0, MAX_STRLEN );
    if( (tmpstr = getenv( "TMPDIR" )) != NULL )
        strncpy( fQueryFile, tmpstr, strlen( tmpstr ));
    else
        strncpy( fQueryFile, P_tmpdir, strlen( P_tmpdir ) );
    strcat( fQueryFile, "/" );
    strcat( fQueryFile, "blast_out" );
} // constructor blastConfig()
//---------------------------- eof blastConfig.cc ----------------------------------------










































