/*
 * FILE:         $Source: /cvs_archive/cvs/blast/blastDeposit.h,v $
 * 
 * DESCRIPTION:  declarations for class blastDeposit
 *
 * AUTHOR:       $Author: dmaziuk $
 *
 * DATE:         $Date: 2001/01/11 23:48:28 $
 *
 * UPDATE HISTORY
 * --------------
 * $Log: blastDeposit.h,v $
 * Revision 2.1  2001/01/11 23:48:28  dmaziuk
 * No changes, just forgot to add *.h files before commit.
 *
 */
#ifndef BLASTDEPOSIT_H
#define BLASTDEPOSIT_H

#include <iostream.h>
#include <iomanip.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <ctype.h>

#ifdef IS_IRIX
#  include <mstring.h>
#  include <vector.h>
#endif

#ifdef IS_GCC
#  include <string>
#  include <vector>
#endif

#include "list.h"
#include "astlist.h"
#include "astnode.h"
#include "scanner.h"
#include "ast.h"
#include "parser.h"
#include "portability.h"

#include "constants.h"
#include "blastConfig.h"
#include "dataEntries.h"

const int MaxRow = 2000;
const int MaxLine = 512;
const int MaxSeq = 2000;
const int MaxDigit = 20;
const int MaxRid = 40;
const int MaxName = 20;
const int MaxMolName = 400;


const int DataNum = 8; //data listed in the blast output loop - db_name, db_code,
                       //db_mol_name, seq_comp, seq_len, seq_id, seq_pos, seq_exp


extern StarFileNode *inputStarFile;

extern bool BLASTP, BLASTN, CARBO; // to decide which "program" to use
extern int limitId;

// blastDeposit class
/** class for depositing relevant data into starfile.
    <p>
    BlastDeposit contains public methods <br>
    depositMonoPoly() and depositMolSys, for depositing data
    into <b>monomeric polymers</b> and <b>molecular system description</b>
    frames, resp.
  */
class blastDeposit
{
  public:
    /** constructor. <br>
        Sets up a pointer to blastConfig object.
        @see blastConfig
      */ 
    blastDeposit( blastConfig *bc ) { bl_config = bc; }
    /** another way to set up the pointer to blastConfig object.
      *@see blastConfig
      */ 
    inline void setConfig( blastConfig *bc ) { bl_config = bc; }
    /** creates a loop inside "Polymer residue sequence" frame. <br>
        @param save_frame pointer to SaveFrameNode.
        @param data vector of dataEntry objects.
        @param revise if true, revise the loop.
        @return negative value on error, 0 otherwise.
        @see dataEntries
      */
    int depositMonoPoly( SaveFrameNode *save_frame,
                         const dataEntries *data, 
                         bool revise );
    /** creates a loop  inside "Molecular system description" frame. <br>
        @param data -- vector of dataEntry.
        @return negative value on error, 0 otherwise.
	@see dataEntries
      */
    int depositMolSys( const dataEntries& data );
    
  private:
    void remove_old_dataloop(SaveFrameNode *save_frame);
    string trim( string& str );
    string trim( char *str );
    blastConfig *bl_config;
};

#endif  // BLAST_H


	
	



