/*
 * FILE:         $Source: /cvs_archive/cvs/blast/blastSearch.h,v $
 * 
 * DESCRIPTION:  declarations for blastSearch: 
 *               class for doing blast search by opening a socket 
 *               to the BLAST server and speaking the HTTP protocol.
 *
 * AUTHOR:       $Author: dmaziuk $
 *
 * DATE:         $Date: 2001/01/11 23:48:28 $
 *
 * UPDATE HISTORY
 * --------------
 * $Log: blastSearch.h,v $
 * Revision 2.1  2001/01/11 23:48:28  dmaziuk
 * No changes, just forgot to add *.h files before commit.
 *
 */
#ifndef BLASTSEARCH_H
#define BLASTSEARCH_H

#include <iostream.h>
#include <fstream.h>
#include <strstream.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>        // sleep()
#include <stdlib.h>        // realloc(), getenv()

#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h> 
#include <sys/resource.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <arpa/inet.h>
#include <errno.h>
#include <wait.h>
#include <fcntl.h>

#include "list.h"
#include "astlist.h"
#include "astnode.h"
#include "ast.h"
#include "portability.h"
#include "blastConfig.h"
#include "constants.h"

#define HUGE_STRING_LEN 1024
#define MAX_STR         512
#define MAX_RID         40
#define MAX_HNAME       128

// blastSearch class
/** class that runs CGI query on BLAST site.
    <p>
    This class runs CGI query on BLAST site
    and saves result in /tmp/blast_out.
  */
class blastSearch
{
  public:
    /** constructor. <br>
        Sets up a pointer to blastConfig object.
        @see blastConfig
      */  
    blastSearch( blastConfig *bc );

    /** another way to set up the pointer to blastConfig object.
        @see blastConfig
      */
    inline void setConfig( blastConfig *bc ) { bl_config = bc; };

    /** Open socket to BLAST site, send CGI queries and save result as /tmp/blast_out.
        <p>
        URL of the BLAST site, web server port, CGI program name and 
        path to output file are stored in blastConfig object. <br>
        Residue sequence(s) (query string) are in the input file, <br>
        so is molecular class (used to decide which BLAST program to use: 
        blastp, blastn or carbo). <br>
        <p>
        BLAST site requires that query is sent in two chunks: <br>
        first we send residue sequence and get the RID, <br>
        then we send RID and get the result.
	<p>
        @param save_frame -- output, pointer to SaveFrameNode
        @return -1 on error, 0 otherwise
	@see blastConfig
      */
    int do_blast_search(SaveFrameNode *save_frame); // in "ast.h"

  private:
    int send_seq( char rid[MAX_RID], char seq[MAX_SEQ] );
    int send_rid( char *RID );
    bool send_blast_request( char *query_string );
    char *read_file_into_memory( FILE *fd, int len, int filter );
    void error_handler( int error );
    blastConfig *bl_config;
};



#endif // BLASTSEARCH_H
