/*
 * FILE:         $Source: /cvs_archive/cvs/blast/dataEntries.cc,v $
 * 
 * DESCRIPTION:  definitions for class dataEntries
 *
 * AUTHOR:       $Author: dmaziuk $
 *
 * DATE:         $Date: 2001/01/11 23:44:44 $
 *
 * UPDATE HISTORY
 * --------------
 * $Log: dataEntries.cc,v $
 * Revision 2.0  2001/01/11 23:44:44  dmaziuk
 * Version 2 of blast contains complete rewrite of blastParser and major rewrite
 * of (almost) everything else.
 *
 */

#include "dataEntries.h"

/** constructor
  */
dataEntries::dataEntries()
{
    for( int i = 0; i < blastConfig::NumDbs; i++ )
	fCounters[i] = 0;
} //-------------------------------------------------------

/** destructor: remove elements
  */
dataEntries::~dataEntries()
{
    erase( begin(), end() );
} //-------------------------------------------------------

/** add an entry
  *
  * @param data entry to add
  *
  * @return negative value on error, 0 otherwise
  */
int dataEntries::add( dataEntry new_entry )
{
    int i;
#ifdef DEBUG
  cout << "dataEntries::add() : inserting new entry...";
#endif
// check that there's < 6 entries for DBs other than PDB
    i = blastConfig::getNameIdx( new_entry.getName() );
    if( i != blastConfig::pdb )
	if( fCounters[i] > blastConfig::MaxXEntries - 1 ) 
	{
#ifdef DEBUG
  cout << "dataEntries::add() : not inserting " << i << " -- count = " << fCounters[i] << endl;
#endif
	    return 0;
	}

// check for duplicate entries
    for( dataEntries::iterator d = begin(); d != end(); d++ )
//	if( (d->getName() == new_entry.getName()) && (d->getCode() == new_entry.getCode()) )
        if ( *d == new_entry )
	    return 0;
    this->insert( this->end(), new_entry );
    fCounters[blastConfig::getNameIdx( new_entry.getName() )]++;
#ifdef DEBUG
  cout << "done, counts:" << endl;
  for( i = 0; i < blastConfig::NumDbs; i++ )
      cout << blastConfig::getName( i ) << "=" << fCounters[i] << " ";
  cout << endl;
#endif
} //------------------------------------------------------------------

/** sort the vector
  *   std::sort uses "<" operator of dataEntry to sort the vector.
  *   dataEntry::< is defined so that entries with greater Id come first
  */
void dataEntries::sort()
{
    std::sort( begin(), end() );
}
