/*
 * FILE:         $Source: /cvs_archive/cvs/blast/dataEntries.h,v $
 * 
 * DESCRIPTION:  declarations for class abbreviatedEntry
 *
 * AUTHOR:       $Author: dmaziuk $
 *
 * DATE:         $Date: 2001/01/11 23:44:44 $
 *
 * UPDATE HISTORY
 * --------------
 * $Log: dataEntries.h,v $
 * Revision 2.0  2001/01/11 23:44:44  dmaziuk
 * Version 2 of blast contains complete rewrite of blastParser and major rewrite
 * of (almost) everything else.
 *
 */
#ifndef DATAENTRIES_H
#define DATAENTRIES_H

#include <iostream.h>
#include <iomanip.h>
#include <string.h>

#ifdef IS_IRIX
#  include <mstring.h>
#  include <vector.h>
#  include <algo.h>
#endif

#ifdef IS_GCC
#  include <string>
#  include <vector>
#  include <algorithm>  
#endif

#include "dataEntry.h"
#include "blastConfig.h"

// class dataEntries
/** vector of dataEntry objects with a few extra members and methods.
    <p>
    This class is a vector, all standard members of vector are available. <br>
    In addition <code>dataEntries</code> <br>
    keeps count of how many entries from each database it has, so that
    we can limit the number of entries to deposit on a per-database
    basis, and<br>
    has methods to get those counts and to sort the vector.<br>
    @see dataEntry
  */
class dataEntries : public vector<dataEntry>
{
    friend class dataEntry;
    
  public:
    /** constructor.
        <p>
        Initializes counters to 0.
      */
    dataEntries();
    
    /** destructor.
        <p>
        Erases vector's contents.
      */ 
    ~dataEntries();
    
    /** add an entry to the vector.
        <p>
        All PDB entries except duplicates are added to the vector. 
        For non-pdb entries <code>add()</code> checks the corresponding 
        counter against <code>MaxXEntries</code> constant declared in 
        <code>blastConfig</code>. If counter is less than 
        <code>MaxXEntries</code>, or it's a PDB entry, the entry is 
        compared to all other entries in the vector. If it is not already 
        in the vector, it is added and corresp. counter is incremented.
        @param entry dataEntry to add.
        @return negative value on error, 0 otherwise
        @see dataEntry
        @see blastConfig
      */
    int add( dataEntry entry );
    
    /** sort the vector.
     *  <p>
     *  <code>Sort()</code> uses the standard algorithm to sort the
     *  vector. See <code>operator <</code> in <code>dataEntry</code>
     *  class.
     *  @see dataEntry
     */
    void sort();
    /** returns count of entries from a particular database.
     *  <p>
     *  <code>getCount()</code> is used mainly for debugging/diagnostic.
     *  @param db_index database index (one of the database index constans
     *   declared in blastConfig class).
     *  @return number of entries from that database.
     *  @see blastConfig
     */
    int getCount( int db_index ) { return fCounters[db_index]; }

  private:
    int fCounters[blastConfig::NumDbs];
};


#endif // DATAENTRIES_H
