/*
 * FILE:         $Source: /cvs_archive/cvs/blast/dataEntry.cc,v $
 * 
 * DESCRIPTION:  declarations for class abbreviatedEntry
 *
 * AUTHOR:       $Author: dmaziuk $
 *
 * DATE:         $Date: 2001/01/17 22:52:36 $
 *
 * UPDATE HISTORY
 * --------------
 * $Log: dataEntry.cc,v $
 * Revision 2.1  2001/01/17 22:52:36  dmaziuk
 * Fixed a bug where wrong sequence length was deposited into starfile.
 *
 * Revision 2.0  2001/01/11 23:44:44  dmaziuk
 * Version 2 of blast contains complete rewrite of blastParser and major rewrite
 * of (almost) everything else.
 *
 */

#include "dataEntry.h"

/** constructor dataEntry()
  *  Initialize member variables.
  */
dataEntry::dataEntry( dataEntries *parent, blastConfig *config )
{
    fLength = 0;
    fSeqLen = 0;
    fComp = 0;
    fId = 0;
    fPos= 0;
    fIdCount = 0;
    fPullOut = false;
    fParent = parent;
    fConfig = config;
} //-----------------------------------------------------------------------

/** destructor ~dataEntry()
  * Erase strings.
  */ 
dataEntry::~dataEntry()
{
    fExp.erase();
    fName.erase();
    fCode.erase();
    fMolName.erase();
    fDetails.erase(); 
} //------------------------------------------------------------------------

/** operator < is used by sort() template. Since we want entries sorted in
  *  descending order of Id, with pdb on top, this operator returns true if 
  * this.fId > other.fId or this.fId == other.fId and this.fName < other.fName
  *  See blastConfig.h for fName ordering (blastConfig::pdb etc.)
  */
bool dataEntry::operator< ( const dataEntry &entry )
{
    if( blastConfig::getNameIdx( getName() ) < blastConfig::getNameIdx( entry.getName() ) )
	return true;
    else if( (blastConfig::getNameIdx( getName() ) == blastConfig::getNameIdx( entry.getName() ))
	    && (getId() > entry.getId()) )
	return true;
//    if( getId() > entry.getId() ) return true;
//    else if( (getId() == entry.getId())
//    && (blastConfig::getNameIdx( getName() ) < blastConfig::getNameIdx( entry.getName() )) )
//	return true;
    return false;
} //------------------------------------------------------------------------

/** operator == 
  */
bool dataEntry::operator== ( const dataEntry &entry )
{
    if( blastConfig::getNameIdx( getName() ) 
       == blastConfig::getNameIdx( entry.getName() ) )
	if( getCode() == entry.getCode() )
	    return true;
    return false;
} //------------------------------------------------------------------------

/** operator > returns true if this.fId < other.fId 
  *   or this.fId == other.fId and this.fName > other.fName
  *  (see "<" operator for explanation)
  *  See blastConfig.h for fName ordering (blastConfig::pdb etc.)
  */
bool dataEntry::operator> ( const dataEntry &entry )
{
    if( blastConfig::getNameIdx( getName() ) > blastConfig::getNameIdx( entry.getName() ) )
	return true;
    else if( (blastConfig::getNameIdx( getName() ) == blastConfig::getNameIdx( entry.getName() ))
	    && (getId() < entry.getId()) )
	return true;
//    if( getId() < entry.getId() ) return true;
//    else if( (getId() == entry.getId()) 
//    && (blastConfig::getNameIdx( getName() ) > blastConfig::getNameIdx( entry.getName() )) )
//	return true;
    return false;
} //------------------------------------------------------------------------

/** print() prints the object to cout
  */
void dataEntry::print()
{
    cout << "dataEntry:" << endl;
    cout << "DB Name=" << fName.c_str();
    cout << " accession code=" << fCode.c_str() << endl;
    cout << "Mol. system descr.=" << fMolName.c_str() << endl;
    cout << "Length=" << fLength << " Seq.len=" << fSeqLen << " Comp=" << fComp;
    cout << " Id=" << fId << " Pos=" << fPos << " Id cnt=" << fIdCount;
    cout << " Pull out=" << ( fPullOut ? "yes" : "no" ) << endl;
    cout << "Expect=" << fExp.c_str() << " details: " << endl;
    cout << fDetails.c_str() << endl;
    cout.flush();
}
//------ eof dataEntry.cc --------------------------------------------------








