/*
 * FILE:         $Source: /cvs_archive/cvs/blast/main.h,v $
 * 
 * DESCRIPTION:  header file for main()
 *
 * AUTHOR:       $Author: dmaziuk $
 *
 * DATE:         $Date: 2001/03/15 22:33:35 $
 *
 * UPDATE HISTORY
 * --------------
 * $Log: main.h,v $
 * Revision 2.1  2001/03/15 22:33:35  dmaziuk
 * Disabled deposition of PDB entries in molecular system description frame.
 *
 * Revision 2.0  2001/01/11 23:44:45  dmaziuk
 * Version 2 of blast contains complete rewrite of blastParser and major rewrite
 * of (almost) everything else.
 *
 */
#ifndef MAIN_H
#define MAIN_H

#include <fstream.h>
#include <iostream.h>
#include <stdio.h>
#include <string.h>

#ifdef IS_IRIX
#  include <mstring.h>
#  include <vector.h>
#endif

#ifdef IS_GCC
#  include <string>
#  include <vector>
#endif

#include "list.h"
#include "astlist.h"
#include "astnode.h"
#include "ast.h"
#include "portability.h"

#include "parser.h"
#include "scanner.h"

#include "constants.h"
#include "blastConfig.h"
#include "blastSearch.h"
#include "blastParser.h"
#include "blastDeposit.h"
#include "dataEntry.h"
#include "dataEntries.h"

const int MaxFileName = 50;

StarFileNode *inputStarFile;

bool BLASTP,
     BLASTN,
     CARBO;  // to decide which "program" to use

int limitId;

#endif // MAIN_H
