/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.starlibj;

import EDU.bmrb.starlibj.BadValueForDelimiter;
import EDU.bmrb.starlibj.DataNameNode;
import EDU.bmrb.starlibj.DataValueNode;
import EDU.bmrb.starlibj.NameViolatesStarSyntax;
import EDU.bmrb.starlibj.StarNode;
import EDU.bmrb.starlibj.StarValidity;
import EDU.bmrb.starlibj.VectorCheckType;

public class DataItemNode
extends StarNode {
    protected DataNameNode myDataName;
    protected DataValueNode myDataValue;

    public DataItemNode(DataNameNode name, DataValueNode value) throws NameViolatesStarSyntax {
        this.myDataName = new DataNameNode(name);
        this.myDataValue = new DataValueNode(value);
        this.myDataValue.setParent((StarNode)this);
    }

    public DataItemNode(String name, String value) throws NameViolatesStarSyntax, BadValueForDelimiter {
        this.myDataName = new DataNameNode(name);
        this.myDataValue = new DataValueNode(value, DataValueNode.NON);
        this.myDataValue.setParent((StarNode)this);
    }

    public DataItemNode(String name, String value, short delim) throws NameViolatesStarSyntax, BadValueForDelimiter {
        this.myDataName = new DataNameNode(name);
        this.myDataValue = new DataValueNode(value, delim);
        this.myDataValue.setParent((StarNode)this);
    }

    public DataItemNode(DataItemNode copyMe) {
        super((StarNode)copyMe);
        this.myDataName = (DataNameNode)copyMe.myDataName.clone();
        this.myDataValue = (DataValueNode)copyMe.myDataValue.clone();
        this.myDataValue.setParent((StarNode)this);
    }

    public Object clone() {
        return new DataItemNode(this);
    }

    public short getDelimType() {
        return this.myDataValue.getDelimType();
    }

    public void setDelimType(short delim) throws BadValueForDelimiter {
        this.myDataValue.setDelimType(delim);
    }

    public String getValue() {
        return this.myDataValue.getValue();
    }

    public DataValueNode getValueNode() {
        return this.myDataValue;
    }

    public void setValue(String val) throws BadValueForDelimiter {
        this.myDataValue.setValue(val);
    }

    public void setValue(String val, short delim) throws BadValueForDelimiter {
        this.myDataValue.setValue(val, delim);
    }

    public String getLabel() {
        return this.myDataName.getLabel();
    }

    public DataNameNode getNameNode() {
        return this.myDataName;
    }

    public void setLabel(String name) throws NameViolatesStarSyntax {
        this.myDataName = new DataNameNode(name);
    }

    public VectorCheckType searchByName(String searchFor) {
        VectorCheckType retVal = new VectorCheckType();
        try {
            retVal.addType(Class.forName(StarValidity.clsNameStarNode));
            retVal.freezeTypes();
            if (this.myDataName.getLabel().equalsIgnoreCase(searchFor)) {
                retVal.addElement((Object)this);
            }
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
        }
        return retVal;
    }

    public VectorCheckType searchByTagValue(String tag, String value) {
        VectorCheckType retVal = new VectorCheckType();
        try {
            retVal.addType(Class.forName(StarValidity.clsNameStarNode));
            retVal.freezeTypes();
            if (this.myDataName.getLabel().equalsIgnoreCase(tag) && this.myDataValue.getValue().equals(value)) {
                retVal.addElement((Object)this);
            }
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
        }
        return retVal;
    }

    public VectorCheckType searchForType(Class type, short delim) {
        VectorCheckType retVal = new VectorCheckType();
        try {
            retVal.addType(Class.forName(StarValidity.clsNameStarNode));
            retVal.freezeTypes();
            if (type.isInstance(this)) {
                retVal.addElement((Object)this);
            }
            if (type.isInstance(this.myDataValue) && (delim == this.myDataValue.getDelimType() || delim == DataValueNode.DONT_CARE)) {
                retVal.addElement((Object)this.myDataValue);
            }
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
        }
        return retVal;
    }

    public void Unparse(int indent) {
    }
}

