/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.starlibj;

import EDU.bmrb.starlibj.BadValueForDelimiter;
import EDU.bmrb.starlibj.StarNode;
import EDU.bmrb.starlibj.StarValidity;

public class DataValueNode
extends StarNode
implements Cloneable {
    public static short DONT_CARE = (short)-1;
    public static short NON;
    public static short DOUBLE;
    public static short SINGLE;
    public static short SEMICOLON;
    public static short FRAMECODE;
    protected String myStrVal;
    protected short delimType;

    public short getDelimType() {
        return this.delimType;
    }

    public void setDelimType(short setTo) throws BadValueForDelimiter {
        if (!StarValidity.isValidForDelim((String)this.myStrVal, (int)setTo)) {
            throw new BadValueForDelimiter(this.myStrVal, setTo);
        }
        this.delimType = setTo;
    }

    public String getValue() {
        return this.myStrVal;
    }

    public void setValue(String newVal) throws BadValueForDelimiter {
        if (!StarValidity.isValidForDelim((String)newVal, (int)this.delimType)) {
            throw new BadValueForDelimiter(newVal, this.delimType);
        }
        this.myStrVal = newVal;
    }

    public void setValue(String newVal, short newDelim) throws BadValueForDelimiter {
        if (!StarValidity.isValidForDelim((String)newVal, (int)newDelim)) {
            throw new BadValueForDelimiter(newVal, newDelim);
        }
        this.myStrVal = newVal;
        this.delimType = newDelim;
    }

    public DataValueNode(String str) throws BadValueForDelimiter {
        this.myStrVal = str;
        short i = NON;
        while (i <= SEMICOLON) {
            if (StarValidity.isValidForDelim((String)str, (int)i)) {
                this.delimType = i;
                break;
            }
            i = (short)(i + 1);
        }
        if (i > SEMICOLON) {
            throw new BadValueForDelimiter(str, i);
        }
    }

    public DataValueNode(String str, short delim) throws BadValueForDelimiter {
        if (!StarValidity.isValidForDelim((String)str, (int)delim)) {
            throw new BadValueForDelimiter(str, delim);
        }
        this.myStrVal = str;
        this.delimType = delim;
    }

    public DataValueNode(DataValueNode copyMe) {
        super((StarNode)copyMe);
        this.myStrVal = copyMe.getValue() == null ? null : new String(copyMe.getValue());
        this.delimType = copyMe.getDelimType();
    }

    public Object clone() {
        return new DataValueNode(this);
    }

    public String getLabel() {
        return this.myStrVal;
    }

    public void Unparse(int indent) {
    }

    public int myLongestStr() {
        int retVal = this.myStrVal.length();
        if (this.delimType == NON) {
            ++retVal;
        } else if (this.delimType == SINGLE) {
            retVal += 2;
        } else if (this.delimType == DOUBLE) {
            retVal += 2;
        } else if (this.delimType == FRAMECODE) {
            ++retVal;
        } else if (this.delimType == SEMICOLON) {
            retVal += 4;
        }
        return retVal;
    }

    static {
        DOUBLE = 1;
        SINGLE = (short)2;
        SEMICOLON = (short)3;
        FRAMECODE = (short)4;
    }
}

