/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.starlibj;

import EDU.bmrb.starlibj.DataLoopNode;
import EDU.bmrb.starlibj.DataValueNode;
import EDU.bmrb.starlibj.LoopRowNode;
import EDU.bmrb.starlibj.LoopRowsVector;
import EDU.bmrb.starlibj.OperationCausesMismatchedLoopData;
import EDU.bmrb.starlibj.StarNode;
import EDU.bmrb.starlibj.StarValidity;
import EDU.bmrb.starlibj.VectorCheckType;
import java.util.Enumeration;
import java.util.Vector;

public class LoopTableNode
extends StarNode
implements Cloneable {
    protected boolean myTabFlag;
    protected LoopRowsVector myRows = new LoopRowsVector();
    protected boolean myIndentFlag;
    protected int myRowsPerLine;

    public LoopTableNode() {
        this.myTabFlag = false;
        this.myIndentFlag = true;
        this.myRowsPerLine = 1;
    }

    public LoopTableNode(boolean tabFlag) {
        this.myTabFlag = tabFlag;
        this.myIndentFlag = true;
        this.myRowsPerLine = 1;
    }

    public LoopTableNode(boolean tabFlag, boolean indentFl, int rowsPerLn) {
        this.myTabFlag = tabFlag;
        this.myIndentFlag = indentFl;
        this.myRowsPerLine = rowsPerLn;
    }

    public LoopTableNode(LoopTableNode copyMe) {
        this.myTabFlag = copyMe.myTabFlag;
        this.myIndentFlag = copyMe.myIndentFlag;
        this.myRowsPerLine = copyMe.myRowsPerLine;
        int i = 0;
        while (i < copyMe.size()) {
            this.addElement((LoopRowNode)copyMe.elementAt(i).clone());
            ++i;
        }
    }

    public Object clone() {
        return new LoopTableNode(this);
    }

    public void setSize(int newSize) {
        this.myRows.setSize(newSize);
    }

    public int capacity() {
        return this.myRows.capacity();
    }

    public int size() {
        return this.myRows.size();
    }

    public boolean isEmpty() {
        return this.myRows.isEmpty();
    }

    public Enumeration elements() {
        return this.myRows.elements();
    }

    public boolean contains(LoopRowNode row) {
        return this.myRows.contains((Object)row);
    }

    public int indexOf(LoopRowNode val) {
        return this.myRows.indexOf((Object)val);
    }

    public int indexOf(LoopRowNode row, int index) {
        return this.myRows.indexOf((Object)row, index);
    }

    public int lastIndexOf(LoopRowNode row) {
        return this.myRows.lastIndexOf((Object)row);
    }

    public int lastIndexOf(LoopRowNode row, int index) {
        return this.myRows.lastIndexOf((Object)row, index);
    }

    public LoopRowNode elementAt(int index) {
        return (LoopRowNode)this.myRows.elementAt(index);
    }

    public LoopRowNode firstElement() {
        return (LoopRowNode)this.myRows.firstElement();
    }

    public LoopRowNode lastElement() {
        return (LoopRowNode)this.myRows.lastElement();
    }

    public void setElementAt(LoopRowNode row, int index) throws OperationCausesMismatchedLoopData {
        this.myRows.setElementAt((Object)row, index);
        ((LoopRowNode)this.myRows.elementAt(index)).setParent((StarNode)this);
    }

    public void removeElementAt(int index) {
        StarNode par;
        ((LoopRowNode)this.myRows.elementAt(index)).setParent(null);
        this.myRows.removeElementAt(index);
        if (this.size() == 0 && (par = this.getParent()) != null && par instanceof LoopRowNode) {
            ((LoopRowNode)par).removeInnerLoop();
        }
    }

    public void insertElementAt(LoopRowNode row, int index) {
        this.myRows.insertElementAt((Object)row, index);
        ((LoopRowNode)this.myRows.elementAt(index)).setParent((StarNode)this);
    }

    public void addElement(LoopRowNode row) {
        this.myRows.addElement((Object)row);
        ((LoopRowNode)this.myRows.lastElement()).setParent((StarNode)this);
    }

    public boolean removeElement(LoopRowNode row) {
        StarNode par;
        row.setParent(null);
        boolean retVal = this.myRows.removeElement((Object)row);
        if (this.size() == 0 && (par = this.getParent()) != null && par instanceof LoopRowNode) {
            ((LoopRowNode)par).removeInnerLoop();
        }
        return retVal;
    }

    void removeColumnAtDepth(int depth, int columnIdx) {
        int i = 0;
        while (i < this.myRows.size()) {
            ((LoopRowNode)this.myRows.elementAt(i)).removeColumnAtDepth(depth, columnIdx);
            ++i;
        }
    }

    void insertColumnAtDepth(int depth, int columnIdx, DataValueNode val) {
        int i = 0;
        while (i < this.myRows.size()) {
            ((LoopRowNode)this.myRows.elementAt(i)).insertColumnAtDepth(depth, columnIdx, val);
            ++i;
        }
    }

    public int isInLoop() {
        LoopTableNode par = this;
        int retVal = 0;
        par = this;
        retVal = 0;
        while (par != null && !(par instanceof DataLoopNode)) {
            if (par instanceof LoopTableNode) {
                ++retVal;
            }
            par = par.getParent();
        }
        if (par == null) {
            return 0;
        }
        return retVal;
    }

    public void Unparse(int indent) {
    }

    public void setTabFlag(boolean tabFlag) {
        this.myTabFlag = tabFlag;
        int i = 0;
        while (i < this.size()) {
            LoopTableNode iLoop = this.elementAt(i).getInnerLoop();
            if (iLoop != null) {
                iLoop.setTabFlag(tabFlag);
            }
            ++i;
        }
    }

    public boolean getTabFlag() {
        return this.myTabFlag;
    }

    public void setIndentFlag(boolean tabFlag) {
        this.myIndentFlag = tabFlag;
    }

    public boolean getIndentFlag() {
        return this.myIndentFlag;
    }

    public void setRowsPerLine(int setTo) {
        this.myRowsPerLine = setTo;
    }

    public int getRowsPerLine() {
        return this.myRowsPerLine;
    }

    public VectorCheckType searchForType(Class type) {
        VectorCheckType retVal = new VectorCheckType();
        try {
            retVal.addType(Class.forName(StarValidity.clsNameStarNode));
            retVal.freezeTypes();
            if (type.isInstance(this)) {
                retVal.addElement((Object)this);
            }
            int i = 0;
            while (i < this.myRows.size()) {
                VectorCheckType tmpVect = ((LoopRowNode)this.myRows.elementAt(i)).searchForType(type);
                int j = 0;
                while (j < tmpVect.size()) {
                    retVal.addElement(tmpVect.elementAt(j));
                    ++j;
                }
                ++i;
            }
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
        }
        return retVal;
    }

    public VectorCheckType searchForType(Class type, short delim) {
        VectorCheckType retVal = new VectorCheckType();
        try {
            retVal.addType(Class.forName(StarValidity.clsNameStarNode));
            retVal.freezeTypes();
            if (type == this.getClass()) {
                retVal.addElement((Object)this);
            }
            int i = 0;
            while (i < this.myRows.size()) {
                VectorCheckType tmpVect = ((LoopRowNode)this.myRows.elementAt(i)).searchForType(type, delim);
                int j = 0;
                while (j < tmpVect.size()) {
                    retVal.addElement(tmpVect.elementAt(j));
                    ++j;
                }
                ++i;
            }
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
        }
        return retVal;
    }

    protected int getMyDepth() {
        LoopTableNode par = this;
        int retVal = -1;
        while (par != null && !(par instanceof DataLoopNode)) {
            if (par instanceof LoopTableNode) {
                ++retVal;
            }
            par = par.getParent();
        }
        if (par == null) {
            return -1;
        }
        return retVal;
    }

    protected int getMaxDepth() {
        LoopTableNode par = this;
        int retVal = -1;
        while (par != null && !(par instanceof DataLoopNode)) {
            par = par.getParent();
        }
        if (par == null) {
            return -1;
        }
        return ((DataLoopNode)par).getNames().size() - 1;
    }

    protected void truncateNestLevel(int depth) {
        if (depth == 0) {
            while (this.myRows.size() > 0) {
                this.myRows.removeElementAt(0);
            }
        } else {
            int i = 0;
            while (i < this.myRows.size()) {
                if (((LoopRowNode)this.myRows.elementAt(i)).getInnerLoop() != null) {
                    ((LoopRowNode)this.myRows.elementAt(i)).getInnerLoop().truncateNestLevel(depth - 1);
                    if (depth == 1) {
                        ((LoopRowNode)this.myRows.elementAt(i)).removeInnerLoop();
                    }
                }
                ++i;
            }
        }
    }

    protected VectorCheckType searchForValsInColumn(int searchNest, int searchCol, String value) {
        VectorCheckType retVal = new VectorCheckType();
        try {
            retVal.addType(Class.forName(StarValidity.clsNameStarNode));
            retVal.freezeTypes();
            int i = 0;
            while (i < this.size()) {
                if (searchNest == 0) {
                    if (this.elementAt(i).elementAt(searchCol).getValue().equals(value)) {
                        retVal.addElement((Object)this.elementAt(i).elementAt(searchCol));
                    }
                } else if (this.elementAt(i).getInnerLoop() != null) {
                    VectorCheckType tmpVal = this.elementAt(i).getInnerLoop().searchForValsInColumn(searchNest - 1, searchCol, value);
                    int j = 0;
                    while (j < tmpVal.size()) {
                        retVal.addElement(tmpVal.elementAt(j));
                        ++j;
                    }
                    tmpVal = null;
                }
                ++i;
            }
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
        }
        return retVal;
    }

    protected void calcPrintSizes(Vector preSizes, Vector postSizes) {
        int numCols = 0;
        int curCol = 0;
        if (this.myRows.size() > 0) {
            numCols = this.elementAt(0).size();
        }
        if (numCols == 0) {
            return;
        }
        curCol = 0;
        while (curCol < numCols) {
            preSizes.addElement(new Integer(0));
            postSizes.addElement(new Integer(-1));
            ++curCol;
        }
        int outer_idx = 0;
        while (outer_idx < this.myRows.size()) {
            LoopRowNode curRow = this.elementAt(outer_idx);
            int inner_idx = 0;
            while (inner_idx < curRow.size()) {
                String curStr = curRow.elementAt(inner_idx).getValue();
                int curPre = curRow.elementAt(inner_idx).myLongestStr();
                int curPost = -1;
                if (curRow.elementAt(inner_idx).getDelimType() == DataValueNode.NON) {
                    String tmpStr = new String(curStr);
                    int sLen = tmpStr.length();
                    int curIdx = 0;
                    int dotIdx = -1;
                    while (curIdx < sLen && Character.isWhitespace(tmpStr.charAt(curIdx))) {
                        ++curIdx;
                    }
                    if (curIdx < sLen && (tmpStr.charAt(curIdx) == '-' || tmpStr.charAt(curIdx) == '+')) {
                        ++curIdx;
                    }
                    while (curIdx < sLen && Character.isDigit(tmpStr.charAt(curIdx))) {
                        ++curIdx;
                    }
                    curPre = curIdx;
                    if (curIdx < sLen && tmpStr.charAt(curIdx) == '.') {
                        dotIdx = curIdx++;
                    }
                    curPost = 0;
                    while (curIdx < sLen && Character.isDigit(tmpStr.charAt(curIdx))) {
                        ++curPost;
                        ++curIdx;
                    }
                    while (curIdx < sLen && Character.isWhitespace(tmpStr.charAt(curIdx))) {
                        ++curIdx;
                    }
                    if (curIdx < sLen || tmpStr.equals(".")) {
                        curPost = -1;
                        curPre = curRow.elementAt(inner_idx).myLongestStr();
                    }
                } else if (curRow.elementAt(inner_idx).getDelimType() == DataValueNode.SEMICOLON) {
                    curPre = 0;
                }
                if ((Integer)preSizes.elementAt(inner_idx) < curPre) {
                    preSizes.setElementAt(new Integer(curPre), inner_idx);
                }
                if ((Integer)postSizes.elementAt(inner_idx) < curPost) {
                    postSizes.setElementAt(new Integer(curPost), inner_idx);
                }
                ++inner_idx;
            }
            ++outer_idx;
        }
    }
}

