/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.starlibj;

import EDU.bmrb.starlibj.NameViolatesStarSyntax;
import EDU.bmrb.starlibj.SaveListVector;
import EDU.bmrb.starlibj.StarNode;
import EDU.bmrb.starlibj.StarValidity;
import EDU.bmrb.starlibj.VectorCheckType;
import EDU.bmrb.starlibj.WrongElementType;
import java.util.Enumeration;

public class SaveFrameNode
extends StarNode
implements Cloneable {
    protected String myName;
    protected SaveListVector myDataList;

    public SaveFrameNode(String name) {
        this.myName = name;
        this.myDataList = new SaveListVector();
    }

    public SaveFrameNode(SaveFrameNode copyMe) {
        this.myName = copyMe.myName == null ? null : new String(copyMe.myName);
        this.myDataList = new SaveListVector();
        int i = 0;
        while (i < copyMe.size()) {
            this.addElement(copyMe.elementAt(i).clone());
            ++i;
        }
    }

    public Object clone() {
        return new SaveFrameNode(this);
    }

    public String getLabel() {
        return this.myName;
    }

    public void setLabel(String newName) throws NameViolatesStarSyntax {
        this.myName = newName;
        if (!StarValidity.isValidSaveName((String)newName)) {
            throw new NameViolatesStarSyntax(newName, "saveframe name");
        }
    }

    public void setSize(int newSize) {
        this.myDataList.setSize(newSize);
    }

    public int size() {
        return this.myDataList.size();
    }

    public boolean isEmpty() {
        return this.myDataList.isEmpty();
    }

    public Enumeration elements() {
        return this.myDataList.elements();
    }

    public boolean contains(Object obj) {
        return this.myDataList.contains(obj);
    }

    public int indexOf(Object obj) {
        return this.myDataList.indexOf(obj);
    }

    public int indexOf(Object obj, int index) {
        return this.myDataList.indexOf(obj, index);
    }

    public int lastIndexOf(Object obj) {
        return this.myDataList.lastIndexOf(obj);
    }

    public int lastIndexOf(Object obj, int index) {
        return this.myDataList.lastIndexOf(obj, index);
    }

    public StarNode elementAt(int index) {
        return (StarNode)this.myDataList.elementAt(index);
    }

    public StarNode firstElement() {
        return (StarNode)this.myDataList.firstElement();
    }

    public StarNode lastElement() {
        return (StarNode)this.myDataList.lastElement();
    }

    public void setElementAt(Object obj, int index) throws WrongElementType {
        this.myDataList.setElementAt(obj, index);
        ((StarNode)this.myDataList.elementAt(index)).setParent((StarNode)this);
    }

    public void removeElementAt(int index) {
        ((StarNode)this.myDataList.elementAt(index)).setParent(null);
        this.myDataList.removeElementAt(index);
    }

    public void insertElementAt(Object obj, int index) throws WrongElementType {
        this.myDataList.insertElementAt(obj, index);
        ((StarNode)this.myDataList.elementAt(index)).setParent((StarNode)this);
    }

    public void addElement(Object obj) throws WrongElementType {
        this.myDataList.addElement(obj);
        ((StarNode)this.myDataList.lastElement()).setParent((StarNode)this);
    }

    public boolean removeElement(Object obj) {
        ((StarNode)obj).setParent((StarNode)this);
        return this.myDataList.removeElement(obj);
    }

    public VectorCheckType searchByName(String searchFor) {
        VectorCheckType retVal = new VectorCheckType();
        try {
            retVal.addType(Class.forName(StarValidity.clsNameStarNode));
            retVal.freezeTypes();
            if (this.getLabel().equalsIgnoreCase(searchFor)) {
                retVal.addElement((Object)this);
            }
            int i = 0;
            while (i < this.myDataList.size()) {
                VectorCheckType tmpVect = ((StarNode)this.myDataList.elementAt(i)).searchByName(searchFor);
                int j = 0;
                while (j < tmpVect.size()) {
                    retVal.addElement(tmpVect.elementAt(j));
                    ++j;
                }
                ++i;
            }
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
        }
        return retVal;
    }

    public VectorCheckType searchByTagValue(String tag, String value) {
        VectorCheckType retVal = new VectorCheckType();
        try {
            retVal.addType(Class.forName(StarValidity.clsNameStarNode));
            retVal.freezeTypes();
            int i = 0;
            while (i < this.myDataList.size()) {
                VectorCheckType tmpVect = ((StarNode)this.myDataList.elementAt(i)).searchByTagValue(tag, value);
                int j = 0;
                while (j < tmpVect.size()) {
                    retVal.addElement(tmpVect.elementAt(j));
                    ++j;
                }
                ++i;
            }
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
        }
        return retVal;
    }

    public VectorCheckType searchForType(Class type, short delim) {
        VectorCheckType retVal = new VectorCheckType();
        try {
            retVal.addType(Class.forName(StarValidity.clsNameStarNode));
            retVal.freezeTypes();
            if (type.isInstance(this)) {
                retVal.addElement((Object)this);
            }
            int i = 0;
            while (i < this.myDataList.size()) {
                VectorCheckType tmpVect = ((StarNode)this.myDataList.elementAt(i)).searchForType(type, delim);
                int j = 0;
                while (j < tmpVect.size()) {
                    retVal.addElement(tmpVect.elementAt(j));
                    ++j;
                }
                ++i;
            }
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
        }
        return retVal;
    }

    public void Unparse(int indent) {
    }
}

