/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.starlibj;

import EDU.bmrb.starlibj.StarValidity;
import EDU.bmrb.starlibj.VectorCheckType;

public class StarNode
implements Cloneable {
    protected StarNode parent;
    protected int lineNum;
    protected int colNum;
    protected String preComment;

    public StarNode() {
        this.parent = null;
        this.lineNum = -1;
        this.colNum = -1;
        this.preComment = "";
    }

    public StarNode(StarNode copyMe) {
        this.parent = copyMe.parent;
        this.lineNum = copyMe.lineNum;
        this.colNum = copyMe.colNum;
        this.preComment = copyMe.preComment == null ? null : new String(copyMe.preComment);
    }

    public void Unparse(int indent) {
    }

    public StarNode getParent() {
        return this.parent;
    }

    public VectorCheckType searchByName(String searchFor) {
        VectorCheckType retVal = new VectorCheckType();
        try {
            retVal.addType(Class.forName(StarValidity.clsNameStarNode));
            retVal.freezeTypes();
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
        }
        return retVal;
    }

    public VectorCheckType searchByTagValue(String tag, String value) {
        VectorCheckType retVal = new VectorCheckType();
        try {
            retVal.addType(Class.forName(StarValidity.clsNameStarNode));
            retVal.freezeTypes();
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
        }
        return retVal;
    }

    public VectorCheckType searchForType(Class type, short delim) {
        short i = delim;
        VectorCheckType retVal = new VectorCheckType();
        try {
            retVal.addType(Class.forName(StarValidity.clsNameStarNode));
            retVal.freezeTypes();
            if (type.isInstance(this)) {
                retVal.addElement((Object)this);
            }
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
        }
        return retVal;
    }

    public VectorCheckType searchForTypeByName(Class type, String name) {
        VectorCheckType retVal = this.searchByName(name);
        int i = 0;
        while (i < retVal.size()) {
            StarNode par = (StarNode)retVal.elementAt(i);
            while (par != null && !type.isInstance(par)) {
                par = par.getParent();
            }
            if (par == null) {
                retVal.removeElementAt(i);
                --i;
            } else {
                retVal.setElementAt((Object)par, i);
            }
            ++i;
        }
        return retVal;
    }

    public VectorCheckType searchForTypeByTagValue(Class type, String tag, String value) {
        VectorCheckType retVal = this.searchByTagValue(tag, value);
        int i = 0;
        while (i < retVal.size()) {
            StarNode par = (StarNode)retVal.elementAt(i);
            while (par != null && !type.isInstance(par)) {
                par = par.getParent();
            }
            if (par == null) {
                retVal.removeElementAt(i);
                --i;
            } else {
                retVal.setElementAt((Object)par, i);
            }
            ++i;
        }
        return retVal;
    }

    public StarNode getParallelCopy() {
        return null;
    }

    public void setPeer(StarNode peer) {
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public void setLineNum(int num) {
        this.lineNum = num;
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int num) {
        this.colNum = num;
    }

    public String getPreComment() {
        return this.preComment;
    }

    public void setPreComment(String cmt) {
        this.preComment = cmt;
    }

    public Object clone() {
        return new StarNode(this);
    }

    protected void setParent(StarNode p) {
        this.parent = p;
    }
}

