/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.starlibj;

import EDU.bmrb.starlibj.BlockNode;
import EDU.bmrb.starlibj.DataItemNode;
import EDU.bmrb.starlibj.DataLoopNameListNode;
import EDU.bmrb.starlibj.DataLoopNode;
import EDU.bmrb.starlibj.DataNameNode;
import EDU.bmrb.starlibj.DataValueNode;
import EDU.bmrb.starlibj.InternalException;
import EDU.bmrb.starlibj.LoopNameListNode;
import EDU.bmrb.starlibj.LoopRowNode;
import EDU.bmrb.starlibj.LoopTableNode;
import EDU.bmrb.starlibj.SaveFrameNode;
import EDU.bmrb.starlibj.StarFileNode;
import EDU.bmrb.starlibj.StarNode;
import EDU.bmrb.starlibj.StarValidity;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;

public class StarUnparser
implements Cloneable {
    protected int indentSize;
    protected boolean formatting;
    protected PrintWriter oWrit;

    public StarUnparser(OutputStream out) {
        this.oWrit = new PrintWriter(out);
        this.indentSize = 4;
        this.formatting = true;
    }

    public StarUnparser(OutputStream out, boolean autoFlush) {
        this.oWrit = new PrintWriter(out, autoFlush);
        this.indentSize = 4;
        this.formatting = true;
    }

    protected void finalize() {
        this.oWrit.flush();
    }

    public StarUnparser(StarUnparser copyMe) {
        this.indentSize = copyMe.indentSize;
        this.formatting = copyMe.formatting;
        this.oWrit = copyMe.oWrit;
    }

    public StarUnparser clone(StarUnparser copyMe) {
        return new StarUnparser(copyMe);
    }

    public void writeOut(StarNode node, int indentLvl) {
        this.writeOut(node, indentLvl, -1);
    }

    protected void writeOut(StarNode node, int indentLvl, int longest) {
        try {
            if (Class.forName(StarValidity.clsNameDataValueNode).isInstance(node)) {
                this.writeDataValueNode((DataValueNode)node, indentLvl, -99, -99);
            } else if (Class.forName(StarValidity.clsNameDataNameNode).isInstance(node)) {
                this.writeDataNameNode((DataNameNode)node, indentLvl);
            } else if (Class.forName(StarValidity.clsNameLoopRowNode).isInstance(node)) {
                this.writeLoopRowNode((LoopRowNode)node, indentLvl, null, null);
            } else if (Class.forName(StarValidity.clsNameLoopTableNode).isInstance(node)) {
                this.writeLoopTableNode((LoopTableNode)node, indentLvl);
            } else if (Class.forName(StarValidity.clsNameDataItemNode).isInstance(node)) {
                this.writeDataItemNode((DataItemNode)node, indentLvl, longest);
            } else if (Class.forName(StarValidity.clsNameLoopNameListNode).isInstance(node)) {
                this.writeLoopNameListNode((LoopNameListNode)node, indentLvl);
            } else if (Class.forName(StarValidity.clsNameDataLoopNameListNode).isInstance(node)) {
                this.writeDataLoopNameListNode((DataLoopNameListNode)node, indentLvl);
            } else if (Class.forName(StarValidity.clsNameDataLoopNode).isInstance(node)) {
                this.writeDataLoopNode((DataLoopNode)node, indentLvl);
            } else if (Class.forName(StarValidity.clsNameSaveFrameNode).isInstance(node)) {
                this.writeSaveFrameNode((SaveFrameNode)node, indentLvl);
            } else if (Class.forName(StarValidity.clsNameBlockNode).isInstance(node)) {
                this.writeBlockNode((BlockNode)node, indentLvl);
            } else if (Class.forName(StarValidity.clsNameStarFileNode).isInstance(node)) {
                this.writeStarFileNode((StarFileNode)node, indentLvl);
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        this.oWrit.flush();
    }

    protected void writeIndent(int indentLvl) {
        if (this.formatting) {
            int numChars = indentLvl * this.indentSize;
            int i = 1;
            while (i <= numChars) {
                this.oWrit.print(' ');
                ++i;
            }
        }
    }

    protected void writePreComment(String cmt, int indentLvl) {
        if (cmt != null && cmt.length() > 0) {
            if (this.formatting) {
                this.writeIndent(indentLvl);
            }
            int idx = 0;
            while (idx < cmt.length()) {
                char ch = cmt.charAt(idx);
                this.oWrit.print(ch);
                if (Character.getType(ch) == 13 && this.formatting) {
                    this.writeIndent(indentLvl);
                }
                ++idx;
            }
        }
    }

    protected void writeDataValueNode(DataValueNode node, int indentLvl, int preSize, int postSize) {
        if (!this.formatting || preSize == -99 || postSize == -99) {
            if (node.getDelimType() == DataValueNode.NON) {
                this.oWrit.print(node.getValue());
                this.oWrit.print(' ');
            } else if (node.getDelimType() == DataValueNode.SINGLE) {
                this.oWrit.print("'" + node.getValue() + "'");
                this.oWrit.print(' ');
            } else if (node.getDelimType() == DataValueNode.DOUBLE) {
                this.oWrit.print("\"" + node.getValue() + "\"");
                this.oWrit.print(' ');
            } else if (node.getDelimType() == DataValueNode.FRAMECODE) {
                this.oWrit.print("$" + node.getValue());
                this.oWrit.print(' ');
            } else if (node.getDelimType() == DataValueNode.SEMICOLON) {
                this.oWrit.println();
                this.oWrit.print(";");
                char firstChar = node.getValue().charAt(0);
                if (firstChar != '\n' && firstChar != '\r') {
                    this.oWrit.println();
                }
                this.oWrit.print(node.getValue());
                char lastChar = node.getValue().charAt(node.getValue().length() - 1);
                if (lastChar != '\n' && lastChar != '\r') {
                    this.oWrit.println();
                }
                this.oWrit.println(";");
            }
        } else {
            int i;
            this.writePreComment(node.getPreComment(), indentLvl);
            String thisVal = node.getValue();
            if (node.getDelimType() == DataValueNode.NON) {
                this.oWrit.print(' ');
                if (postSize >= 0 && this.isItNumeric(thisVal)) {
                    String tmpStr = "";
                    int dotIdx = thisVal.indexOf(46);
                    if (dotIdx == -1) {
                        dotIdx = thisVal.length();
                    }
                    i = 0;
                    while (i < preSize - dotIdx) {
                        this.oWrit.print(' ');
                        ++i;
                    }
                    this.oWrit.print(thisVal.substring(0, dotIdx));
                    if (dotIdx < thisVal.length()) {
                        this.oWrit.print(thisVal.substring(dotIdx, thisVal.length()));
                        i = thisVal.length() - dotIdx;
                        while (i < postSize + 1) {
                            this.oWrit.print(' ');
                            ++i;
                        }
                    } else {
                        if (postSize >= 0) {
                            i = 1;
                            while (i <= postSize) {
                                this.oWrit.print(' ');
                                ++i;
                            }
                        }
                        if (postSize >= 1) {
                            this.oWrit.print(' ');
                        }
                    }
                } else {
                    this.oWrit.print(thisVal);
                    i = thisVal.length();
                    while (i < preSize) {
                        this.oWrit.print(' ');
                        ++i;
                    }
                    if (postSize >= 0) {
                        i = 0;
                        while (i < postSize) {
                            this.oWrit.print(' ');
                            ++i;
                        }
                    }
                    if (postSize >= 1) {
                        this.oWrit.print(' ');
                    }
                }
            } else if (node.getDelimType() == DataValueNode.SINGLE) {
                this.oWrit.print("'" + thisVal + "'");
                i = thisVal.length() + 1;
                while (i < preSize) {
                    this.oWrit.print(' ');
                    ++i;
                }
            } else if (node.getDelimType() == DataValueNode.DOUBLE) {
                this.oWrit.print("\"" + thisVal + "\"");
                i = thisVal.length() + 1;
                while (i < preSize) {
                    this.oWrit.print(' ');
                    ++i;
                }
            } else if (node.getDelimType() == DataValueNode.SEMICOLON) {
                this.oWrit.println();
                this.oWrit.println(';');
                this.oWrit.println(thisVal);
                if (thisVal.charAt(thisVal.length() - 1) != '\n' && thisVal.charAt(thisVal.length() - 1) != '\r') {
                    this.oWrit.println();
                }
                this.oWrit.println(';');
            } else if (node.getDelimType() == DataValueNode.FRAMECODE) {
                this.oWrit.print("$" + thisVal);
                i = thisVal.length();
                while (i < preSize) {
                    this.oWrit.print(' ');
                    ++i;
                }
            }
            if (node.getDelimType() != DataValueNode.NON && postSize >= 0) {
                i = 1;
                while (i <= preSize) {
                    this.oWrit.print(' ');
                    ++i;
                }
                if (postSize >= 1) {
                    this.oWrit.print(' ');
                }
            }
        }
    }

    protected void writeDataNameNode(DataNameNode node, int indentLvl) {
        if (!this.formatting) {
            this.oWrit.print(String.valueOf(node.getLabel()) + " ");
        } else {
            this.writePreComment(node.getPreComment(), indentLvl);
            this.writeIndent(indentLvl);
            this.oWrit.print(String.valueOf(node.getLabel()) + " ");
        }
    }

    protected void writeDataItemNode(DataItemNode node, int indentLvl, int longest) {
        if (!this.formatting) {
            this.writeDataNameNode(node.getNameNode(), 0);
            this.writeDataValueNode(node.getValueNode(), 0, -99, -99);
            this.oWrit.println();
        } else {
            this.writePreComment(node.getPreComment(), indentLvl);
            this.writeDataNameNode(node.getNameNode(), indentLvl);
            int i = node.getLabel().length();
            while (i < longest) {
                this.oWrit.print(' ');
                ++i;
            }
            if (node.getValueNode().getDelimType() == DataValueNode.NON) {
                this.oWrit.print(' ');
            }
            this.writeDataValueNode(node.getValueNode(), indentLvl, -99, -99);
            this.oWrit.println();
        }
    }

    protected void writeDataLoopNode(DataLoopNode node, int indentLvl) {
        int ind;
        if (this.formatting) {
            this.writePreComment(node.getPreComment(), indentLvl);
            ind = indentLvl + 1;
        } else {
            ind = 0;
        }
        this.writeDataLoopNameListNode(node.getNames(), indentLvl);
        this.writeLoopTableNode(node.getVals(), ind);
        this.oWrit.println();
    }

    protected void writeDataLoopNameListNode(DataLoopNameListNode node, int indentLvl) {
        this.writePreComment(node.getPreComment(), indentLvl);
        this.oWrit.println();
        int i = 0;
        while (i < node.size()) {
            this.writeLoopNameListNode(node.elementAt(i), indentLvl + i);
            ++i;
        }
    }

    protected void writeLoopNameListNode(LoopNameListNode node, int indentLvl) {
        this.writePreComment(node.getPreComment(), indentLvl);
        this.writeIndent(indentLvl);
        this.oWrit.println("loop_");
        int i = 0;
        while (i < node.size()) {
            this.writeDataNameNode(node.elementAt(i), indentLvl + 1);
            this.oWrit.println();
            if (node.elementAt(i).getLabel().equals("_Saveframe_category")) {
                this.oWrit.println();
            }
            ++i;
        }
    }

    protected void writeLoopTableNode(LoopTableNode node, int indentLvl) {
        if (!this.formatting) {
            int i = 0;
            while (i < node.size()) {
                this.writeLoopRowNode(node.elementAt(i), 0, null, null);
                this.oWrit.println();
                ++i;
            }
            this.oWrit.println("stop_");
        } else {
            Vector preSizes = new Vector();
            Vector postSizes = new Vector();
            this.writePreComment(node.getPreComment(), node.getIndentFlag() ? indentLvl : 0);
            node.calcPrintSizes(preSizes, postSizes);
            int rowIdx = 0;
            while (rowIdx < node.size()) {
                if (rowIdx % node.getRowsPerLine() == 0 || rowIdx == 0) {
                    this.oWrit.println();
                    this.writeIndent(node.getIndentFlag() ? indentLvl : 0);
                } else {
                    this.oWrit.print(" ");
                }
                this.writeLoopRowNode(node.elementAt(rowIdx), indentLvl, preSizes, postSizes);
                ++rowIdx;
            }
            this.oWrit.println();
            this.writeIndent(indentLvl > 0 && node.getIndentFlag() ? indentLvl - 1 : 0);
            this.oWrit.print("stop_");
        }
    }

    protected void writeLoopRowNode(LoopRowNode node, int indentLvl, Vector preSizes, Vector postSizes) {
        if (!this.formatting || preSizes == null || postSizes == null) {
            int i = 0;
            while (i < node.size()) {
                this.writeDataValueNode(node.elementAt(i), 0, -99, -99);
                ++i;
            }
        } else {
            this.writePreComment(node.getPreComment(), indentLvl);
            int idx = 0;
            while (idx < node.size()) {
                this.writeDataValueNode(node.elementAt(idx), indentLvl, ((Integer)preSizes.elementAt(idx)).intValue(), ((Integer)postSizes.elementAt(idx)).intValue());
                if (node.getParent() != null && ((LoopTableNode)node.getParent()).getTabFlag()) {
                    this.oWrit.print(" ");
                } else {
                    this.oWrit.println();
                    this.writeIndent(indentLvl);
                }
                ++idx;
            }
        }
        if (node.getInnerLoop() != null) {
            this.writeLoopTableNode(node.getInnerLoop(), this.formatting ? indentLvl + 1 : 0);
        }
    }

    protected void writeSaveFrameNode(SaveFrameNode node, int indentLvl) {
        int i;
        int longestValLength = -1;
        if (indentLvl > 0) {
            --indentLvl;
        }
        this.writePreComment(node.getPreComment(), indentLvl);
        if (this.formatting) {
            this.writeIndent(indentLvl);
        }
        this.oWrit.println();
        this.oWrit.println(node.getLabel());
        if (this.formatting) {
            try {
                i = 0;
                while (i < node.size()) {
                    int len;
                    if (Class.forName(StarValidity.clsNameDataItemNode).isInstance(node.elementAt(i)) && (len = ((DataItemNode)node.elementAt(i)).getLabel().length()) > longestValLength) {
                        longestValLength = len;
                    }
                    ++i;
                }
            }
            catch (ClassNotFoundException e) {
                throw new InternalException(e.getMessage());
            }
        }
        i = 0;
        while (i < node.size()) {
            this.writeOut(node.elementAt(i), indentLvl + (this.formatting ? 1 : 0), longestValLength);
            ++i;
        }
        if (this.formatting) {
            this.writeIndent(indentLvl);
        }
        this.oWrit.println("save_");
        this.oWrit.println();
    }

    protected void writeBlockNode(BlockNode node, int indentLvl) {
        int i;
        int longestValLength = -1;
        this.writePreComment(node.getPreComment(), indentLvl);
        this.oWrit.println(node.getLabel());
        this.oWrit.println();
        if (this.formatting) {
            try {
                i = 0;
                while (i < node.size()) {
                    int len;
                    if (Class.forName(StarValidity.clsNameDataItemNode).isInstance(node.elementAt(i)) && (len = ((DataItemNode)node.elementAt(i)).getLabel().length()) > longestValLength) {
                        longestValLength = len;
                    }
                    ++i;
                }
            }
            catch (ClassNotFoundException e) {
                throw new InternalException(e.getMessage());
            }
        }
        i = 0;
        while (i < node.size()) {
            this.writeOut(node.elementAt(i), indentLvl + (this.formatting ? 1 : 0), longestValLength);
            ++i;
        }
        this.oWrit.println();
    }

    protected void writeStarFileNode(StarFileNode node, int indentLvl) {
        this.writePreComment(node.getPreComment(), indentLvl);
        int i = 0;
        while (i < node.size()) {
            this.writeOut((StarNode)node.elementAt(i), indentLvl);
            ++i;
        }
        this.oWrit.println();
    }

    public void setIndentSize(int s) {
        this.indentSize = s;
    }

    public int getIndentSize() {
        return this.indentSize;
    }

    public void setFormatting(boolean isOn) {
        this.formatting = isOn;
    }

    public boolean getFormatting() {
        return this.formatting;
    }

    protected boolean isItNumeric(String str) {
        int idx = 0;
        while (idx < str.length() && Character.isWhitespace(str.charAt(idx))) {
            ++idx;
        }
        if (idx < str.length() && (str.charAt(idx) == '+' || str.charAt(idx) == '-')) {
            ++idx;
        }
        while (idx < str.length() && Character.isDigit(str.charAt(idx))) {
            ++idx;
        }
        if (idx < str.length() && str.charAt(idx) == '.') {
            ++idx;
        }
        while (idx < str.length() && Character.isDigit(str.charAt(idx))) {
            ++idx;
        }
        while (idx < str.length() && Character.isWhitespace(str.charAt(idx))) {
            ++idx;
        }
        return idx == str.length();
    }
}

