/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.starlibj;

import EDU.bmrb.starlibj.DataValueNode;
import EDU.bmrb.starlibj.ParseValFromRetVal;
import EDU.bmrb.starlibj.StarNode;

/*
 * Exception performing whole class analysis ignored.
 */
public class StarValidity {
    private static String packageNameStatic = null;
    static String clsNameASCII_CharStream = "EDU.bmrb.starlibj.ASCII_CharStream";
    static String clsNameBadValueForDelimiter = "EDU.bmrb.starlibj.BadValueForDelimiter";
    static String clsNameBlockListVector = "EDU.bmrb.starlibj.BlockListVector";
    static String clsNameBlockNode = "EDU.bmrb.starlibj.BlockNode";
    static String clsNameCharStream = "EDU.bmrb.starlibj.CharStream";
    static String clsNameDataItemNode = "EDU.bmrb.starlibj.DataItemNode";
    static String clsNameDataLoopNameListNode = "EDU.bmrb.starlibj.DataLoopNameListNode";
    static String clsNameDataLoopNode = "EDU.bmrb.starlibj.DataLoopNode";
    static String clsNameDataNameNode = "EDU.bmrb.starlibj.DataNameNode";
    static String clsNameDataValueNode = "EDU.bmrb.starlibj.DataValueNode";
    static String clsNameDataValuesVector = "EDU.bmrb.starlibj.DataValuesVector";
    static String clsNameHomemadeStringBuffer = "EDU.bmrb.starlibj.HomemadeStringBuffer";
    static String clsNameInternalException = "EDU.bmrb.starlibj.InternalException";
    static String clsNameLoopNameListNode = "EDU.bmrb.starlibj.LoopNameListNode";
    static String clsNameLoopRowNode = "EDU.bmrb.starlibj.LoopRowNode";
    static String clsNameLoopRowsVector = "EDU.bmrb.starlibj.LoopRowsVector";
    static String clsNameLoopTableNode = "EDU.bmrb.starlibj.LoopTableNode";
    static String clsNameNameListVector = "EDU.bmrb.starlibj.NameListVector";
    static String clsNameNameViolatesStarSyntax = "EDU.bmrb.starlibj.NameViolatesStarSyntax";
    static String clsNameOperationCausesMismatchedLoopData = "EDU.bmrb.starlibj.OperationCausesMismatchedLoopData";
    static String clsNameParseException = "EDU.bmrb.starlibj.ParseException";
    static String clsNameParseValFromRetVal = "EDU.bmrb.starlibj.ParseValFromRetVal";
    static String clsNameRemoteInt = "EDU.bmrb.starlibj.RemoteInt";
    static String clsNameSaveFrameNode = "EDU.bmrb.starlibj.SaveFrameNode";
    static String clsNameSaveListVector = "EDU.bmrb.starlibj.SaveListVector";
    static String clsNameStarFileNode = "EDU.bmrb.starlibj.StarFileNode";
    static String clsNameStarListVector = "EDU.bmrb.starlibj.StarListVector";
    static String clsNameStarNode = "EDU.bmrb.starlibj.StarNode";
    static String clsNameStarParser = "EDU.bmrb.starlibj.StarParser";
    static String clsNameStarParserConstants = "EDU.bmrb.starlibj.StarParserConstants";
    static String clsNameStarParserTokenManager = "EDU.bmrb.starlibj.StarParserTokenManager";
    static String clsNameStarUnparser = "EDU.bmrb.starlibj.StarUnparser";
    static String clsNameStarValidity = "EDU.bmrb.starlibj.StarValidity";
    static String clsNameStarVectorLike = "EDU.bmrb.starlibj.StarVectorLike";
    static String clsNameTagsVector = "EDU.bmrb.starlibj.TagsVector";
    static String clsNameTinyAbsDataValueNode = "EDU.bmrb.starlibj.TinyAbsDataValueNode";
    static String clsNameTinyRelDataValueNode = "EDU.bmrb.starlibj.TinyRelDataValueNode";
    static String clsNameToken = "EDU.bmrb.starlibj.Token";
    static String clsNameTokenMgrError = "EDU.bmrb.starlibj.TokenMgrError";
    static String clsNameTypesAreFrozen = "EDU.bmrb.starlibj.TypesAreFrozen";
    static String clsNameTypesNotFrozenYet = "EDU.bmrb.starlibj.TypesNotFrozenYet";
    static String clsNameVectorCheckType = "EDU.bmrb.starlibj.VectorCheckType";
    static String clsNameWrongElementType = "EDU.bmrb.starlibj.WrongElementType";

    public static String pkgName() {
        if (packageNameStatic == null) {
            StarNode dummyObj = new StarNode();
            String className = dummyObj.getClass().getName();
            packageNameStatic = className.substring(0, className.lastIndexOf(46));
        }
        return packageNameStatic;
    }

    public static boolean isValidTagName(String s) {
        if (s.charAt(0) != '_') {
            return false;
        }
        int i = 0;
        while (i < s.length()) {
            if (Character.isWhitespace(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isValidSaveName(String s) {
        if (!s.substring(0, 5).equals("save_")) {
            return false;
        }
        if (s.length() <= 5) {
            return false;
        }
        int i = 5;
        while (i < s.length()) {
            if (Character.isWhitespace(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isValidBlockName(String s) {
        if (s.equals("global_")) {
            return true;
        }
        if (!s.substring(0, 5).equals("data_")) {
            return false;
        }
        if (s.length() <= 5) {
            return false;
        }
        int i = 5;
        while (i < s.length()) {
            if (Character.isWhitespace(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isValidValueForNonDelim(String s) {
        if (s.length() == 0) {
            return false;
        }
        if (s.charAt(0) == '\'') {
            return false;
        }
        if (s.charAt(0) == '\"') {
            return false;
        }
        int i = 0;
        while (i < s.length()) {
            if (Character.isWhitespace(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isValidValueForSingleDelim(String s) {
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '\n' || s.charAt(i) == '\r') {
                return false;
            }
            if (s.charAt(i) == '\'' && i < s.length() && s.charAt(i + 1) == ' ') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isValidValueForDoubleDelim(String s) {
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '\n' || s.charAt(i) == '\r') {
                return false;
            }
            if (s.charAt(i) == '\"' && i < s.length() && s.charAt(i + 1) == ' ') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isValidValueForFrameCodeDelim(String s) {
        int i = 0;
        while (i < s.length()) {
            if (Character.isWhitespace(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isValidForDelim(String s, int delim) {
        if (delim == DataValueNode.NON) {
            return StarValidity.isValidValueForNonDelim((String)s);
        }
        if (delim == DataValueNode.DOUBLE) {
            return StarValidity.isValidValueForDoubleDelim((String)s);
        }
        if (delim == DataValueNode.SINGLE) {
            return StarValidity.isValidValueForSingleDelim((String)s);
        }
        if (delim == DataValueNode.SEMICOLON) {
            return true;
        }
        if (delim == DataValueNode.FRAMECODE) {
            return StarValidity.isValidValueForNonDelim((String)s);
        }
        return false;
    }

    public static ParseValFromRetVal parseValFrom(String str, boolean makeNew) {
        int idx = 0;
        boolean inLeadingWhitespace = true;
        boolean inNonQuoted = false;
        boolean inFramecode = false;
        boolean inSingle = false;
        boolean inDouble = false;
        boolean inSemicolon = false;
        boolean reachedEnd = false;
        int startIdx = 0;
        int endIdx = 0;
        int nextIdx = 0;
        boolean found = false;
        boolean rowOffset = false;
        boolean colOffset = false;
        while (!reachedEnd) {
            if (idx >= str.length()) {
                reachedEnd = true;
                nextIdx = endIdx = idx;
                continue;
            }
            if (inLeadingWhitespace) {
                if (Character.isWhitespace(str.charAt(idx))) {
                    ++idx;
                    continue;
                }
                inLeadingWhitespace = false;
                found = true;
                char curChar = str.charAt(idx);
                if (curChar == '\"') {
                    inDouble = true;
                    startIdx = ++idx;
                    continue;
                }
                if (curChar == '\'') {
                    inSingle = true;
                    startIdx = ++idx;
                    continue;
                }
                if (curChar == ';') {
                    inSemicolon = true;
                    ++idx;
                    while (str.charAt(idx) == '\n' || str.charAt(idx) == '\r') {
                        ++idx;
                    }
                    startIdx = idx;
                    continue;
                }
                if (curChar == '$') {
                    inFramecode = true;
                    startIdx = ++idx;
                    continue;
                }
                inNonQuoted = true;
                startIdx = idx++;
                continue;
            }
            if (inDouble && str.charAt(idx) == '\"') {
                reachedEnd = true;
                endIdx = idx;
                nextIdx = idx + 1;
                continue;
            }
            if (inSingle && str.charAt(idx) == '\'') {
                reachedEnd = true;
                endIdx = idx;
                nextIdx = idx + 1;
                continue;
            }
            if (inSemicolon && str.charAt(idx) == ';' && (str.charAt(idx - 1) == '\n' || str.charAt(idx - 1) == '\r')) {
                reachedEnd = true;
                endIdx = idx - 1;
                nextIdx = idx + 1;
                continue;
            }
            if ((inNonQuoted || inFramecode) && Character.isWhitespace(str.charAt(idx))) {
                reachedEnd = true;
                endIdx = idx;
                nextIdx = idx;
                continue;
            }
            ++idx;
        }
        ParseValFromRetVal retVal = new ParseValFromRetVal();
        if (makeNew) {
            retVal.delim = inNonQuoted ? DataValueNode.NON : (inDouble ? DataValueNode.DOUBLE : (inSingle ? DataValueNode.SINGLE : (inSemicolon ? DataValueNode.SEMICOLON : (inFramecode ? DataValueNode.FRAMECODE : DataValueNode.DONT_CARE))));
            retVal.str = str.substring(startIdx, endIdx);
        } else {
            retVal.str = null;
        }
        retVal.endingIdx = endIdx;
        retVal.nextIdx = nextIdx;
        retVal.found = found;
        return retVal;
    }
}

