/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.starlibj;

import EDU.bmrb.starlibj.DataValueNode;
import EDU.bmrb.starlibj.LoopRowNode;
import EDU.bmrb.starlibj.ParseValFromRetVal;
import EDU.bmrb.starlibj.StarNode;
import EDU.bmrb.starlibj.StarValidity;
import EDU.bmrb.starlibj.TinyAbsDataValueNode;

public class TinyRelDataValueNode {
    public short offset;
    public char[] str;

    public TinyRelDataValueNode(short off, String s) {
        this.offset = off;
        this.str = new char[s.length()];
        s.getChars(0, s.length(), this.str, 0);
    }

    public TinyRelDataValueNode(int parLine, TinyAbsDataValueNode n) {
        this.offset = (short)(((n.lNum - parLine & 0x2F) << 10) + (n.cNum & 0x2FF));
        this.str = new char[n.str.length];
        System.arraycopy(n.str, 0, this.str, 0, n.str.length);
    }

    public TinyRelDataValueNode(int parLine, DataValueNode dvn) {
        this.offset = (short)(((dvn.getLineNum() - parLine & 0x2F) << 10) + (dvn.getColNum() & 0x2FF));
        short delim = dvn.getDelimType();
        String dvnVal = dvn.getValue();
        if (delim == DataValueNode.SINGLE) {
            this.str = new char[dvnVal.length() + 2];
            this.str[0] = 39;
            dvnVal.getChars(0, dvnVal.length(), this.str, 1);
            this.str[dvnVal.length() + 1] = 39;
        } else if (delim == DataValueNode.DOUBLE) {
            this.str = new char[dvnVal.length() + 2];
            this.str[0] = 34;
            dvnVal.getChars(0, dvnVal.length(), this.str, 1);
            this.str[dvnVal.length() + 1] = 34;
        } else if (delim == DataValueNode.SEMICOLON) {
            this.str = new char[dvnVal.length() + 4];
            this.str[0] = 59;
            this.str[1] = 10;
            dvnVal.getChars(0, dvnVal.length(), this.str, 2);
            this.str[dvnVal.length() + 2] = 10;
            this.str[dvnVal.length() + 3] = 59;
        } else if (delim == DataValueNode.FRAMECODE) {
            this.str = new char[dvnVal.length() + 1];
            this.str[0] = 36;
            dvnVal.getChars(0, dvnVal.length(), this.str, 1);
        } else {
            this.str = new char[dvnVal.length()];
            dvnVal.getChars(0, dvnVal.length(), this.str, 0);
        }
    }

    public DataValueNode makeIntoDVN(LoopRowNode par) {
        ParseValFromRetVal parseRet = StarValidity.parseValFrom((String)new String(this.str), (boolean)true);
        DataValueNode retVal = new DataValueNode(parseRet.str, parseRet.delim);
        retVal.setLineNum(par.getLineNum() + (this.offset >>> 10));
        retVal.setColNum(this.offset & 0x2FF);
        retVal.setParent((StarNode)par);
        return retVal;
    }

    public void printSize() {
        System.out.println("TinyRel size = " + this.str.length + " + 2 for the short= " + this.str.length + 2);
    }
}

