/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.starlibj;

import EDU.bmrb.starlibj.TypesAreFrozen;
import EDU.bmrb.starlibj.TypesNotFrozenYet;
import EDU.bmrb.starlibj.WrongElementType;
import java.util.Enumeration;
import java.util.Vector;

public class VectorCheckType {
    protected Vector types;
    protected Vector data;
    protected boolean typesFrozen;

    public VectorCheckType() {
        this.data = new Vector();
        this.types = new Vector();
        this.typesFrozen = false;
    }

    public VectorCheckType(int startCap) {
        this.data = new Vector(startCap);
        this.types = new Vector();
        this.typesFrozen = false;
    }

    public VectorCheckType(int startCap, int incr) {
        this.data = new Vector(startCap, incr);
        this.types = new Vector();
        this.typesFrozen = false;
    }

    public void addType(Class typ) throws TypesAreFrozen {
        if (this.typesFrozen) {
            throw new TypesAreFrozen();
        }
        this.types.addElement(typ.getName());
    }

    public void freezeTypes() {
        this.typesFrozen = true;
    }

    public void setSize(int newSize) {
        this.data.setSize(newSize);
    }

    public int capacity() {
        return this.data.capacity();
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public Enumeration elements() {
        return this.data.elements();
    }

    public boolean contains(Object obj) {
        return this.data.contains(obj);
    }

    public int indexOf(Object obj) {
        return this.data.indexOf(obj);
    }

    public int indexOf(Object obj, int index) {
        return this.data.indexOf(obj, index);
    }

    public int lastIndexOf(Object obj) {
        return this.data.lastIndexOf(obj);
    }

    public int lastIndexOf(Object obj, int index) {
        return this.data.lastIndexOf(obj, index);
    }

    public Object elementAt(int index) {
        return this.data.elementAt(index);
    }

    public Object firstElement() {
        return this.data.firstElement();
    }

    public Object lastElement() {
        return this.data.lastElement();
    }

    public void setElementAt(Object obj, int index) throws WrongElementType, TypesNotFrozenYet {
        if (!this.typesFrozen) {
            throw new TypesNotFrozenYet();
        }
        if (!this.isObjectAllowed(obj)) {
            throw new WrongElementType(this.types, obj.getClass().getName());
        }
        this.data.setElementAt(obj, index);
    }

    public void removeElementAt(int index) {
        this.data.removeElementAt(index);
    }

    public void insertElementAt(Object obj, int index) throws WrongElementType, TypesNotFrozenYet {
        if (!this.typesFrozen) {
            throw new TypesNotFrozenYet();
        }
        if (!this.isObjectAllowed(obj)) {
            throw new WrongElementType(this.types, obj.getClass().getName());
        }
        this.data.insertElementAt(obj, index);
    }

    public void addElement(Object obj) throws WrongElementType, TypesNotFrozenYet {
        if (!this.typesFrozen) {
            throw new TypesNotFrozenYet();
        }
        if (!this.isObjectAllowed(obj)) {
            throw new WrongElementType(this.types, obj.getClass().getName());
        }
        this.data.addElement(obj);
    }

    public boolean removeElement(Object obj) {
        return this.data.removeElement(obj);
    }

    public boolean isObjectAllowed(Object o) {
        try {
            int i = 0;
            while (i < this.types.size()) {
                if (Class.forName((String)this.types.elementAt(i)).isInstance(o)) {
                    return true;
                }
                ++i;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return false;
    }
}

