/* Generated By:JavaCC: Do not edit this line. StarParser.java */
    package EDU.bmrb.starlibj;

    import java.util.*;
    import java.lang.*;
    import java.text.*;
    import EDU.bmrb.starlibj.*;

    /** This is the class that is used to parse a Star File.
      * This class was generated by the javacc tool from Sun.
      * To parse an input file or stream, do these steps:
      * <P>
      * <OL>
      *     <LI>Make a new instance of this class, giving the constructor
      *         a reference to the stream you wish to parse.<P></LI>
      *     <LI>Call the <TT>StarFileNodeParse()</TT> method to
      *         parse in a complete Star File.<P></LI>
      *     <LI>Call that object's <TT>popResult()</TT> method to see the
      *         final result of the parse (a StarFileNode).<P></LI>
      * </OL>
      * Here is an example code fragment implementing the above steps:
      * <P>
      * <PRE>
      *     StarParser   aParser;
      *     StarFileNode aStarTree;
      *     String       fileName = "sample.str";
      * 
      *     try
      *     {
      *         aParser = new StarParser(
      *                          new java.io.FileInputStream(fileName) );
      *
      *         aParser.StarFileNodeParse( aParser );
      *                       // 'aParser' needs to be sent as a
      *                       // parameter because javacc makes
      *                       // static methods that have no 'this'.
      *
      *         aStarTree = aParser.popResult();
      *     }
      *     // (catch() clauses left off to keep the example brief.)
      * </PRE>
      * <P>
      * Note that is is possible to parse in a smaller subset of the
      * STAR syntax if you are reading from a source that you know is not
      * a complete STAR file.  For example, you might want to parse a
      * file that contains only a single SaveFrameNode that was cut from
      * a larger file.  To do this, use the appropriate ...Parse() method
      * that goes with the name of the node you are trying to parse.  To
      * parse a save frame, use SaveFrameNodeParse().  To parse a loop,
      * use DataLoopNodeParse(), and so on.  Regardless of which Parse()
      * method you call, the result is always found by called popResult().
      * (Which is essentially showing what is at the top of the parse
      * stack after parsing completed.)
      * <P>
      * To parse multiple files, You must call StarParser.ReInit() between
      * parses, even if you make a new StarParser object.  This is because
      * the input stream in StarParse is handled using internal <em>static</em>
      * variables.
      * <P>
      * StarParser is <B>not thread safe</B>.  You should only run one
      * StarParser at a time.  Again, this is because of the shared
      * static data in the class.  (This is fixable, but only if we create
      * our own handmade stream-like class that implements the interface
      * javacc wants to see and then use that instead of one of the
      * standard java stream classes.  When we try to tell javacc to make
      * a non-static parser, it refuses to run on java.io.* stream classes.)
      */
    public class StarParser implements StarParserConstants {
        private Vector stk = new Vector();
                                // The Parse stack.  (Implemented as a vector
                                // so that we can peek under the top, which
                                // java.util.Stack won't let us do.)

        /** Truncate the stack such that everything above the index given
	  * gets removed.
	  */
        private void trunc( int idx)
        {
            if( verbose > 2 )
                System.out.println( "parsedebug: trunc begin. size = " +
                        (new Integer(stk.size())).toString() +
                        " idx to trunc at = " +
                        (new Integer(idx)).toString() );

            while( idx+1 < stk.size() )
            {
                stk.removeElementAt(idx+1);
            }

            if( verbose > 2 )
                System.out.println( "parsedebug: trunc done. size = " +
                        (new Integer(stk.size())).toString() );
        }
        /** Peek at the element at the Nth position from the top, where N starts
	  * at 1, not zero.
	  */
        private Object peek( int n )
        {
            if( verbose > 2 )
                System.out.println( "parsedebug: peeking at " +
                        (new Integer(n)).toString() +
                        " from the top of a stack of size " +
                        (new Integer(size())).toString() );
            return stk.elementAt( size() - n );
        }
        /** Get the element at the index given from the vector: */
        private Object elementAt( int i )
        {
            if( verbose > 2 )
                System.out.println( "parsedebug: peeking at " +
                        (new Integer(i)).toString() +
                        " from the botom of a stack of size " +
                        (new Integer(size())).toString() );
            return stk.elementAt(i);
        }
        /** Push a new element onto the top of the stack:
	  */
        private void push( Object o )
        {
            if( verbose > 2 )
                System.out.println( "parsedebug: pushing" +
                        " onto a stack of size " +
                        (new Integer(size())).toString() );
            stk.addElement(o);
        }
        /** Get the size of the stack:
	  */
        private int size()
        {
            return stk.size();
        }
        /** Get the StarNode object that was created by the parse.
	  * When the parse is complete, if no exceptions were
	  * thrown, then this method will return the object that
	  * was parsed.  The object parsed is the last thing
	  * left on the stack.  This method will also pop the
	  * object off the stack, so only the first call to this method
	  * after a parse will work properly.  This was necessary to
	  * accomodate the Java garbage collector (Otherwise the reference
	  * to the item on the top of the stack would live forever and
	  * therefore the thing that was parsed (typically a StarFileNode)
          * and all its children would remain in memory forever.)
	  */
        public StarNode popResult()
        {
            StarNode retVal = (StarNode) peek(1);
            trunc( -1 ); // cut down to zero size

            // This only works correctly on some of the types of
            // Star Node.  The for the rest nothing will happen.
            if( retVal.mySkips() != null )
                retVal.mySkips().setSkipTexts( skipStrings, skipLineNums );
            if( skipStrings != null )
                skipStrings.clear();
            if( skipLineNums != null )
                skipLineNums.clear();
            return retVal;
        }

        /** This method is depreciated and just is a call to
	  * <TT>popResult()</TT>.  Please use popResult() instead
	  * in future coding projects.
	  * @depreciated
	  */
        public StarNode endResult()
        {
            return popResult();
        }

        /** Call this method before parsing to turn on some debugging
	  * printing.  Mostly this is for internal debugging.
	  * @param verboseNum = set to higher numbers for more info,
	  *    (0 = silent)
	  * (Default is false when a StarParser is constructed.)
	  */
        public void setVerbose( int verboseNum )
        {
            verbose = verboseNum;
        }

        /** Trim the stack after a big deletion.  Normally there is a lot of
	  * overhead in a Vector and it doesn't go away when the elements are
	  * removed.  The capacity remains large long after the elements
	  * are no longer in use.  This enforces the throwing away of the
	  * deleted elements:
	  * Do not call this method while the stack is still expected to
	  * grow bigger or it will make things execute very slowly.  (This
	  * method removes all overhead room from the stack so that on the
	  * next insertion it will have to reallocate space again.)
	  * For best results, this method is only called when a large
	  * deletion from the stack has just been done (for example,
	  * a loop node was just made and all the values in it just got
	  * popped.)
	  */
        public void trimToSize()
        {
            stk.trimToSize();
        }

        /** Get the number of values that should be in one row
	  * for the nesting level given for the most recently
	  * parsed DataLoopNameListNode.  This is the count
	  * of the number of DataNameNodes at that nesting level,
	  * for the DataLoopNameListNode that is closest to the
	  * top of the stack.
	  * Returns 0 if there is no such nesting level or no such
	  * previous loop on the stack.
	  */
        public int getNumValsInCurLoopAtLevel( int nest )
        {
            // Step 1 is to find the topmost DataLoopNameListNode

            try
            {
                int i;
                int stackSize = size();
                for( i = 1 ; i <= stackSize ; i++ )
                {
                    if( Class.forName( symbolDataLoopNameListNode ).isInstance(
                                peek(i) ) )
                    {
                        break;
                    }
                }
                if( i > stackSize )
                {
                    return 0;
                }

                // Now that the topmost name list was found, get the number
                // of names at the given nesting level:

                DataLoopNameListNode node = (DataLoopNameListNode) peek(i);
                if( nest < 0 || nest >= node.size() )
                {
                    return 0;
                }
                return node.elementAt(nest).size();
            }
            catch( ClassNotFoundException e )
            {
                System.out.println( e.getMessage() );
                e.printStackTrace();
                return 0;
            }
        }

        /** save the skipped string that has been built up by
          * the token manager.
          */
        public static void saveSkippedString( int l_num, StringBuffer s)
        {
            StringBuffer sb = new StringBuffer(s.length());
            Integer ln = new Integer(l_num);
            sb.append( s.toString() );

            if( skipStrings == null )
                skipStrings = new Vector();
            skipStrings.add( sb );
            if( skipLineNums == null )
                skipLineNums = new Vector();
            skipLineNums.add( ln );
        }

        /** This is for internal debugging only: */
        void dumpStack()
        {
            int i;
            int sz = size();

            int verboseRemember = verbose;
            verbose = 0;

            System.out.println( "           stack dump: " );
            for( i = sz-1 ; i >= 0 ; i-- )
            {
                if( i == sz-1 )
                    System.out.print( "   TOP->" );
                else if( i == 0 )
                    System.out.print( "BOTTOM->" );
                else
                    System.out.print( "        " );
                System.out.print( (new Integer(i)).toString() + " ");
                if( elementAt(i) == null )
                    System.out.print("(null)");
                else
                {
                    try
                    {
                        Object obj = elementAt(i);
                        System.out.print( "type = " +
                                    obj.getClass().getName() + " " );
                        if     ( Class.forName( symbolDataValueNode
                                              ).isInstance(obj)   )
                        {
                            System.out.print( "name = " +
                                    ((DataValueNode)obj).getValue() );
                        }
                        else if( Class.forName( symbolDataNameNode
                                              ).isInstance(obj)  )
                        {
                            System.out.print( "name = " +
                                    ((DataNameNode)obj).getLabel() );
                        }
                        else if(Class.forName( symbolDataItemNode
                                             ).isInstance(obj)  )
                        {
                            System.out.print( "name = " +
                                    ((DataItemNode)obj).getLabel() +
                                    " value = " +
                                    ((DataItemNode)obj).getValue() );
                        }
                        else if(Class.forName( symbolBlockNode
                                             ).isInstance(obj)  )
                        {
                            System.out.print( "name = " +
                                    ((BlockNode)obj).getLabel() );
                        }
                        else if(Class.forName( symbolSaveFrameNode
                                             ).isInstance(obj)  )
                        {
                            System.out.print( "name = " +
                                    ((SaveFrameNode)obj).getLabel() );
                        }
                    }
                    catch( ClassNotFoundException e )
                    {
                    }
                    System.out.println("");
                }
            }
            verbose = verboseRemember;
        }

        private static int verbose = 0;
        private static Vector skipStrings;
        private static Vector skipLineNums;
        public static int prevLine = -1;
        public static String symbolTinyAbsTypeName =
            "EDU.bmrb.starlibj.TinyAbsDataValueNode" ;
        public static String symbolDataValueNode =
            "EDU.bmrb.starlibj.DataValueNode" ;
        public static String symbolDataNameNode =
            "EDU.bmrb.starlibj.DataNameNode" ;
        public static String symbolDataItemNode =
            "EDU.bmrb.starlibj.DataItemNode" ;
        public static String symbolBlockNode =
            "EDU.bmrb.starlibj.BlockNode" ;
        public static String symbolSaveFrameNode =
            "EDU.bmrb.starlibj.SaveFrameNode" ;
        public static String symbolHomemadeStringBuffer =
            "EDU.bmrb.starlibj.HomemadeStringBuffer" ;
        public static String symbolLoopTableNode =
            "EDU.bmrb.starlibj.LoopTableNode" ;
        public static String symbolDataLoopNameListNode =
            "EDU.bmrb.starlibj.DataLoopNameListNode" ;

        /** notes the start of a line num */
        public static char lineDelim  = '\001';
        /** notes the start of a value's column num */
        public static char fieldDelim = '\002';
        /** marks the value as single-quote delimited */
        public static char singleMarker = '\025';
        /** marks the value as double-quote delimited */
        public static char doubleMarker = '\026';
        /** marks the value as semicolon delimited */
        public static char semicolonMarker = '\027';
        /** marks the value as framecode delimited */
        public static char framecodeMarker = '\030';
        /** marks the value as non delimited */
        public static char nonMarker = '\031';

  static final public void EpsilonParse() throws ParseException {

  }

/** This method will parse an entire star file.
  * You can get to it by calling popResult() after it
  * finishes.
  */
  static final public void StarFileNodeParse(StarParser p) throws ParseException {
                                         int stkStart = p.size()-1;
    label_1:
    while (true) {
      BlockNodeParse(p);
      switch (jj_nt.kind) {
      case GLOBALSTART:
      case DATASTART:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
    }
        int          i;
        int          sz = p.size();
        StarFileNode me = new StarFileNode();

        for( i = stkStart + 1 ; i < sz ; i++ )
        {   me.addElement( (BlockNode) p.elementAt(i) );
            if( i == stkStart + 1 )
            {
                me.setLineNum( ( (StarNode) p.elementAt(i) ).getLineNum() );
                me.setColNum( ( (StarNode) p.elementAt(i) ).getColNum() );
            }
        }
        p.trunc(stkStart);
        p.push(me);
        p.trimToSize();
  }

/** This method will parse a single BlockNode (a global_ or data_
  * block.)
  * You can get to it by calling popResult() after it
  * finishes.
  * @param p It is necessary to pass the StarParser object itself because
  * when javacc generates this source code, it generates this method with
  * static scope (hence it has no concept of 'this'.)
  */
  static final public void BlockNodeParse(StarParser p) throws ParseException {
        Token t1 = getToken(1);
        int stkStart = p.size()-1;
        String t1_image = t1.image;
        int t1_beginLine = t1.beginLine;
        int t1_beginColumn = t1.beginColumn;

        t1 = null;
    switch (jj_nt.kind) {
    case DATASTART:
      jj_consume_token(DATASTART);
      break;
    case GLOBALSTART:
      jj_consume_token(GLOBALSTART);
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_2:
    while (true) {
      DataNodeParse(p);
      switch (jj_nt.kind) {
      case LOOPSTART:
      case SAVESTART:
      case TAGNAME:
        ;
        break;
      default:
        jj_la1[2] = jj_gen;
        break label_2;
      }
    }
        int       i;
        int       sz = p.size();
        BlockNode me = null;

        me = new BlockNode(t1_image);
        me.setLineNum( t1_beginLine );
        me.setColNum( t1_beginColumn );

        for( i = stkStart + 1 ; i < sz ; i++ )
        {   me.addElement( (StarNode) p.elementAt(i) );
        }
        p.trunc(stkStart);
        p.push(me);
        p.trimToSize();
  }

/** This method will parse either a single DataItemNode, or
  * a single DataLoopNode, or a single SaveFrameNode.
  * You can get to it by calling popResult() after it
  * finishes.  You will need to use the type-aware features
  * of Java in java.lang.Class in order to figure out which
  * of these three kinds of node was returned in popResult().
  * @param p It is necessary to pass the StarParser object itself because
  * when javacc generates this source code, it generates this method with
  * static scope (hence it has no concept of 'this'.)
  */
  static final public void DataNodeParse(StarParser p) throws ParseException {
    switch (jj_nt.kind) {
    case TAGNAME:
      DataItemNodeParse(p);

      break;
    case LOOPSTART:
      DataLoopNodeParse(p);

      break;
    case SAVESTART:
      SaveFrameNodeParse(p);

      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/** This method will parse a single DataItemNode.
  * You can get to it by calling popResult() after it
  * finishes.
  * @param p It is necessary to pass the StarParser object itself because
  * when javacc generates this source code, it generates this method with
  * static scope (hence it has no concept of 'this'.)
  */
  static final public void DataItemNodeParse(StarParser p) throws ParseException {
                                         int stkStart = p.size()-1;
    DataNameNodeParse(p);
    DataValueNodeParse(p);
            DataItemNode me = new DataItemNode(
                    (DataNameNode)p.peek(2),
                    (DataValueNode)p.peek(1) );

            me.setLineNum( ( (DataValueNode)p.peek(1) ).getLineNum() );
            me.setColNum( ( (DataValueNode)p.peek(1) ).getColNum() );

            p.trunc(stkStart);
            p.push( me );
  }

/** This method will parse a single DataNameNode (a tag).
  * You can get to it by calling popResult() after it
  * finishes.
  * @param p It is necessary to pass the StarParser object itself because
  * when javacc generates this source code, it generates this method with
  * static scope (hence it has no concept of 'this'.)
  */
  static final public void DataNameNodeParse(StarParser p) throws ParseException {
        Token t1 = getToken(1);
        String t1_image = t1.image;
        int    t1_beginLine = t1.beginLine;
        int    t1_beginColumn = t1.beginColumn;
        t1 = null;
    jj_consume_token(TAGNAME);
        DataNameNode me = new DataNameNode( t1_image );
        me.setLineNum( t1_beginLine );
        me.setColNum( t1_beginColumn );
        p.push( me );
  }

/** This method will parse a single TinyAbsDataValueNode.
  * You can get to it by calling popResult() after it
  * finishes.
  * @param p It is necessary to pass the StarParser object itself because
  * when javacc generates this source code, it generates this method with
  * static scope (hence it has no concept of 'this'.)
  */
  static final public void TinyAbsDataValueNodeParse(StarParser p) throws ParseException {
        Token t1 = getToken(1);
        int stkStart = p.size()-1;
        String t1_image = t1.image;
        int    t1_beginLine = t1.beginLine;
        int    t1_beginColumn = t1.beginColumn;
        t1 = null;
    DataValueNodeParse(p);
        try
        {
            DataValueNode meDVN = (DataValueNode) (p.peek(1));
            HomemadeStringBuffer buf;

            p.trunc( stkStart ); // remove the DataValueNode
            if( Class.forName( p.symbolHomemadeStringBuffer ) .
                            isInstance( p.peek(1) ) )

            {
                // Get what was under the DataValueNode.
                buf = (HomemadeStringBuffer) p.peek(1);
            }
            else
            {
                // This is the first value in the list - so start a fresh
                // string buffer and put it on the top of the stack.
                buf = new HomemadeStringBuffer( "" ) ;
                prevLine = -1;
                p.push( buf );
            }

            // Append this value to the previous one that was on the
            // topmost stack position.  In this way, consecutive
            // DataValueNodes end up getting stored as just one long
            // string in memory instead of as seperate values on the
            // stack - this saves lots of memory in Java, where each
            // new reference has lots of overhead.
            // - - - - - - - - - - - - - - - - - - - - - - - - - - -

            // I am using \001 as a terminator marker between lines, and
            // \002 as a terminator marker between fields on the line.
            // Example:  if the file was:
            //             Column zero
            //             |
            //             V
            //            +-----------------------
            // (line 1)-->|foo bar
            // (line 2)-->|one
            // (line 3)-->|  hello
            //
            // Then the buffer would hold that as:
            //  "\001" + "1" + "\002" + "1" + "\002" + "foo" + 
            //        "\002" + "5" + "\002" + "bar" +
            //  "\001" + "2" + "\022" + "1" + "\002" + "one" +
            //  "\001" + "3" + "\022" + "3" + "\002" + "hello" 
            if( prevLine != t1_beginLine )
            {
                buf.append( p.lineDelim );
                buf.append( String.valueOf( t1_beginLine ) );
                prevLine = t1_beginLine; // prevLine is a static variable,
                                         // So this change will stay
                                         // between this and the next call
                                         // to this method.
            }
            // Doing it this way is much faster than using Java's
            // built-in string '+' operator.  Java's '+' ends up
            // creating a lot of temp objects that get thrown away
            // right afterward and this eats lots of CPU time.
            buf.append( p.fieldDelim ) ;
            buf.append( String.valueOf( t1_beginColumn ) );
            buf.append( p.fieldDelim );

            // Prepend a magic character that will indicate the delimiter
            // type:
            short delim = meDVN.getDelimType();
            if( delim == DataValueNode.SINGLE )
            {
                buf.append( p.singleMarker );
                buf.append( meDVN.getValue() );
            }
            else if( delim == DataValueNode.DOUBLE )
            {
                buf.append( p.doubleMarker );
                buf.append( meDVN.getValue() );
            }
            else if( delim == DataValueNode.SEMICOLON )
            {
                buf.append( p.semicolonMarker );
                buf.append( meDVN.getValue() );
            }
            else if( delim == DataValueNode.FRAMECODE )
            {
                buf.append( framecodeMarker );
                buf.append( meDVN.getValue() );
            }
            else // nondelimited or dont-care
            {
                buf.append( nonMarker );
                buf.append( meDVN.getValue() );
            }

            meDVN = null;
            buf = null; // throw away my reference to it.

        }
        catch( ClassNotFoundException e )
        {
            System.out.println( e.getMessage() );
            e.printStackTrace();
        }
  }

/** This method will parse a single DataValueNode.
  * You can get to it by calling popResult() after it
  * finishes.
  * @param p It is necessary to pass the StarParser object itself because
  * when javacc generates this source code, it generates this method with
  * static scope (hence it has no concept of 'this'.)
  */
  static final public void DataValueNodeParse(StarParser p) throws ParseException {
        Token t1 = getToken(1);
        String t1_image = t1.image;
        int    t1_beginLine = t1.beginLine;
        int    t1_beginColumn = t1.beginColumn;
        t1 = null;  // help the garbage collecter, see comment
                    // for BlockNodeParse for explation.
        int   firstq;
        int   lastq;
        DataValueNode me;
    switch (jj_nt.kind) {
    case DVNNON:
      jj_consume_token(DVNNON);
        me = new DataValueNode( t1_image, DataValueNode.NON );

        me.setLineNum( t1_beginLine );
        me.setColNum( t1_beginColumn );
        p.push( me );
      break;
    case DVNFRAMECODE:
      jj_consume_token(DVNFRAMECODE);
        me = new DataValueNode(
                        t1_image.substring( 1, t1_image.length() ),
                        DataValueNode.FRAMECODE );

        me.setLineNum( t1_beginLine );
        me.setColNum( t1_beginColumn );
        p.push( me );
      break;
    case DVNSINGLE:
      jj_consume_token(DVNSINGLE);
        firstq = t1_image.indexOf('\'');
        lastq = t1_image.lastIndexOf('\'');
        me = new DataValueNode( t1_image.substring( firstq+1,lastq ),
                                   DataValueNode.SINGLE );

        me.setLineNum( t1_beginLine );
        me.setColNum( t1_beginColumn );
        p.push( me );
      break;
    case DVNDOUBLE:
      jj_consume_token(DVNDOUBLE);
        firstq = t1_image.indexOf('\"');
        lastq = t1_image.lastIndexOf('\"');
        me =  new DataValueNode( t1_image.substring(firstq+1,lastq),
                                   DataValueNode.DOUBLE );

        me.setLineNum( t1_beginLine );
        me.setColNum( t1_beginColumn );
        p.push( me );
      break;
    case DVNSEMICOLON:
      jj_consume_token(DVNSEMICOLON);
        firstq = t1_image.indexOf(';');
        lastq = t1_image.lastIndexOf(';');

        // Skip the one single leading end-of-line if
        // there is one immediately after the semicolon;
        // (where a single end-of-line is defined to be 
        // either \n or \r or \r\n or \n\r, but not
        // \n\n or \r\r. (those are two different
        // end of lines back-to-back, of which only the
        // first should be skipped))
        // -------------------------------------------------
        if( t1_image.charAt( firstq+1 ) == '\r' )
        {   if( t1_image.charAt( firstq+2 ) == '\n' )
            {   ++firstq;
            }
            ++firstq;
        }
        else if( t1_image.charAt( firstq+1 ) == '\n' )
        {   if( t1_image.charAt( firstq+2 ) == '\r' )
            {   ++firstq;
            }
            ++firstq;
        }
        me = new DataValueNode(
                        t1_image.substring( firstq+1, lastq ),
                        DataValueNode.SEMICOLON );

        me.setLineNum( t1_beginLine );
        me.setColNum( t1_beginColumn );
        p.push( me );
      break;
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/** This method will parse a single SaveFrameNode.
  * You can get to it by calling popResult() after it
  * finishes.
  * @param p It is necessary to pass the StarParser object itself because
  * when javacc generates this source code, it generates this method with
  * static scope (hence it has no concept of 'this'.)
  */
  static final public void SaveFrameNodeParse(StarParser p) throws ParseException {
        Token  t1          = getToken(1);
        {}
        int    stkStart    = p.size()-1;
        String t1_image    = t1.image;
        int t1_beginLine   = t1.beginLine;
        int t1_beginColumn = t1.beginColumn;

        t1 = null;
    jj_consume_token(SAVESTART);
    label_3:
    while (true) {
      switch (jj_nt.kind) {
      case LOOPSTART:
      case TAGNAME:
        ;
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_3;
      }
      SaveDataNodeParse(p);
    }
    jj_consume_token(SAVEEND);
        int            i;
        int            sz = p.size();
        SaveFrameNode  me =null;
        me = new SaveFrameNode( t1_image );
        me.setLineNum( t1_beginLine );
        me.setColNum( t1_beginColumn );

        for( i = stkStart + 1 ; i < sz ; i++ )
        {   me.addElement( (StarNode) p.elementAt(i) );
        }
        p.trunc(stkStart);
        p.push(me);
        p.trimToSize();
  }

/** This method will parse one of the items that is allowed inside
  * a SaveFrameNode.  (Either a single DataItemNode, or
  * a single DataLoopNode.)
  * You can get to it by calling popResult() after it
  * finishes.  You will need to use the type-aware features
  * of Java in java.lang.Class in order to figure out which
  * of these three kinds of node was returned in popResult().
  * @param p It is necessary to pass the StarParser object itself because
  * when javacc generates this source code, it generates this method with
  * static scope (hence it has no concept of 'this'.)
  */
  static final public void SaveDataNodeParse(StarParser p) throws ParseException {
    switch (jj_nt.kind) {
    case TAGNAME:
      DataItemNodeParse(p);

      break;
    case LOOPSTART:
      DataLoopNodeParse(p);

      break;
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

// Makes a simple list like "value value ..."
// This will be used to construct the loop later.
// This rule is no longer in use but is left in case we
// end up changing the code to use it again.
  static final public void LoopValuesParse(StarParser p) throws ParseException {
    label_4:
    while (true) {
      DataValueNodeParse(p);
      switch (jj_nt.kind) {
      case DVNFRAMECODE:
      case DVNSEMICOLON:
      case DVNNON:
      case DVNSINGLE:
      case DVNDOUBLE:
        ;
        break;
      default:
        jj_la1[7] = jj_gen;
        break label_4;
      }
    }
    label_5:
    while (true) {
      switch (jj_nt.kind) {
      case STOP:
        ;
        break;
      default:
        jj_la1[8] = jj_gen;
        break label_5;
      }
      StopParse(p);
      label_6:
      while (true) {
        switch (jj_nt.kind) {
        case DVNFRAMECODE:
        case DVNSEMICOLON:
        case DVNNON:
        case DVNSINGLE:
        case DVNDOUBLE:
          ;
          break;
        default:
          jj_la1[9] = jj_gen;
          break label_6;
        }
        DataValueNodeParse(p);
      }
    }

  }

// Needed so that a STOP mark gets p.pushed on the stack.
  static final public void StopParse(StarParser p) throws ParseException {
    jj_consume_token(STOP);
        p.push( new Integer(999) ); // Use this to mark a stop on the stack.

  }

  static final public void OptionalStopParse(StarParser p) throws ParseException {
    switch (jj_nt.kind) {
    case STOP:
      jj_consume_token(STOP);

      break;
    default:
      jj_la1[10] = jj_gen;
      EpsilonParse();

    }
  }

/** This method parses a table of values, presuming that the
  * DataLoopNameListNode has already been properly parsed to
  * hold the numbers of values in each nesting level.
  */
  static final public void LoopTableNodeParse(StarParser p, int nest) throws ParseException {
        int stkStart = p.size()-1;
        LoopTableNode me = new LoopTableNode();
    switch (jj_nt.kind) {
    case DVNFRAMECODE:
    case DVNSEMICOLON:
    case DVNNON:
    case DVNSINGLE:
    case DVNDOUBLE:
      label_7:
      while (true) {
        LoopRowNodeParse(p, me, nest);
        switch (jj_nt.kind) {
        case DVNFRAMECODE:
        case DVNSEMICOLON:
        case DVNNON:
        case DVNSINGLE:
        case DVNDOUBLE:
          ;
          break;
        default:
          jj_la1[11] = jj_gen;
          break label_7;
        }
      }
      OptionalStopParse(p);
        // Token consumedToken;
        // int nextTokenKind = jj_nt.kind;
        // if( nextTokenKind == STOP )
        // {
        //     consumedToken = getNextToken();
        // }
        p.push(me);
      break;
    case STOP:
      jj_consume_token(STOP);
        p.push(null);
      break;
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/** This method parses a single row of values, presuming that
  * the DataLoopNameListNode has already been parsed and is
  * on the stack underneath the current position.
  */
  static final public void LoopRowNodeParse(StarParser p, LoopTableNode tbl, int nest) throws ParseException {
        int stkStart = p.size()-1;
        int n = p.getNumValsInCurLoopAtLevel( nest );
    DataValueNodeParse(p);
    RestOfLoopRowNodeParse(p, nest, n-1);
        LoopRowNode me = (LoopRowNode)( p.peek(1) );
        me.setElementAt( (DataValueNode)( p.peek(2) ), 0 );
        p.trunc(stkStart);
        tbl.addElement(me);

        // Check for suspicious line numbers that might mean
        // a value was added or omitted.  Don't throw the
        // exception yet, but generate the exception for
        // potential throwing later.  Only throw the exceptions
        // generated this way if at the bottom of the loop it
        // turns out the counts are off.
        // ------------------------------------------------------

        int valNum, prevLineNum, thisLineNum;
        boolean someOnSameLine = false;

        // Starting at 1 not zero is deliberate.  Don't "fix" it:
        // ------------------------------------------------------
        for( valNum = 1 ; valNum < me.size() ; valNum++ )
        {   // The line numbers are suspicious if and only if
            // some but not all the values are on the same line.
            // If all are on different lines, that is not
            // suspicious.  If all are on the same line,
            // that is not suspicious:
            prevLineNum = ( (DataValueNode) (me.elementAt(valNum-1))
                          ).getLineNum();
            thisLineNum = ( (DataValueNode) (me.elementAt(valNum-1))
                          ).getLineNum();
            if( prevLineNum == thisLineNum )
                someOnSameLine = true;
            if( someOnSameLine && prevLineNum != thisLineNum )
            {
                // TODO - generate the ParseException here.
            }
        }
  }

/** Get the rest of the loop row node and then fill up a loop row
  * node and put it on the stack.  The first element will be missing
  * because it will need to be filled in later (See LoopRowNodeParse)
  * . The reason for this is that if this parse routine started at
  * the beginning of a loop row, then it would be at a decision point
  * and javacc cannot deal with decision points at JAVACODE rules.
  */
  static void RestOfLoopRowNodeParse(StarParser p, int nest, int remainingVals) throws ParseException {
    LoopRowNode me = new LoopRowNode();
    int i;
    int stkStart = p.size() - 1;

    me.setLineNum( ( (DataValueNode) p.peek(1) ).getLineNum() );
    me.setColNum( ( (DataValueNode) p.peek(1) ).getColNum() );

    // Placeholder for the first value which is actually parsed
    // elsewhere outside this rule:
    me.addElement( new DataValueNode( "ParseDummy" , DataValueNode.NON ) );

    for( i = 0 ; i < remainingVals ; i++ )
    {
        DataValueNodeParse( p );
        me.addElement( (DataValueNode)( p.peek(1) ) );
    }

    // Now we need to read ahead to see what the next value is:
    // Token consumedToken;
    // int nextTokenKind = jj_nt.kind;
    // if( nextTokenKind == STOP )
    // {
// 	// consumedToken = getNextToken();
    // }
    // else if( nextTokenKind == DVNNON ||
// 	     nextTokenKind == DVNSINGLE ||
// 	     nextTokenKind == DVNDOUBLE ||
// 	     nextTokenKind == DVNSEMICOLON ||
// 	     nextTokenKind == DVNFRAMECODE )
//     {
// 	int n = p.getNumValsInCurLoopAtLevel( nest + 1 );
// 	// Inner loop, drop a nesting level and do it:
// 	if( n > 0 )
// 	{
// 	    LoopTableNodeParse( p, nest + 1 );
// 	    me.setInnerLoop( (LoopTableNode) (p.peek(1)) );
// 	}
        // no inner loop - stay at this nest level.
//     }
    // else not a legal loop value, nothing more to do.

    // Drop to the inner loop if this is not the deepest nest level:
    int n = p.getNumValsInCurLoopAtLevel( nest + 1 );
    if( n > 0 )
    {
        LoopTableNodeParse( p, nest + 1 );
        if( p.peek(1) != null )
            me.setInnerLoop( (LoopTableNode) (p.peek(1)) );
    }


    p.trunc(stkStart);
    p.push(me);
  }

/** This method will parse a single DataLoopNode.
  * You can get to it by calling popResult() after it
  * finishes.
  * @param p It is necessary to pass the StarParser object itself because
  * when javacc generates this source code, it generates this method with
  * static scope (hence it has no concept of 'this'.)
  */
  static final public void DataLoopNodeParse(StarParser p) throws ParseException, ParseException {
        int stkStart = p.size()-1;
    DataLoopNameListNodeParse(p);
    LoopTableNodeParse(p, 0);
        DataLoopNode          me;
        LoopTableNode         myValues = new LoopTableNode();
        DataLoopNameListNode  myNames;
        int                   i;

        myNames = (DataLoopNameListNode)( p.peek(2) );
        myValues = (LoopTableNode)( p.peek(1) );
        if( myValues == null ) // make an empty row if there's no loop values:
        {
           myValues = new LoopTableNode();
        }
        me = new DataLoopNode( myNames, myValues );

        // change the tab flag depending on if the first
        // row is linear or tabulated:
        // ---------------------------------------------

        me.setTabFlag( false ); // the default

        if( me.getVals().size() > 0 )
        {
            int prev_line = -9999;
            for( i = 0 ; i < (me.getVals().elementAt(0)).size() ; i++ )
            {
                if( prev_line ==
                       me.getVals().elementAt(0).elementAt(i).getLineNum() )
                {
                    me.setTabFlag( true );
                    break;
                }
                prev_line = me.getVals().elementAt(0).elementAt(i).getLineNum();
            }
        }

        p.trunc(stkStart);
        me.setLineNum( myNames.getLineNum() );
        me.setColNum( myNames.getColNum() );
        p.push(me);
        p.trimToSize();

        if( me.getVals().size() == 0 )
        {
            String msg = "In STAR, it is illegal to have a loop " +
                         "with just tag names with no values.  " +
                         "Error occured at line " +
                         String.valueOf( myNames.getLineNum() ) +
                         ".";
            {if (true) throw new ParseException( msg );}
        }
  }

  static final public void DataLoopNameListNodeParse(StarParser p) throws ParseException {
                                                 int stkStart = p.size()-1;
    label_8:
    while (true) {
      jj_consume_token(LOOPSTART);
      LoopNameListNodeParse(p);
      switch (jj_nt.kind) {
      case LOOPSTART:
        ;
        break;
      default:
        jj_la1[13] = jj_gen;
        break label_8;
      }
    }
        int                   i;
        int                   sz = p.size();
        DataLoopNameListNode  me = new DataLoopNameListNode();

        for( i = stkStart + 1 ; i < sz ; i++ )
        {   me.addElement( (LoopNameListNode) p.elementAt(i) );
            if( i == stkStart + 1 )
            {   me.setLineNum(
                        ( (LoopNameListNode) p.elementAt(i) ).getLineNum() );
                me.setColNum(
                        ( (LoopNameListNode) p.elementAt(i) ).getColNum() );
            }
        }
        p.trunc(stkStart);
        p.push(me);
  }

  static final public void LoopNameListNodeParse(StarParser p) throws ParseException {
      int stkStart = p.size()-1;
    label_9:
    while (true) {
      DataNameNodeParse(p);
      switch (jj_nt.kind) {
      case TAGNAME:
        ;
        break;
      default:
        jj_la1[14] = jj_gen;
        break label_9;
      }
    }
        int               i;
        int               sz = p.size();
        LoopNameListNode  me = new LoopNameListNode();

        for( i = stkStart + 1 ; i < sz ; i++ )
        {   me.addElement( (DataNameNode) p.elementAt(i) );
            if( i == stkStart + 1 )
            {   me.setLineNum(
                        ( (DataNameNode) p.elementAt(i) ).getLineNum() );
                me.setColNum(
                        ( (DataNameNode) p.elementAt(i) ).getColNum() );
            }
        }
        p.trunc(stkStart);
        p.push(me);
  }

  static private boolean jj_initialized_once = false;
  static public StarParserTokenManager token_source;
  static ASCII_CharStream jj_input_stream;
  static public Token token, jj_nt;
  static private int jj_gen;
  static final private int[] jj_la1 = new int[15];
  static final private int[] jj_la1_0 = {0x9000,0x9000,0x50800,0x50800,0x25a0000,0x40800,0x40800,0x25a0000,0x2000,0x25a0000,0x2000,0x25a0000,0x25a2000,0x800,0x40000,};

  public StarParser(java.io.InputStream stream) {
    if (jj_initialized_once) {
      System.out.println("ERROR: Second call to constructor of static parser.  You must");
      System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
      System.out.println("       during parser generation.");
      throw new Error();
    }
    jj_initialized_once = true;
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new StarParserTokenManager(jj_input_stream);
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 15; i++) jj_la1[i] = -1;
  }

  static public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 15; i++) jj_la1[i] = -1;
  }

  public StarParser(java.io.Reader stream) {
    if (jj_initialized_once) {
      System.out.println("ERROR: Second call to constructor of static parser.  You must");
      System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
      System.out.println("       during parser generation.");
      throw new Error();
    }
    jj_initialized_once = true;
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new StarParserTokenManager(jj_input_stream);
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 15; i++) jj_la1[i] = -1;
  }

  static public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 15; i++) jj_la1[i] = -1;
  }

  public StarParser(StarParserTokenManager tm) {
    if (jj_initialized_once) {
      System.out.println("ERROR: Second call to constructor of static parser.  You must");
      System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
      System.out.println("       during parser generation.");
      throw new Error();
    }
    jj_initialized_once = true;
    token_source = tm;
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 15; i++) jj_la1[i] = -1;
  }

  public void ReInit(StarParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 15; i++) jj_la1[i] = -1;
  }

  static final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken = token;
    if ((token = jj_nt).next != null) jj_nt = jj_nt.next;
    else jj_nt = jj_nt.next = token_source.getNextToken();
    if (token.kind == kind) {
      jj_gen++;

      // The next lines inserted by BMRB into the 
      // JavaCC-generated code.  This fixes a garbage 
      // collection problem that was making us run out 
      // of memory parsing large files.  Without the 
      // next line, the default JavaCC-generated file 
      // would have left a huge linked-list laying 
      // around of all the tokens in a rule.  This is 
      // devastating when dealing with big loops. 

      // { BEGIN section inserted by BMRB:
           oldToken.next = null ;
           oldToken.specialToken = null ;
      // } END section inserted by BMRB:

      return token;
    }
    jj_nt = token;
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static final public Token getNextToken() {
    if ((token = jj_nt).next != null) jj_nt = jj_nt.next;
    else jj_nt = jj_nt.next = token_source.getNextToken();
    jj_gen++;
    return token;
  }

  static final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  static private java.util.Vector jj_expentries = new java.util.Vector();
  static private int[] jj_expentry;
  static private int jj_kind = -1;

  static final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[31];
    for (int i = 0; i < 31; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 15; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 31; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  static final public void enable_tracing() {
  }

  static final public void disable_tracing() {
  }

    }
