
package EDU.bmrb.starlibj.examples;

import EDU.bmrb.starlibj.*;
import java.io.*;

public class ParseOnly {

    static boolean demonstrate_unparse = false;
    
    public ParseOnly () {

    }

    static public void main( String args[] ) {


	java.lang.Runtime.getRuntime().gc(); // force garbage collection.
	
	doMain( args );

    }


    static public void doMain(String args[]) {

	StarFileNode             sfnInput = null;
	java.io.FileInputStream  inStream = null;
	StarParser               myParser = null;
	StarUnparser             myUnparser = null;
	System.out.println("Test of the starlibj library.");
	String                   parseFname = args[0];
	java.io.FileOutputStream passout1 = null;
	try
	{
	    
	    java.lang.Runtime.getRuntime().gc(); // force garbage collection.

	    // read in the starting input file:
	    // --------------------------------
	    inStream =  new java.io.FileInputStream(parseFname);
	    myParser = new StarParser( inStream );
	    passout1 = new java.io.FileOutputStream(parseFname+".1");
	}
	catch( FileNotFoundException e)
	{
	    System.out.println("Can't open file: '" + parseFname + "'.\n" );
	    e.printStackTrace();
	}
	catch( java.io.IOException e )
	{
	    System.out.println("IO exception: " + e.getMessage() );
	    e.printStackTrace();
	}
	try {
	    myParser.StarFileNodeParse(myParser);
	}
	catch( ParseException e)
	{
	    System.out.println("Parse Exception: " + e.getMessage() );
	    // e.printStackTrace();
	    sfnInput = (StarFileNode) myParser.popResult();
	    myUnparser = new StarUnparser( passout1 );
	    myUnparser.setFormatting( true );
	    myUnparser.writeOut( sfnInput, 0 );
	    return ;
	}
	sfnInput = (StarFileNode) myParser.popResult();

	java.lang.Runtime.getRuntime().gc(); // force garbage collection.

	if( demonstrate_unparse )
	{
	    System.out.println( "Starting to unparse it." );
	    // Ouptut the version we just read, nicely
	    // ----------------------------------------------
	    myUnparser = new StarUnparser( passout1 );
	    myUnparser.setFormatting( true );
	    myUnparser.writeOut( sfnInput, 0 );

	    passout1 = null; // Throw it away, finalizer closes file.
	    sfnInput = null;
	    myUnparser = null;
	}
	else
	{
	}


	myParser = null;

	java.lang.Runtime.getRuntime().gc(); // force garbage collection.
    }
}

