
package EDU.bmrb.starlibj.examples;

import EDU.bmrb.starlibj.*;
import java.io.*;

public class search {

    public search () {

    }

    static public void main(String args[]) {
        StarFileNode sfn = null;
        StarParser      myParser = null;
	StarUnparser    myUnparser = null;
	VectorCheckType searchResult;
	int             i;

	try
	{
	    System.out.println("Test of the starlibj library.");
	    System.out.println("Trying to read passthru.str.");
	    
	    myUnparser = new StarUnparser( System.out );
	    
	    myParser = new StarParser( new java.io.FileInputStream("search.str") );
	    // myParser.setVerbose(true);
	    myParser.StarFileNodeParse(myParser);
	    sfn = (StarFileNode) myParser.popResult();
	    System.out.println("=====Parsing Complete.=====");
	    // searching:

	    System.out.println("Searching for where _s1 = 'match val 1'" );
	    searchResult = sfn.searchByTagValue( "_s1", "match val 1" );
	    for( i = 0 ; i < searchResult.size() ; i++ )
	    {
		StarNode result = (StarNode)( searchResult.elementAt(i) );
		System.out.print(
			"Result " +
			(new Integer(i+1)).toString() +
			" : Line " + result.getLineNum() +
			", Col " +  result.getColNum() +
			" : " + result.getClass().getName() +
			" : " );
		myUnparser.setFormatting( false );
		myUnparser.writeOut( (StarNode) searchResult.elementAt(i), 3 );
		System.out.println();
	    }

	    BlockNode bn = (BlockNode) sfn.elementAt(0);
            setEntryIds(bn, "newID", 0);
	    myUnparser.writeOut( bn, 0 );
	    System.out.println("-----Done with search resuls == " );
	}
	catch( ParseException e)
	{
	    System.out.println("Parse Exception: " + e.getMessage() );
	    e.printStackTrace();
	}
	catch( FileNotFoundException e)
	{
	    System.out.println("File Not found exception opening passthru.str" );
	    e.printStackTrace();
	}
    }

    public static boolean setEntryIds(BlockNode block_node_mrfile, String new_id, int star_version) {
        VectorCheckType vct = null;           
	Class itemClass = null;
	Class loopClass = null;
	try {
	    itemClass = Class.forName(StarValidity.clsNameDataItemNode);
	    loopClass = Class.forName(StarValidity.clsNameDataLoopNode);
	    vct = block_node_mrfile.searchForType(
		Class.forName(StarValidity.clsNameDataNameNode),DataValueNode.DONT_CARE);
	} catch (ClassNotFoundException e) {
	    // TODO Auto-generated catch block
	    e.printStackTrace();
	}
       
	for (int j=0;j<vct.size();j++) {
	    DataNameNode thisName = ((DataNameNode) vct.elementAt(j));
	    if( thisName.getLabel().toLowerCase().endsWith(".entry_id") ) {
		// Find the DataItemNode or DataLoopNode that this hit is inside of:
		StarNode par = null;
		for(   par = thisName ;
		       par != null &&
		         ! itemClass.isInstance( par ) &&
		         ! loopClass.isInstance( par ) ;
		       par = par.getParent()    ) {
		    // do-nothing body
		}
		if( par != null ) {
		    // If it was in a DataItemNode (is a free tag):
		    if( itemClass.isInstance(par) ) {
		        ((DataItemNode)par).setValue( new_id );
		    } else if( loopClass.isInstance(par) ) {
		        DataLoopNode dln = (DataLoopNode)par;
			int colNum = dln.getNames().elementAt(0).indexOf( thisName );
			int row;
			LoopRowNode lrn = null;
			for( row = dln.getVals().size()-1 ; row >= 0 ; --row ) {
			    lrn = dln.getVals().elementAt(row);
			    DataValueNode dvn = lrn.elementAt(colNum);
			    dvn.setValue( new_id );
			    lrn.setElementAt(dvn, colNum );
			}
		    }
		}
	    }
	}       
	return true;
    }
}

