
package EDU.bmrb.starlibj.examples;

import EDU.bmrb.starlibj.*;
import java.io.*;

public class test1 {

    static boolean demonstrate_unparse = true;
    
    public test1 () {

    }

    static public void main( String args[] ) {

	doMain( args );
    }


    static public void doMain(String args[]) {

	StarFileNode             sfnInput = null;
	java.io.FileInputStream  inStream = null;
	StarParser               myParser = null;
	StarUnparser             myUnparser = null;
	System.out.println("Test of the starlibj library.");
	String                   parseFname = args[0];
	java.io.FileOutputStream passout1 = null;
	Class  saveFrameClass = null;
	try {
	    saveFrameClass = Class.forName( StarValidity.pkgName() + 
			                     ".SaveFrameNode" );
	} catch( ClassNotFoundException e ) {
	    System.err.println("exception: can't find class object for save frame node" );
	    e.printStackTrace();
	    return;
	}

	try
	{
	    // read in the starting input file:
	    // --------------------------------
	    inStream =  new java.io.FileInputStream(parseFname);
	    myParser = new StarParser( inStream );
	    passout1 = new java.io.FileOutputStream(parseFname+"-test1out.str");
	}
	catch( FileNotFoundException e)
	{
	    System.out.println("File Not found exception opening passthru.str" );
	    e.printStackTrace();
	}
	catch( java.io.IOException e )
	{
	    System.out.println("IO exception: " + e.getMessage() );
	    e.printStackTrace();
	}
	try {
	    myParser.StarFileNodeParse(myParser);
	}
	catch( ParseException e)
	{
	    System.out.println("Parse Exception: " + e.getMessage() );
	    e.printStackTrace();
	    sfnInput = (StarFileNode) myParser.popResult();
	    myUnparser = new StarUnparser( passout1 );
	    myUnparser.setFormatting( true );
	    myUnparser.writeOut( sfnInput, 0 );
	    return ;
	}

	sfnInput = (StarFileNode) myParser.popResult();

	myUnparser = new StarUnparser( passout1 );
	myUnparser.setFormatting( true );

        // Test the searchForTypeByName method:
	VectorCheckType  searchResult = sfnInput.searchForTypeByName(
	                     saveFrameClass, "_search_for_me" );

        System.out.println( "### Found " +
	                  (new Integer(searchResult.size()) ).toString() +
	                 " hits for the tag." );
        System.out.println( "" );

	int searchIdx = 0;
	for( searchIdx = 0 ; searchIdx < searchResult.size() ; searchIdx++ ) {
	    myUnparser.writeOut( (StarNode) (searchResult.elementAt(searchIdx) ), 0 );
	}


	passout1 = null; // Throw it away, finalizer closes file.
	sfnInput = null;
	myUnparser = null;
	myParser = null;

    }
}

