/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.lib;

import EDU.bmrb.lib.StringPool;
import java.util.ArrayList;

public class PoolTest {
    private static final long NUMSTRINGS = 100000L;
    private static final long NUMUNIQS = 20L;

    public static void doGarbageCollection() {
        long wasfree;
        Runtime rt = Runtime.getRuntime();
        long isfree = rt.freeMemory();
        do {
            wasfree = isfree;
            rt.runFinalization();
            rt.gc();
        } while ((isfree = rt.freeMemory()) > wasfree);
    }

    public static long getMemoryUsed() {
        PoolTest.doGarbageCollection();
        Runtime rt = Runtime.getRuntime();
        long total = rt.totalMemory();
        long free = rt.freeMemory();
        return total - free;
    }

    public String format(long num) {
        String rc = new Long(num).toString();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < 6 - rc.length(); ++i) {
            buf.append("0");
        }
        buf.append(rc);
        return buf.toString();
    }

    public void testStoreInternUniq() {
        System.out.println("Pool with interning, 100000 unique strings");
        StringPool pool = new StringPool();
        long memused = PoolTest.getMemoryUsed();
        System.out.println("Bytes used: " + memused);
        long start = System.currentTimeMillis();
        for (long i = 0L; i < 100000L; ++i) {
            pool.add(this.format(i));
        }
        System.out.println("Elapsed: " + (System.currentTimeMillis() - start));
        long newused = PoolTest.getMemoryUsed();
        System.out.println("Bytes used: " + newused + ", insrease " + (newused - memused));
        System.out.println("Pool size: " + pool.size());
        pool.clear();
        pool = null;
        PoolTest.doGarbageCollection();
        System.out.println();
    }

    public void testStoreNoInternUniq() {
        System.out.println("Pool without interning, 100000 unique strings");
        StringPool pool = new StringPool();
        long memused = PoolTest.getMemoryUsed();
        System.out.println("Bytes used: " + memused);
        long start = System.currentTimeMillis();
        for (long i = 0L; i < 100000L; ++i) {
            pool.addNoIntern(this.format(i));
        }
        System.out.println("Elapsed: " + (System.currentTimeMillis() - start));
        long newused = PoolTest.getMemoryUsed();
        System.out.println("Bytes used: " + newused + ", insrease " + (newused - memused));
        System.out.println("Pool size: " + pool.size());
        pool.clear();
        pool = null;
        PoolTest.doGarbageCollection();
        System.out.println();
    }

    public void testStoreInternNonUniq() {
        System.out.println("Pool with interning, 100000 strings,20 unique");
        StringPool pool = new StringPool();
        long memused = PoolTest.getMemoryUsed();
        System.out.println("Bytes used: " + memused);
        long start = System.currentTimeMillis();
        for (long i = 0L; i < 5000L; ++i) {
            for (long j = 0L; j < 20L; ++j) {
                pool.add(this.format(j));
            }
        }
        System.out.println("Elapsed: " + (System.currentTimeMillis() - start));
        long newused = PoolTest.getMemoryUsed();
        System.out.println("Bytes used: " + newused + ", insrease " + (newused - memused));
        System.out.println("Pool size: " + pool.size());
        pool.clear();
        pool = null;
        PoolTest.doGarbageCollection();
        System.out.println();
    }

    public void testStoreNoInternNonUniq() {
        System.out.println("Pool without interning, 100000 strings,20 unique");
        StringPool pool = new StringPool();
        long memused = PoolTest.getMemoryUsed();
        System.out.println("Bytes used: " + memused);
        long start = System.currentTimeMillis();
        for (long i = 0L; i < 5000L; ++i) {
            for (long j = 0L; j < 20L; ++j) {
                pool.addNoIntern(this.format(j));
            }
        }
        System.out.println("Elapsed: " + (System.currentTimeMillis() - start));
        long newused = PoolTest.getMemoryUsed();
        System.out.println("Bytes used: " + newused + ", insrease " + (newused - memused));
        System.out.println("Pool size: " + pool.size());
        pool.clear();
        pool = null;
        PoolTest.doGarbageCollection();
        System.out.println();
    }

    public void testArrayInternUniq() {
        System.out.println("List with interning, 100000 unique strings");
        ArrayList<String> pool = new ArrayList<String>();
        long memused = PoolTest.getMemoryUsed();
        System.out.println("Bytes used: " + memused);
        long start = System.currentTimeMillis();
        for (long i = 0L; i < 100000L; ++i) {
            pool.add(this.format(i).intern());
        }
        System.out.println("Elapsed: " + (System.currentTimeMillis() - start));
        long newused = PoolTest.getMemoryUsed();
        System.out.println("Bytes used: " + newused + ", insrease " + (newused - memused));
        System.out.println("Pool size: " + pool.size());
        pool.clear();
        pool = null;
        PoolTest.doGarbageCollection();
        System.out.println();
    }

    public void testArrayNoInternUniq() {
        System.out.println("List without interning, 100000 unique strings");
        ArrayList<String> pool = new ArrayList<String>();
        long memused = PoolTest.getMemoryUsed();
        System.out.println("Bytes used: " + memused);
        long start = System.currentTimeMillis();
        for (long i = 0L; i < 100000L; ++i) {
            pool.add(this.format(i));
        }
        System.out.println("Elapsed: " + (System.currentTimeMillis() - start));
        long newused = PoolTest.getMemoryUsed();
        System.out.println("Bytes used: " + newused + ", insrease " + (newused - memused));
        System.out.println("Pool size: " + pool.size());
        pool.clear();
        pool = null;
        PoolTest.doGarbageCollection();
        System.out.println();
    }

    public void testArrayInternNonUniq() {
        System.out.println("List with interning, 100000 strings,20 unique");
        ArrayList<String> pool = new ArrayList<String>();
        long memused = PoolTest.getMemoryUsed();
        System.out.println("Bytes used: " + memused);
        long start = System.currentTimeMillis();
        for (long i = 0L; i < 5000L; ++i) {
            for (long j = 0L; j < 20L; ++j) {
                pool.add(this.format(j).intern());
            }
        }
        System.out.println("Elapsed: " + (System.currentTimeMillis() - start));
        long newused = PoolTest.getMemoryUsed();
        System.out.println("Bytes used: " + newused + ", insrease " + (newused - memused));
        System.out.println("Pool size: " + pool.size());
        pool.clear();
        pool = null;
        PoolTest.doGarbageCollection();
        System.out.println();
    }

    public void testArrayNoInternNonUniq() {
        System.out.println("List without interning, 100000 strings,20 unique");
        ArrayList<String> pool = new ArrayList<String>();
        long memused = PoolTest.getMemoryUsed();
        System.out.println("Bytes used: " + memused);
        long start = System.currentTimeMillis();
        for (long i = 0L; i < 5000L; ++i) {
            for (long j = 0L; j < 20L; ++j) {
                pool.add(this.format(j));
            }
        }
        System.out.println("Elapsed: " + (System.currentTimeMillis() - start));
        long newused = PoolTest.getMemoryUsed();
        System.out.println("Bytes used: " + newused + ", insrease " + (newused - memused));
        System.out.println("Pool size: " + pool.size());
        pool.clear();
        pool = null;
        PoolTest.doGarbageCollection();
        System.out.println();
    }
}

