/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.lib;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;

public class StrPool
implements Cloneable,
Serializable {
    private static final boolean DEBUG = true;
    protected String[] fData = null;

    public StrPool() {
    }

    public StrPool(StrPool strPool) {
        if (strPool.size() > 0) {
            this.fData = new String[strPool.size()];
            System.arraycopy(strPool.fData, 0, this.fData, 0, this.fData.length);
        }
    }

    public int size() {
        if (this.fData == null) {
            return 0;
        }
        return this.fData.length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(String string) {
        return this.indexOf(string) >= 0;
    }

    public int indexOf(String string) {
        return Arrays.binarySearch(this.fData, string);
    }

    public Object clone() {
        return new StrPool(this);
    }

    public String[] toArray() {
        String[] stringArray = new String[this.fData.length];
        System.arraycopy(this.fData, 0, stringArray, 0, this.fData.length);
        return stringArray;
    }

    public String add(String string) {
        if (string == null) {
            return null;
        }
        if (this.fData == null) {
            this.fData = new String[1];
            this.fData[0] = string.intern();
            return this.fData[0];
        }
        int n = Arrays.binarySearch(this.fData, string);
        System.err.println("search for " + string + " returns " + n);
        if (n >= 0) {
            return this.fData[n];
        }
        n = Math.abs(n) - 1;
        System.err.println("insert " + string + " at " + n + ", data size = " + this.fData.length);
        String[] stringArray = new String[this.fData.length + 1];
        System.arraycopy(this.fData, 0, stringArray, 0, n);
        stringArray[n] = string.intern();
        System.arraycopy(this.fData, n, stringArray, n + 1, this.fData.length - n);
        this.fData = stringArray;
        return this.fData[n];
    }

    public String get(int n) {
        if (n < 0 || n >= this.fData.length) {
            throw new IndexOutOfBoundsException("Invalid index: " + n);
        }
        return this.fData[n];
    }

    public void clear() {
        for (int i = 0; i < this.fData.length; ++i) {
            this.fData[i] = null;
        }
        this.fData = null;
    }

    public void print(PrintStream printStream) {
        printStream.print("Pool size = ");
        printStream.println(this.size());
        if (this.size() > 0) {
            for (int i = 0; i < this.fData.length; ++i) {
                printStream.print(i);
                printStream.print(": ");
                printStream.println(this.fData[i]);
            }
        }
        printStream.flush();
    }

    public static void main(String[] stringArray) {
        StrPool strPool = new StrPool();
        strPool.print(System.err);
        strPool.add("c");
        strPool.print(System.err);
        strPool.add("b");
        strPool.print(System.err);
        strPool.add("e");
        strPool.print(System.err);
        strPool.add("d");
        strPool.print(System.err);
        strPool.add("a");
        strPool.print(System.err);
    }
}

