/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.nmrstar.dictionary;

import EDU.bmrb.csv.CSVLexer;
import EDU.bmrb.csv.Yytoken;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class AddChemShifts {
    public static final String AAFILE = "/share/dmaziuk/dictionary/aastatsl.lst";
    public static final String AA = "polypeptide";
    public static final String DNAFILE = "/share/dmaziuk/dictionary/dnastatsl.lst";
    public static final String DNA = "polydeoxyribonucleotide";
    public static final String RNAFILE = "/share/dmaziuk/dictionary/rnastatsl.lst";
    public static final String RNA = "polyribonucleotide";

    private static void load(Connection connection, String string, String string2) throws SQLException, IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
        CSVLexer cSVLexer = new CSVLexer((Reader)bufferedReader);
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO CHEMSHIFTS (RESTYPE,RESIDUE,ATOM,SHIFTAVG,SHIFTSTD) VALUES ('" + string2 + "',?,?,?,?)");
        String string3 = null;
        String string4 = null;
        float f = Float.NaN;
        float f2 = Float.NaN;
        int n = 0;
        Yytoken yytoken = cSVLexer.yylex();
        while (yytoken != null) {
            System.err.println("token: " + yytoken.getText() + ", col " + n);
            if (yytoken.getType() == 1) {
                System.err.println("EOR");
                if (!Float.isNaN(f) && !Float.isNaN(f2)) {
                    preparedStatement.setString(1, string3);
                    preparedStatement.setString(2, string4);
                    preparedStatement.setFloat(3, f);
                    preparedStatement.setFloat(4, f2);
                    preparedStatement.executeUpdate();
                }
                n = -1;
            }
            switch (n) {
                case 1: {
                    string3 = yytoken.getText();
                    break;
                }
                case 2: {
                    string4 = yytoken.getText();
                    break;
                }
                case 6: {
                    try {
                        f = Float.parseFloat(yytoken.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        f = Float.NaN;
                    }
                    break;
                }
                case 7: {
                    try {
                        f2 = Float.parseFloat(yytoken.getText());
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        f2 = Float.NaN;
                    }
                }
            }
            yytoken = cSVLexer.yylex();
            ++n;
        }
        bufferedReader.close();
        connection.commit();
        preparedStatement.close();
    }

    public static void load(Connection connection) throws SQLException, IOException {
        AddChemShifts.load(connection, AAFILE, AA);
        AddChemShifts.load(connection, DNAFILE, DNA);
        AddChemShifts.load(connection, RNAFILE, RNA);
    }

    public static void main(String[] stringArray) {
    }
}

