/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.nmrstar.dictionary;

import EDU.bmrb.lib.DBMgr;
import EDU.bmrb.sansj.ContentHandler;
import EDU.bmrb.sansj.DataItemNode;
import EDU.bmrb.sansj.ErrorHandler;
import EDU.bmrb.sansj.STARLexer;
import EDU.bmrb.sansj.SansParser;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;

public class AddEnumerations
implements ContentHandler,
ErrorHandler {
    private static final boolean DEBUG = true;
    private static final String DEF_PROPFILE = "validator.properties";
    private DBMgr fMgr = null;
    private Statement fStat = null;
    private PreparedStatement fQuery = null;
    private PreparedStatement fValQuery = null;
    private PreparedStatement fUpdate = null;
    private PreparedStatement fReplace = null;
    private ResultSet fRs = null;

    public AddEnumerations(Properties props) {
        this.fMgr = new DBMgr(props);
    }

    public AddEnumerations(DBMgr mgr) {
        if (mgr == null) {
            throw new NullPointerException("Parameter missing");
        }
        this.fMgr = mgr;
    }

    public void addEnumerations(String infile) {
        try {
            if (!this.fMgr.isConnected()) {
                this.fMgr.connect(false);
            }
            BufferedReader in = infile == null || infile.equals("-") ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new InputStreamReader(new FileInputStream(infile)));
            STARLexer lex = new STARLexer(in);
            SansParser p = new SansParser(lex, this, this);
            p.parse();
            in.close();
            this.fMgr.close();
        }
        catch (Exception e) {
            System.err.println("Cannot add enumerations");
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    public void error(int param, int param1, String str) {
        System.err.print("Parse error in line ");
        System.err.print(param);
        System.err.print(", column ");
        System.err.print(param1);
        System.err.print(": ");
        System.err.println(str);
    }

    public boolean warning(int param, int param1, String str) {
        System.err.print("Parse warning in line ");
        System.err.print(param);
        System.err.print(", column ");
        System.err.print(param1);
        System.err.print(": ");
        System.err.println(str);
        return false;
    }

    public boolean comment(int param, String str) {
        return false;
    }

    public boolean startData(int param, String str) {
        try {
            if (!this.fMgr.isConnected()) {
                this.fMgr.connect(false);
            }
            this.fStat = this.fMgr.getStatement();
            this.fQuery = this.fMgr.getConnection().prepareStatement("SELECT SEQ FROM TAGS WHERE TAGNAME=?");
            this.fValQuery = this.fMgr.getConnection().prepareStatement("SELECT VAL FROM VALENUMS WHERE SEQ=? AND VAL=?");
            this.fUpdate = this.fMgr.getConnection().prepareStatement("INSERT INTO VALENUMS (SEQ,VAL) VALUES (?,?)");
            this.fReplace = this.fMgr.getConnection().prepareStatement("UPDATE VALENUMS SET VAL=? WHERE SEQ=? AND VAL=?");
            return false;
        }
        catch (Exception e) {
            System.err.println("Exception in startData()");
            System.err.println(e.getMessage());
            e.printStackTrace();
            return true;
        }
    }

    public void endData(int param, String str) {
        try {
            this.fStat.executeUpdate("COMMIT");
            this.fStat.close();
            this.fQuery.close();
            this.fValQuery.close();
            this.fUpdate.close();
            this.fReplace.close();
        }
        catch (Exception e) {
            System.err.println("Exception in endData()");
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean startSaveFrame(int param, String str) {
        return false;
    }

    public boolean endSaveFrame(int param, String str) {
        return false;
    }

    public boolean startLoop(int param) {
        return false;
    }

    public boolean endLoop(int param) {
        try {
            this.fStat.executeUpdate("COMMIT");
        }
        catch (Exception e) {
            System.err.println("Exception in endLoop()");
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        return false;
    }

    public boolean data(DataItemNode node) {
        try {
            this.fQuery.setString(1, node.getName());
            this.fRs = this.fQuery.executeQuery();
            System.err.println(this.fQuery);
            System.err.println(node.getName() + ":" + node.getValue());
            if (!this.fRs.next()) {
                System.err.print("Tag not in dictionary: ");
                System.err.println(node.getName());
                System.err.println(" *** dump tags table");
                Statement q = this.fMgr.getStatement();
                this.fRs = q.executeQuery("SELECT TAGNAME FROM TAGS");
                while (this.fRs.next()) {
                    System.err.println(this.fRs.getString(1));
                }
                q.close();
                return false;
            }
            int seq = this.fRs.getInt(1);
            this.fValQuery.setInt(1, seq);
            this.fValQuery.setString(2, node.getValue());
            this.fRs = this.fValQuery.executeQuery();
            if (this.fRs.next()) {
                this.fReplace.setString(1, node.getValue());
                this.fReplace.setInt(2, seq);
                this.fReplace.setString(3, this.fRs.getString(1));
                this.fReplace.executeUpdate();
            } else {
                this.fUpdate.setInt(1, seq);
                this.fUpdate.setString(2, node.getValue());
                this.fUpdate.executeUpdate();
            }
        }
        catch (Exception e) {
            System.err.println("Exception in data()");
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        return false;
    }

    public static void usage() {
        System.out.print("Usage: java EDU.bmrb.nmrstar.dictionary.AddEnumerations [-h]");
        System.out.println(" [-c FILE] [-i FILE]");
        System.out.println("  -h: print this usage summary");
        System.out.print("  -c FILE: use configuration FILE (default: ");
        System.out.print(System.getProperty("user.home"));
        System.out.print(File.separatorChar);
        System.out.print(DEF_PROPFILE);
        System.out.println(')');
        System.out.println("  -i FILE: input FILE (default: stdin)");
    }

    public static void main(String[] args) {
        int opt;
        Getopt g = new Getopt("EDU.bmrb.nmrstar.dictionary.AddComments", args, "hc:i:");
        String conffile = null;
        String infile = null;
        block6: while ((opt = g.getopt()) != -1) {
            switch (opt) {
                case 99: {
                    conffile = g.getOptarg();
                    continue block6;
                }
                case 105: {
                    infile = g.getOptarg();
                    continue block6;
                }
            }
            AddEnumerations.usage();
            return;
        }
        if (conffile == null) {
            StringBuffer buf = new StringBuffer(System.getProperty("user.home"));
            buf.append(File.separatorChar);
            buf.append(DEF_PROPFILE);
            conffile = buf.toString();
        }
        try {
            EDU.bmrb.lib.Properties props = new EDU.bmrb.lib.Properties(conffile);
            AddEnumerations add = new AddEnumerations(props.getProperties());
            add.addEnumerations(infile);
        }
        catch (Exception e) {
            System.err.println("Exception in main()");
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
        }
    }
}

