/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.nmrstar.dictionary;

import EDU.bmrb.lib.CreateDBSchema;
import EDU.bmrb.lib.ErrorList;
import EDU.bmrb.nmrstar.utils.StarToDb;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class FromSTAR {
    public static final String DEF_PROPFILE = "validator.properties";
    public static final String DB_DRIVER = "DB.Driver";
    public static final String DB_URL = "DB.Url";
    public static final String DB_USER = "DB.User";
    public static final String DB_PASS = "DB.Password";
    public static final String SCHEMA_SCRIPT = "Dictionary.schema";
    public static final String CONSTR_SCRIPT = "Dictionary.constraints";

    public static void load(BufferedReader bufferedReader, Connection connection, String string, String string2, PrintWriter printWriter, ErrorList errorList) throws SQLException, IOException {
        if (string != null) {
            CreateDBSchema.runScript(connection, string, printWriter);
        }
        StarToDb starToDb = new StarToDb(connection, printWriter, errorList);
        starToDb.load(bufferedReader);
        if (string2 != null) {
            CreateDBSchema.runScript(connection, string2, printWriter);
        }
    }

    public static void usage() {
        System.out.print("Usage: java EDU.bmrb.nmrstar.dictionary.FromSTAR [-h]");
        System.out.println(" [-c FILE] [-i FILE] [-s]");
        System.out.println("  -h: print this usage summary");
        System.out.print("  -c FILE: use configuration FILE (default: ");
        System.out.print(System.getProperty("user.home"));
        System.out.print(File.separatorChar);
        System.out.print(DEF_PROPFILE);
        System.out.println(')');
        System.out.println("  -i FILE: input FILE (default: stdin)");
        System.out.println("  -s: do not create schema, load data into existing tables");
    }

    public static void main(String[] stringArray) {
        Serializable serializable;
        int n;
        Getopt getopt = new Getopt("EDU.bmrb.nmrstar.dictionary.FromSTAR", stringArray, "hsc:i:o:");
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = true;
        block8: while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 99: {
                    string = getopt.getOptarg();
                    continue block8;
                }
                case 105: {
                    string2 = getopt.getOptarg();
                    continue block8;
                }
                case 111: {
                    string3 = getopt.getOptarg();
                    continue block8;
                }
                case 115: {
                    bl = false;
                    continue block8;
                }
            }
            FromSTAR.usage();
            return;
        }
        if (string == null) {
            serializable = new StringBuffer(System.getProperty("user.home"));
            ((StringBuffer)serializable).append(File.separatorChar);
            ((StringBuffer)serializable).append(DEF_PROPFILE);
            string = ((StringBuffer)serializable).toString();
        }
        try {
            String string4;
            serializable = new Properties();
            FileInputStream fileInputStream = new FileInputStream(string);
            ((Properties)serializable).load(fileInputStream);
            fileInputStream.close();
            String string5 = null;
            if (bl) {
                string5 = ((Properties)serializable).getProperty(SCHEMA_SCRIPT);
            }
            String string6 = null;
            if (bl) {
                string6 = ((Properties)serializable).getProperty(CONSTR_SCRIPT);
            }
            PrintWriter printWriter = null;
            if (string3 != null) {
                printWriter = string3.equals("-") ? new PrintWriter(System.out) : new PrintWriter(new FileOutputStream(string3));
            }
            if ((string4 = ((Properties)serializable).getProperty(DB_DRIVER)) == null) {
                throw new NullPointerException("Missing DB Driver");
            }
            Class.forName(string4);
            string4 = ((Properties)serializable).getProperty(DB_URL);
            if (string4 == null) {
                throw new NullPointerException("Missing DB URL");
            }
            Connection connection = DriverManager.getConnection(string4, ((Properties)serializable).getProperty(DB_USER), ((Properties)serializable).getProperty(DB_PASS));
            BufferedReader bufferedReader = string2 == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(string2));
            FromSTAR.load(bufferedReader, connection, string5, string6, printWriter, null);
            bufferedReader.close();
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
            connection.close();
            if (printWriter != null) {
                printWriter.flush();
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
            exception.printStackTrace();
            return;
        }
    }
}

