/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.nmrstar.dictionary;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Properties;

public class Props {
    public static final String PROGNAME = "NMR-STAR dictionary";
    public static final String DEF_PROPFILE = "dictionary.properties";
    public static final String DB_DRIVER = "DB.Driver";
    public static final String DB_URL = "DB.Url";
    public static final String DB_USER = "DB.User";
    public static final String DB_PASS = "DB.Password";
    public static final String SCHEMA_SCRIPT = "Schema.pretables";
    public static final String PROPVAL_DBINT = "integer";
    public static final String PROPVAL_DBSTRING = "string";
    public static final int INTEGER = 0;
    public static final int STRING = 1;
    private Properties fProps = new Properties();
    private String fPropFile = null;

    public Properties getProperties() {
        return this.fProps;
    }

    public String getPropFile() {
        if (this.fPropFile == null) {
            return DEF_PROPFILE;
        }
        return this.fPropFile;
    }

    public void setPropFile(String string) {
        this.fPropFile = string;
    }

    public boolean load() {
        if (this.fPropFile == null) {
            return this.load(System.getProperty("user.home") + File.separatorChar + DEF_PROPFILE);
        }
        return this.load(this.fPropFile);
    }

    public boolean load(String string) {
        try {
            this.fPropFile = string;
            FileInputStream fileInputStream = new FileInputStream(string);
            this.fProps.load(fileInputStream);
            return true;
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
            exception.printStackTrace();
            return false;
        }
    }

    public boolean store() {
        if (this.fPropFile == null) {
            return this.store(DEF_PROPFILE);
        }
        return this.store(this.fPropFile);
    }

    public boolean store(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            this.fProps.store(fileOutputStream, PROGNAME);
            return true;
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
            exception.printStackTrace();
            return false;
        }
    }

    public void put(String string, String string2) {
        this.fProps.setProperty(string, string2);
    }

    public String get(String string) {
        return this.fProps.getProperty(string);
    }

    public void list(PrintStream printStream) {
        this.fProps.list(printStream);
    }

    public void list(PrintWriter printWriter) {
        this.fProps.list(printWriter);
    }

    public static void main(String[] stringArray) {
        Props props = new Props();
        if (stringArray.length > 0) {
            props.setPropFile(stringArray[0]);
        }
        props.load();
        props.list(System.out);
    }
}

