/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.nmrstar.dictionary;

import EDU.bmrb.nmrstar.dictionary.DBMgr;
import EDU.bmrb.nmrstar.utils.DbToStar;
import gnu.getopt.Getopt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Properties;

public class ToSTAR {
    public static final int TABWIDTH = 4;
    private static final String[] ALL_TABLES = new String[]{"DBNAMES", "DICT", "SFMANENUM", "SFCATS", "TAGMANENUM", "VALTYPENUM", "TAGS", "TAGDEPS", "TAGRELS", "VALENUMS"};
    private DBMgr fMgr = null;
    private String[] fTables = null;

    public static void usage() {
        System.out.print("Usage: java EDU.bmrb.nmrstar.dictionary.ToSTAR [-h]");
        System.out.println(" [-c FILE] [-o FILE] [-t NAME] ...");
        System.out.println("  -h: print this usage summary");
        System.out.print("  -c FILE: use configuration FILE (default: ");
        System.out.println(System.getProperty("user.home") + File.separatorChar + "validator.properties");
        System.out.println("  -o FILE: output FILE (default: stdout)");
        System.out.print("  -t TABLE: dump table NAME (default: all tables).");
        System.out.println("Multiple -t options are supported.");
    }

    public static void main(String[] args) {
        int opt;
        Getopt g = new Getopt("EDU.bmrb.nmrstar.dictionary.ToSTAR", args, "hc:o:t:");
        String conffile = null;
        String outfile = null;
        ArrayList<String> tables = null;
        block8: while ((opt = g.getopt()) != -1) {
            switch (opt) {
                case 104: {
                    ToSTAR.usage();
                    return;
                }
                case 99: {
                    conffile = g.getOptarg();
                    continue block8;
                }
                case 111: {
                    outfile = g.getOptarg();
                    continue block8;
                }
                case 116: {
                    if (tables == null) {
                        tables = new ArrayList<String>();
                    }
                    tables.add(g.getOptarg());
                    continue block8;
                }
            }
            ToSTAR.usage();
            return;
        }
        if (conffile == null) {
            conffile = System.getProperty("user.home") + File.separatorChar + "dictionary.properties";
        }
        try {
            Properties props = new Properties();
            FileInputStream in = new FileInputStream(conffile);
            props.load(in);
            in.close();
            in = null;
            String str = props.getProperty("DB.Driver");
            if (str == null) {
                throw new NullPointerException("Missing DB driver");
            }
            Class.forName(str);
            str = props.getProperty("DB.Url");
            if (str == null) {
                throw new NullPointerException("Missing DB URL");
            }
            Connection conn = DriverManager.getConnection(str, props.getProperty("DB.User"), props.getProperty("DB.Password"));
            PrintWriter out = null;
            out = outfile == null || outfile.equals("-") ? new PrintWriter(System.out) : new PrintWriter(new FileOutputStream(outfile));
            DbToStar o = new DbToStar(conn, out, null);
            o.print(tables);
            if (tables != null) {
                tables.clear();
            }
            out.flush();
            conn.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            return;
        }
    }
}

