/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.nmrstar.dictionary;

import EDU.bmrb.lib.CreateDBSchema;
import EDU.bmrb.lib.DBMgr;
import EDU.bmrb.lib.Properties;
import EDU.bmrb.nmrstar.dictionary.AddEnumerations;
import EDU.bmrb.nmrstar.utils.QuoteString;
import gnu.getopt.Getopt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class ValidatorDB {
    public static final String FULL_PROPFILE = "loader.properties";
    public static final String VAL_PROPFILE = "validator.properties";
    public static final String SCHEMA_SCRIPT = "Schema.pretables";
    public static String PROPKEY_VERSION = "Dictionary.version";
    public static String LABELTAG_SUFFIX = "_label";
    public static String IDTAG_SUFFIX = "_ID";
    private Properties fDictProps = null;
    private Properties fValProps = null;
    private Connection fDictConn = null;
    private Connection fValConn = null;
    private int fMode = 0;

    public ValidatorDB(String propdir, int mode) throws IOException {
        String path = null;
        if (propdir != null && propdir.length() > 0) {
            path = propdir.charAt(propdir.length() - 1) != File.separatorChar ? propdir + File.separatorChar : propdir;
        }
        this.fDictProps = new Properties(path + FULL_PROPFILE);
        this.fValProps = new Properties(path + VAL_PROPFILE);
        this.fMode = mode;
    }

    public boolean loadModeTables(PrintWriter out) {
        try {
            Statement stat = this.fValConn != null ? this.fValConn.createStatement() : null;
            StringBuffer sql = new StringBuffer("DELETE FROM DICT");
            if (out != null) {
                out.println(sql);
            }
            if (stat != null) {
                stat.executeUpdate(sql.toString());
            }
            String str = null;
            if (this.fDictConn != null) {
                Statement query = this.fDictConn.createStatement();
                ResultSet rs = query.executeQuery("SELECT DEFAULTVALUE FROM DICT WHERE ORIGINALTAG='_Entry.NMR_STAR_version'");
                if (rs.next()) {
                    str = rs.getString(1);
                    if (rs.wasNull()) {
                        str = null;
                    }
                }
                rs.close();
                query.close();
            }
            sql.setLength(0);
            sql.append("INSERT INTO DICT (DMODE,VERSION,DICTFLAG) VALUES (");
            sql.append(this.fMode);
            sql.append(",'");
            sql.append(str);
            sql.append("','Y')");
            if (out != null) {
                out.println(sql);
            }
            if (stat != null) {
                stat.executeUpdate(sql.toString());
                stat.getConnection().commit();
            }
            if (stat != null) {
                stat.close();
            }
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean loadSFCategories(PrintWriter out) {
        Statement srcstat = null;
        Statement dststat = null;
        StringBuffer sql = new StringBuffer();
        try {
            if (this.fValConn != null) {
                dststat = this.fValConn.createStatement();
            }
            srcstat = this.fDictConn.createStatement(1004, 1007);
            ResultSet rs = srcstat.executeQuery("SELECT GROUPID,SFCATEGORY,VALIDATEFLGS,ADITREPLICABLE FROM ADITCATGRP");
            sql.setLength(0);
            while (rs.next()) {
                char flag = rs.getString(3).toUpperCase().charAt(this.fMode);
                sql.append("INSERT INTO SFCATS (ID, SFCAT, UNIQ, MANDATORY) VALUES (");
                sql.append(rs.getString(1));
                sql.append(", '");
                sql.append(rs.getString(2));
                sql.append("', '");
                String str = rs.getString(4).toUpperCase();
                if (rs.wasNull()) {
                    sql.append("N");
                } else if (str.charAt(0) == 'Y') {
                    sql.append("N");
                } else {
                    sql.append("Y");
                }
                sql.append("', '");
                sql.append(flag);
                sql.append("')");
                if (out != null) {
                    out.println(sql + ";");
                }
                if (dststat != null) {
                    dststat.executeUpdate(sql.toString());
                }
                sql.setLength(0);
            }
            srcstat.close();
            if (this.fValConn != null && !this.fValConn.getAutoCommit()) {
                this.fValConn.commit();
            }
            if (dststat != null) {
                dststat.close();
            }
            if (out != null) {
                out.flush();
            }
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean loadTags_ps(PrintWriter out) {
        try {
            if (this.fValConn == null) {
                System.err.println("No target database");
                return false;
            }
            PreparedStatement pstat = this.fValConn.prepareStatement("INSERT INTO TAGS (SEQ,SFCAT,TAGNAME,VALTYPE,VALSIZE,MANDATORY,ENUMCLOSEDFLAG,ROWIDXFLAG,SFIDFLAG,SFLABELFLAG,SFCATFLAG,LOOPFLAG,LOOPMANDATORY,ADITDEFAULT,ADITAUTO,DATUMCOUNT,LOCALIDFLAG,SFLINKFLAG,ENTRYIDFLAG,METADATA,DELETEFLAG) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            Statement query = this.fDictConn.createStatement(1004, 1007);
            ResultSet rs = query.executeQuery("SELECT DICTIONARYSEQ,ORIGINALCATEGORY,ORIGINALTAG,DBTYPE,FRAMECODEVALUEFLG,VALIDATEFLGS,ITEMENUMCLOSEDFLG,ROWINDEXFLG,SFIDFLG,SFLABELFLG,SFCATEGORYFLG,LOOPFLAG,DBNULLABLE,DEFAULTVALUE,ADITAUTOINSERT,DATUMCOUNTFLGS,LCLIDFLG,ADITEXISTS,METADATAFLGS,TAGDELETEFLGS FROM DICT");
            while (rs.next()) {
                int autoinsert;
                pstat.setInt(1, rs.getInt(1));
                pstat.setString(2, rs.getString(2));
                pstat.setString(3, rs.getString(3));
                String size = null;
                String type = null;
                boolean framecode = false;
                String str = rs.getString(4).toUpperCase();
                if (str.indexOf("CHAR") >= 0) {
                    type = "STRING";
                    int pos = str.indexOf(40);
                    if (pos > -1) {
                        size = str.substring(pos + 1, str.indexOf(41));
                    }
                } else if (str.indexOf("TEXT") >= 0) {
                    type = "STRING";
                } else if (str.indexOf("INTEGER") >= 0) {
                    type = "INTEGER";
                } else if (str.indexOf("FLOAT") >= 0) {
                    type = "FLOAT";
                } else if (str.indexOf("DATE") >= 0) {
                    type = "DATE";
                }
                if (rs.getString(5).toUpperCase().equals("Y")) {
                    type = "FRAMECODE";
                    framecode = true;
                }
                if (type != null) {
                    pstat.setString(4, type);
                }
                if (size != null) {
                    pstat.setInt(5, Integer.parseInt(size));
                } else {
                    pstat.setNull(5, 4);
                }
                boolean optionaltag = false;
                str = rs.getString(6);
                if (str == null || str.trim().length() < 1) {
                    System.err.println("No validation flag for tag # " + rs.getInt(1));
                    return false;
                }
                pstat.setString(6, str.toUpperCase().substring(this.fMode, this.fMode + 1));
                if (str.toUpperCase().charAt(this.fMode) == 'O') {
                    optionaltag = true;
                }
                str = rs.getString(7);
                if (!rs.wasNull() && str.toUpperCase().charAt(0) == 'Y') {
                    pstat.setString(7, "Y");
                } else {
                    pstat.setString(7, "N");
                }
                boolean rowindex = false;
                str = rs.getString(8);
                if (!rs.wasNull() && str.toUpperCase().charAt(0) == 'Y') {
                    pstat.setString(8, "Y");
                    rowindex = true;
                } else {
                    pstat.setString(8, "N");
                }
                boolean sfid = false;
                str = rs.getString(9);
                if (!rs.wasNull() && str.toUpperCase().charAt(0) == 'Y') {
                    pstat.setString(9, "Y");
                    sfid = true;
                } else {
                    pstat.setString(9, "N");
                }
                boolean sflabel = false;
                str = rs.getString(10);
                if (!rs.wasNull() && str.toUpperCase().charAt(0) == 'Y') {
                    pstat.setString(10, "Y");
                    sflabel = true;
                } else {
                    pstat.setString(10, "N");
                }
                boolean sfcat = false;
                str = rs.getString(11);
                if (!rs.wasNull() && str.toUpperCase().charAt(0) == 'Y') {
                    pstat.setString(11, "Y");
                    sfcat = true;
                } else {
                    pstat.setString(11, "N");
                }
                boolean looptag = false;
                str = rs.getString(12);
                if (!rs.wasNull() && str.toUpperCase().charAt(0) == 'Y') {
                    pstat.setString(12, "Y");
                    looptag = true;
                } else {
                    pstat.setString(12, "N");
                }
                str = rs.getString(13);
                if (rs.wasNull()) {
                    pstat.setString(13, "N");
                } else if (str.toUpperCase().equals("NOT NULL") && looptag && optionaltag) {
                    pstat.setString(13, "Y");
                }
                str = rs.getString(14);
                if (rs.wasNull()) {
                    str = null;
                }
                if (rs.getString(3).indexOf(".Entry_ID") >= 0) {
                    pstat.setString(14, "NEED_ACC_NUM");
                } else if (str == null || str.equals("?")) {
                    pstat.setNull(14, 12);
                } else {
                    pstat.setString(14, str);
                }
                rs.getString(15);
                if (rs.wasNull()) {
                    autoinsert = 0;
                } else {
                    try {
                        autoinsert = Integer.parseInt(rs.getString(15).trim());
                    }
                    catch (NumberFormatException e) {
                        System.err.println("For tag # " + rs.getString(1));
                        System.err.println(e);
                        e.printStackTrace();
                        autoinsert = 0;
                    }
                }
                if (autoinsert > 0) {
                    pstat.setString(15, "Y");
                } else {
                    pstat.setString(15, "N");
                }
                pstat.setString(17, "N");
                pstat.setString(18, "N");
                pstat.setString(19, "N");
                switch (autoinsert) {
                    case 1: {
                        pstat.setString(11, "Y");
                        if (sfcat) break;
                        System.err.println(rs.getString(1) + "," + rs.getString(2) + "," + rs.getString(3) + ",sfCategoryFlg,N,aditAutoInsert,1,(sfCategoryFlg should be Y or autoinsert should not be 1)");
                        break;
                    }
                    case 2: {
                        pstat.setString(10, "Y");
                        if (sflabel) break;
                        System.err.println(rs.getString(1) + "," + rs.getString(2) + "," + rs.getString(3) + ",sfLabelFlg,N,aditAutoInsert,2,(sfLabelFlg should be Y or autoinsert should not be 2)");
                        break;
                    }
                    case 3: {
                        pstat.setString(19, "Y");
                        break;
                    }
                    case 4: {
                        pstat.setString(9, "Y");
                        if (sfid) break;
                        System.err.println(rs.getString(1) + "," + rs.getString(2) + "," + rs.getString(3) + ",sfIdFlg,N,aditAutoInsert,4,(sfIdFlg should be Y or autoinsert should not be 4)");
                        break;
                    }
                    case 5: {
                        pstat.setString(17, "Y");
                        break;
                    }
                    case 6: {
                        pstat.setString(8, "Y");
                        if (rowindex) break;
                        System.err.println(rs.getString(1) + "," + rs.getString(2) + "," + rs.getString(3) + ",rowIndexFlg,N,aditAutoInsert,6,(rowIndexFlg should be Y or autoinsert should not be 6)");
                        break;
                    }
                    case 7: {
                        pstat.setString(18, "Y");
                    }
                }
                str = rs.getString(16);
                if (!rs.wasNull() && str.toUpperCase().charAt(0) == 'Y') {
                    pstat.setString(16, "Y");
                } else {
                    pstat.setString(16, "N");
                }
                str = rs.getString(19);
                if (!rs.wasNull() && str.toUpperCase().charAt(0) == 'Y') {
                    pstat.setString(20, "Y");
                } else {
                    pstat.setString(20, "N");
                }
                str = rs.getString(20);
                if (!rs.wasNull() && str.toUpperCase().charAt(0) == 'Y') {
                    pstat.setString(21, "Y");
                } else {
                    pstat.setString(21, "N");
                }
                if (out != null) {
                    out.println(pstat);
                }
                pstat.executeUpdate();
                if (sfcat && autoinsert != 1) {
                    System.err.println(rs.getString(1) + "," + rs.getString(2) + "," + rs.getString(3) + ",sfCategoryFlg,Y,aditAutoInsert," + autoinsert + ",(sfCategoryFlg should not be Y or autoinsert should be 1)");
                }
                if (sflabel && autoinsert != 2) {
                    System.err.println(rs.getString(1) + "," + rs.getString(2) + "," + rs.getString(3) + ",sfLabelFlg,Y,aditAutoInsert," + autoinsert + ",(sfLabelFlg should not be Y or autoinsert should be 2)");
                }
                if (sfid && autoinsert != 4) {
                    System.err.println(rs.getString(1) + "," + rs.getString(2) + "," + rs.getString(3) + ",sfIdFlg,Y,aditAutoInsert," + autoinsert + ",(sfIdFlg should not be Y or autoinsert should be 4)");
                }
                if (!rowindex || autoinsert == 6) continue;
                System.err.println(rs.getString(1) + "," + rs.getString(2) + "," + rs.getString(3) + ",rowIndexFlg,Y,aditAutoInsert," + autoinsert + ",(rowIndexFlg should not be Y or autoinsert should be 6)");
            }
            if (!this.fValConn.getAutoCommit()) {
                pstat.getConnection().commit();
            }
            pstat.close();
            rs.close();
            query.close();
            Statement stat = this.fValConn.createStatement();
            if (out != null) {
                out.println("UPDATE TAGS SET ADITAUTO='Y' WHERE ADITDEFAULT IS NOT NULL");
            }
            stat.executeUpdate("UPDATE TAGS SET ADITAUTO='Y' WHERE ADITDEFAULT IS NOT NULL");
            if (!this.fValConn.getAutoCommit()) {
                this.fValConn.commit();
            }
            stat.close();
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean loadTags(PrintWriter out) {
        Statement srcstat = null;
        Statement dststat = null;
        StringBuffer sql = new StringBuffer();
        int pos = -1;
        try {
            if (this.fValConn != null) {
                dststat = this.fValConn.createStatement();
            }
            srcstat = this.fDictConn.createStatement(1004, 1007);
            sql.append("SELECT DICTIONARYSEQ,ORIGINALCATEGORY,ORIGINALTAG,DBTYPE,");
            sql.append("FRAMECODEVALUEFLG,VALIDATEFLGS,ITEMENUMCLOSEDFLG,ROWINDEXFLG,");
            sql.append("SFIDFLG,SFLABELFLG,SFCATEGORYFLG,LOOPFLAG,DBNULLABLE,");
            sql.append("DEFAULTVALUE,ADITAUTOINSERT,DATUMCOUNTFLGS,LCLIDFLG,");
            sql.append("ADITEXISTS,METADATAFLGS,TAGDELETEFLGS FROM DICT");
            ResultSet rs = srcstat.executeQuery(sql.toString());
            sql.setLength(0);
            while (rs.next()) {
                String str = null;
                String type = null;
                sql.setLength(0);
                sql.append("INSERT INTO TAGS (SEQ,SFCAT,TAGNAME,VALTYPE,VALSIZE,MANDATORY,ENUMCLOSEDFLAG,");
                sql.append("ROWIDXFLAG,SFIDFLAG,SFLABELFLAG,SFCATFLAG,LOOPFLAG,LOOPMANDATORY,ADITDEFAULT,");
                sql.append("ADITAUTO,DATUMCOUNT,LOCALIDFLAG,SFLINKFLAG,ENTRYIDFLAG,METADATA,DELETEFLAG) VALUES (");
                sql.append(rs.getInt(1));
                sql.append(",'");
                sql.append(rs.getString(2));
                sql.append("','");
                sql.append(rs.getString(3));
                sql.append("','");
                String size = null;
                str = rs.getString(4).toUpperCase();
                if (str.indexOf("CHAR") >= 0) {
                    type = "STRING";
                    pos = str.indexOf(40);
                    if (pos > -1) {
                        size = str.substring(pos + 1, str.indexOf(41));
                    }
                } else if (str.indexOf("TEXT") >= 0) {
                    type = "STRING";
                } else if (str.indexOf("INTEGER") >= 0) {
                    type = "INTEGER";
                } else if (str.indexOf("FLOAT") >= 0) {
                    type = "FLOAT";
                } else if (str.indexOf("DATE") >= 0) {
                    type = "DATE";
                }
                if (rs.getString(5).toUpperCase().equals("Y")) {
                    type = "FRAMECODE";
                }
                sql.append(type);
                sql.append("', ");
                if (size == null) {
                    sql.append("NULL");
                } else {
                    sql.append(size);
                }
                sql.append(", '");
                str = rs.getString(6);
                if (str == null || str.equals("null")) {
                    System.err.println("No validation flag for tag # " + rs.getInt(1));
                    return false;
                }
                char mandatory = str.toUpperCase().charAt(this.fMode);
                sql.append(mandatory);
                sql.append("', '");
                str = rs.getString(7);
                if (rs.wasNull()) {
                    sql.append("N");
                } else {
                    sql.append(str.toUpperCase().charAt(0));
                }
                sql.append("', '");
                str = rs.getString(8);
                if (rs.wasNull()) {
                    sql.append("N");
                } else {
                    sql.append(str.toUpperCase().charAt(0));
                }
                sql.append("', '");
                str = rs.getString(9);
                if (rs.wasNull()) {
                    sql.append("N");
                } else {
                    sql.append(str.toUpperCase().charAt(0));
                }
                sql.append("', '");
                str = rs.getString(10);
                if (rs.wasNull()) {
                    sql.append("N");
                } else {
                    sql.append(str.toUpperCase().charAt(0));
                }
                sql.append("', '");
                str = rs.getString(11);
                if (rs.wasNull()) {
                    sql.append('N');
                } else {
                    sql.append(str.toUpperCase().charAt(0));
                }
                sql.append("', '");
                str = rs.getString(12);
                int flag = rs.wasNull() ? 78 : (int)str.toUpperCase().charAt(0);
                sql.append((char)flag);
                sql.append("', '");
                str = rs.getString(13);
                if (rs.wasNull()) {
                    sql.append('N');
                } else if (str.toUpperCase().equals("NOT NULL") && flag == 89 && mandatory == 'O') {
                    sql.append('Y');
                } else {
                    sql.append('N');
                }
                sql.append("',");
                str = rs.getString(14);
                if (rs.wasNull()) {
                    str = null;
                }
                if (rs.getString(3).indexOf(".Entry_ID") >= 0) {
                    sql.append("'NEED_ACC_NUM'");
                } else if (str == null || str.equals("?")) {
                    sql.append("NULL");
                } else {
                    sql.append(QuoteString.quoteForDB(str));
                }
                sql.append(",'");
                rs.getString(15);
                String autoinsert = rs.wasNull() ? "0" : rs.getString(15).trim();
                rs.getString(17);
                flag = rs.wasNull() ? 78 : (int)rs.getString(17).trim().toUpperCase().charAt(0);
                if (!autoinsert.equals("0")) {
                    sql.append("Y'");
                } else if (str != null && !str.equals("?")) {
                    sql.append("Y'");
                } else if (flag == 78) {
                    sql.append("Y'");
                } else {
                    sql.append("N'");
                }
                sql.append(",'");
                rs.getString(16);
                flag = rs.wasNull() ? 78 : (int)rs.getString(16).toUpperCase().charAt(0);
                if (flag == 89) {
                    sql.append("Y'");
                } else {
                    sql.append("N'");
                }
                sql.append(",'");
                if (autoinsert.equals("5")) {
                    sql.append("Y'");
                } else {
                    sql.append("N'");
                }
                sql.append(",'");
                if (autoinsert.equals("7")) {
                    sql.append("Y'");
                } else {
                    sql.append("N'");
                }
                sql.append(",'");
                if (autoinsert.equals("3")) {
                    sql.append("Y'");
                } else {
                    sql.append("N'");
                }
                sql.append(",'");
                rs.getString(19);
                if (rs.wasNull()) {
                    sql.append("N'");
                } else if (rs.getString(19).toUpperCase().charAt(0) == 'Y') {
                    sql.append("Y'");
                } else {
                    sql.append("N'");
                }
                sql.append(",'");
                rs.getString(20);
                if (rs.wasNull()) {
                    sql.append("N'");
                } else if (rs.getString(20).toUpperCase().charAt(0) == 'Y') {
                    sql.append("Y'");
                } else {
                    sql.append("N'");
                }
                sql.append(')');
                if (out != null) {
                    out.println(sql);
                }
                if (dststat == null) continue;
                dststat.executeUpdate(sql.toString());
            }
            if (out != null) {
                out.flush();
            }
            srcstat.close();
            if (this.fValConn != null && !this.fValConn.getAutoCommit()) {
                this.fValConn.commit();
            }
            sql.setLength(0);
            sql.append("UPDATE TAGS SET ADITAUTO='Y' WHERE ADITDEFAULT IS NOT NULL");
            if (out != null) {
                out.println(sql);
            }
            if (dststat != null) {
                dststat.executeUpdate(sql.toString());
                dststat.getConnection().commit();
            }
            if (dststat != null) {
                dststat.close();
            }
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean loadValueEnums(PrintWriter out) {
        Statement srcstat = null;
        Statement dststat = null;
        String str = null;
        StringBuffer sql = new StringBuffer();
        try {
            if (this.fValConn != null) {
                dststat = this.fValConn.createStatement();
            }
            srcstat = this.fDictConn.createStatement(1004, 1007);
            sql.append("SELECT t.DICTIONARYSEQ, d.VALUE, h.SFCATEGORY, h.ORIGINALTAG FROM ");
            sql.append("ADITENUMHDR h, ADITENUMDTL d, DICT t ");
            sql.append("WHERE h.ENUMID=d.ENUMID AND h.SFCATEGORY=t.ORIGINALCATEGORY ");
            sql.append("AND h.ORIGINALTAG=t.ORIGINALTAG");
            ResultSet rs = srcstat.executeQuery(sql.toString());
            sql.setLength(0);
            while (rs.next()) {
                str = rs.getString(1);
                if (rs.wasNull()) {
                    System.err.println("Invalid tag " + rs.getString(3) + ", " + rs.getString(4) + " in ADITENUMHDR table");
                    return false;
                }
                str = rs.getString(2);
                if (rs.wasNull()) {
                    System.err.println("Null enumeraton value for tag " + rs.getString(3) + ", " + rs.getString(4));
                    return false;
                }
                ResultSet chk = dststat.executeQuery("SELECT SEQ FROM TAGS WHERE SEQ=" + rs.getInt(1));
                if (!chk.next()) continue;
                sql.append("INSERT INTO VALENUMS (SEQ, VAL) VALUES (");
                sql.append(rs.getString(1));
                sql.append(", '");
                sql.append(str);
                sql.append("')");
                if (out != null) {
                    out.println(sql + ";");
                }
                if (dststat != null) {
                    dststat.executeUpdate(sql.toString());
                }
                sql.setLength(0);
            }
            srcstat.close();
            if (this.fValConn != null && !this.fValConn.getAutoCommit()) {
                this.fValConn.commit();
            }
            if (dststat != null) {
                dststat.close();
            }
            if (out != null) {
                out.flush();
            }
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return false;
        }
    }

    public boolean loadSfDeps(PrintWriter out) {
        Object query = null;
        Object rs = null;
        StringBuffer sql = new StringBuffer();
        try {
            sql.append("SELECT SFCATEGORY,NEWVIEWMANDATORYCODE,CONDITIONALCATID,");
            sql.append("CONDITIONALITEMNAME,CONDITIONALITEMVALUE FROM ADITMANOVERRIDE ");
            sql.append("WHERE CATEGORYID='*' AND ITEMNAME='*' AND NEWVIEWMANDATORYCODE <> 'H'");
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean loadValidationLinks(PrintWriter out) {
        Statement srcstat = null;
        Statement dststat = null;
        String str = null;
        StringBuffer sql = new StringBuffer();
        try {
            if (this.fValConn != null) {
                dststat = this.fValConn.createStatement();
            }
            srcstat = this.fDictConn.createStatement(1004, 1007);
            sql.append("SELECT t1.DICTIONARYSEQ, v.CTLVALUE, t2.DICTIONARYSEQ, v.VALIDATEFLAGS, ");
            sql.append("t2.VALIDATEFLGS, v.CTLSFCATEGORY, v.CTLTAG, v.DEPSFCATEGORY, v.DEPTAG ");
            sql.append("FROM DICT t1, DICT t2, VALIDATIONLINKS v ");
            sql.append("WHERE v.CTLSFCATEGORY=t1.ORIGINALCATEGORY AND v.CTLTAG=t1.ORIGINALTAG ");
            sql.append(" AND v.DEPSFCATEGORY=t2.ORIGINALCATEGORY AND v.DEPTAG=t2.ORIGINALTAG");
            ResultSet rs = srcstat.executeQuery(sql.toString());
            sql.setLength(0);
            while (rs.next()) {
                str = rs.getString(2);
                if (str.equals("*")) continue;
                sql.setLength(0);
                sql.append("INSERT INTO TAGDEPS (CTLSEQ, CTLVALUE, SEQ, MANDATORY) VALUES (");
                sql.append(rs.getInt(1));
                sql.append(", ");
                str = rs.getString(2);
                if (rs.wasNull()) {
                    sql.append("NULL, ");
                } else {
                    sql.append("'");
                    sql.append(str);
                    sql.append("', ");
                }
                sql.append(rs.getInt(3));
                sql.append(", '");
                str = rs.getString(4);
                char flag = str.toUpperCase().charAt(this.fMode);
                sql.append(flag);
                sql.append("')");
                if (out != null) {
                    out.println(sql);
                }
                if (dststat != null) {
                    dststat.executeUpdate(sql.toString());
                }
                sql.setLength(0);
                sql.append("UPDATE TAGS SET TAGDEPFLAG='Y' WHERE SEQ=");
                sql.append(rs.getInt(3));
                if (out != null) {
                    out.println(sql);
                }
                if (dststat == null) continue;
                dststat.executeUpdate(sql.toString());
            }
            srcstat.close();
            if (out != null) {
                out.println("COMMIT");
                out.flush();
            }
            if (dststat != null) {
                dststat.executeUpdate("UPDATE TAGS SET TAGDEPFLAG='N' WHERE TAGDEPFLAG IS NULL");
            }
            if (this.fValConn != null && !this.fValConn.getAutoCommit()) {
                this.fValConn.commit();
            }
            if (dststat != null) {
                dststat.close();
            }
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean loadTagRelations(PrintWriter out) {
        Statement srcstat = null;
        Statement dststat = null;
        Object str = null;
        StringBuffer sql = new StringBuffer();
        try {
            if (this.fValConn != null) {
                dststat = this.fValConn.createStatement();
            }
            srcstat = this.fDictConn.createStatement(1003, 1007);
            sql.append("SELECT c.DICTIONARYSEQ,p.DICTIONARYSEQ ");
            sql.append("FROM DICT c, DICT p WHERE c.FOREIGNTABLE IS NOT NULL ");
            sql.append("AND c.FOREIGNCOLUMN IS NOT NULL ");
            sql.append("AND p.TAGCATEGORY=c.FOREIGNTABLE ");
            sql.append("AND p.TAGFIELD=c.FOREIGNCOLUMN");
            if (out != null) {
                out.println(sql);
            }
            ResultSet rs = srcstat.executeQuery(sql.toString());
            while (rs.next()) {
                sql.setLength(0);
                sql.append("INSERT INTO TAGRELS (PRNTSEQ,CHLDSEQ) VALUES (");
                sql.append(rs.getString(2));
                sql.append(',');
                sql.append(rs.getString(1));
                sql.append(')');
                if (out != null) {
                    out.println(sql);
                }
                dststat.executeUpdate(sql.toString());
            }
            rs.close();
            srcstat.close();
            dststat.getConnection().commit();
            dststat.close();
            if (out != null) {
                out.flush();
            }
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return false;
        }
    }

    public boolean loadSFLinks(PrintWriter out) {
        if (this.fValConn == null) {
            return false;
        }
        try {
            Statement stat = this.fValConn.createStatement();
            Statement labquery = this.fValConn.createStatement(1003, 1007);
            Statement idquery = this.fValConn.createStatement(1003, 1007);
            ResultSet idrs = null;
            int pos = -1;
            String tag = null;
            StringBuffer sql = new StringBuffer("SELECT SEQ,TAGNAME FROM TAGS ");
            sql.append("WHERE VALTYPE='FRAMECODE'");
            if (out != null) {
                out.println(sql);
            }
            ResultSet labrs = labquery.executeQuery(sql.toString());
            while (labrs.next()) {
                pos = labrs.getString(2).indexOf(LABELTAG_SUFFIX);
                if (pos < 0) continue;
                tag = labrs.getString(2).substring(0, pos + 1);
                sql.setLength(0);
                sql.append("SELECT SEQ FROM TAGS t,TAGRELS r WHERE t.TAGNAME='");
                sql.append(labrs.getString(2).substring(0, pos));
                sql.append(IDTAG_SUFFIX);
                sql.append(labrs.getString(2).substring(pos + 6));
                sql.append("' AND t.SEQ=r.CHLDSEQ");
                if (out != null) {
                    out.println(sql);
                }
                if (!(idrs = idquery.executeQuery(sql.toString())).next()) continue;
                sql.setLength(0);
                sql.append("UPDATE TAGS SET SFLINKFLAG='Y' WHERE SEQ=");
                sql.append(idrs.getInt(1));
                if (out != null) {
                    out.println(sql);
                }
                stat.executeUpdate(sql.toString());
            }
            stat.getConnection().commit();
            stat.close();
            if (idrs != null) {
                idrs.close();
            }
            idquery.close();
            if (labrs != null) {
                labrs.close();
            }
            labquery.close();
            if (out != null) {
                out.flush();
            }
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return false;
        }
    }

    public boolean loadDBNames(PrintWriter out) {
        if (this.fValConn == null) {
            return false;
        }
        if (this.fDictConn == null) {
            return false;
        }
        boolean notnull = false;
        try {
            PreparedStatement stat = this.fValConn.prepareStatement("INSERT INTO DBNAMES (SEQ,DBTABLE,DBCOLUMN,DBTYPE,NOT_NULL,DBPK,DBFKTABLE,DBFKCOLUMN,DBFKGROUP) VALUES (?,?,?,?,?,?,?,?,?)");
            Statement query = this.fDictConn.createStatement(1003, 1007);
            ResultSet rs = query.executeQuery("SELECT DICTIONARYSEQ,DBTABLEMANUAL,DBCOLUMNMANUAL,DBTYPE,DBNULLABLE,PRIMARYKEY,FOREIGNTABLE,FOREIGNCOLUMN,FOREIGNKEYGROUP FROM DICT ORDER BY DICTIONARYSEQ");
            while (rs.next()) {
                notnull = false;
                stat.setInt(1, rs.getInt(1));
                stat.setString(2, rs.getString(2));
                stat.setString(3, rs.getString(3));
                stat.setString(4, rs.getString(4));
                rs.getString(5);
                if (!rs.wasNull() && rs.getString(5).trim().equals("NOT NULL")) {
                    notnull = true;
                }
                if (notnull) {
                    stat.setString(5, "Y");
                } else {
                    stat.setString(5, "N");
                }
                notnull = false;
                rs.getString(6);
                if (!rs.wasNull() && rs.getString(6).trim().charAt(0) == 'Y') {
                    notnull = true;
                }
                if (notnull) {
                    stat.setString(6, "Y");
                } else {
                    stat.setString(6, "N");
                }
                rs.getString(7);
                if (rs.wasNull()) {
                    stat.setNull(7, 12);
                } else {
                    stat.setString(7, rs.getString(7));
                }
                rs.getString(8);
                if (rs.wasNull()) {
                    stat.setNull(8, 12);
                } else {
                    stat.setString(8, rs.getString(8));
                }
                rs.getString(9);
                if (rs.wasNull()) {
                    stat.setNull(9, 12);
                } else {
                    stat.setString(9, rs.getString(9));
                }
                stat.executeUpdate();
            }
            stat.getConnection().commit();
            stat.close();
            rs.close();
            query.close();
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static void usage() {
        System.err.println("Usage: EDU.bmrb.nmrstar.dictionary.ValidatorDB -m MODE [-c DIR] [-e FILE] [-o SQLFILE] [-d]");
        System.err.println(" create validation dictionary from main NMR-STAR dictionary");
        System.err.println("      -m: validation MODE, int 0..5 (default: 0)");
        System.err.println("      -c: use configuraton files in DIR (default: ~)");
        System.err.println("      -e: load extra enumerations from FILE");
        System.err.println("      -d: extract db table and column names");
        System.err.println("      -o: dump SQL statemets to SQLFILE (use dash to dump to stdout)");
    }

    public static void main(String[] args) {
        DBMgr valdb;
        DBMgr dictdb;
        ValidatorDB val;
        PrintWriter out;
        String enumfile;
        boolean db_names;
        block30: {
            int opt;
            Getopt g = new Getopt("EDU.bmrb.nmrstar.dictionary.ValidatorDB", args, "dhc:m:e:o:");
            int mode = -1;
            db_names = false;
            String confdir = null;
            String sqlfile = null;
            enumfile = null;
            block21: while ((opt = g.getopt()) != -1) {
                switch (opt) {
                    case 99: {
                        confdir = g.getOptarg();
                        continue block21;
                    }
                    case 100: {
                        db_names = true;
                        continue block21;
                    }
                    case 101: {
                        enumfile = g.getOptarg();
                        continue block21;
                    }
                    case 109: {
                        try {
                            mode = Integer.parseInt(g.getOptarg());
                            continue block21;
                        }
                        catch (Exception e) {
                            ValidatorDB.usage();
                            return;
                        }
                    }
                    case 111: {
                        sqlfile = g.getOptarg();
                        continue block21;
                    }
                }
                ValidatorDB.usage();
                return;
            }
            if (mode < 0 || mode > 5) {
                ValidatorDB.usage();
                return;
            }
            out = null;
            if (sqlfile != null) {
                if (sqlfile.equals("-")) {
                    out = new PrintWriter(System.out);
                } else {
                    try {
                        out = new PrintWriter(new FileOutputStream(sqlfile));
                    }
                    catch (Exception e) {
                        System.err.println(e.getLocalizedMessage());
                        e.printStackTrace();
                    }
                }
            }
            try {
                val = confdir != null ? new ValidatorDB(confdir, mode) : new ValidatorDB(null, mode);
            }
            catch (IOException e) {
                System.err.println("Cannot read config files");
                System.err.println(e.getMessage());
                e.printStackTrace();
                return;
            }
            dictdb = new DBMgr(val.fDictProps.getProperties());
            try {
                dictdb.connect(false);
            }
            catch (Exception e) {
                System.err.println("Cannot connect to NMR-STAR dictionary database");
                System.err.println(e.getMessage());
                e.printStackTrace();
                return;
            }
            valdb = new DBMgr(val.fValProps.getProperties());
            try {
                valdb.connect(false);
            }
            catch (Exception e) {
                System.err.println("Cannot connect to validation dictionary database");
                System.err.println(e.getMessage());
                e.printStackTrace();
                if (out != null) break block30;
                return;
            }
        }
        try {
            CreateDBSchema.runScript(valdb.getConnection(), val.fValProps.getProperty(SCHEMA_SCRIPT), out);
        }
        catch (Exception e) {
            System.err.println("Cannot create database tables");
            System.err.println(e);
            e.printStackTrace();
            valdb.close();
            dictdb.close();
            return;
        }
        val.fDictConn = dictdb.getConnection();
        val.fValConn = valdb.getConnection();
        val.loadModeTables(out);
        val.loadSFCategories(out);
        val.loadTags_ps(out);
        val.loadValueEnums(out);
        val.loadValidationLinks(out);
        val.loadTagRelations(out);
        if (db_names) {
            val.loadDBNames(out);
        }
        dictdb.close();
        val.loadSFLinks(out);
        if (enumfile != null && enumfile.length() > 0) {
            AddEnumerations add = new AddEnumerations(valdb);
            add.addEnumerations(enumfile);
        }
        try {
            Statement stat = valdb.getConnection().createStatement();
            ResultSet rs1 = stat.executeQuery("SELECT DMODE,VERSION,DICTFLAG FROM DICT");
            while (rs1.next()) {
                System.err.println("*** " + rs1.getString(1) + "," + rs1.getString(2) + "," + rs1.getString(3));
            }
            rs1.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        valdb.close();
        if (out != null) {
            out.close();
        }
    }
}

