/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.nmrstar.utils;

import EDU.bmrb.lib.ErrorList;
import EDU.bmrb.nmrstar.utils.QuoteString;
import gnu.getopt.Getopt;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class DbToStar {
    private static final boolean DEBUG = true;
    public static final String DRIVER_KEY = "DB.Driver";
    public static final String DBURL_KEY = "DB.Url";
    public static final String DBUSER_KEY = "DB.User";
    public static final String DBPASSWD_KEY = "DB.Password";
    private static final String ERR_DBEXC = "DB exception";
    private static final int TABWIDTH = 4;
    private Connection fConn = null;
    private PrintWriter fOut = null;
    private ErrorList fErrs = null;
    private List fTables = null;

    public DbToStar(Connection conn, PrintWriter out, ErrorList errs) {
        this.fConn = conn;
        this.fOut = out;
        this.fErrs = errs;
        this.fTables = new ArrayList();
    }

    private void checkTableNames(List tables) throws SQLException {
        if (this.fConn == null || this.fConn.isClosed()) {
            System.err.println("Not connected to database");
            return;
        }
        String[] type = new String[]{"TABLE"};
        DatabaseMetaData md = this.fConn.getMetaData();
        ResultSet rs = md.getDatabaseProductName().matches(".*Oracle.*") ? md.getTables(null, md.getUserName(), null, type) : md.getTables(null, null, null, type);
        if (tables == null) {
            while (rs.next()) {
                this.fTables.add(rs.getString(3));
            }
        } else {
            int i;
            block1: while (rs.next()) {
                for (i = 0; i < tables.size(); ++i) {
                    if (!tables.get(i).equals(rs.getString(3))) continue;
                    this.fTables.add(tables.get(i));
                    continue block1;
                }
            }
            for (i = 0; i < tables.size(); ++i) {
                boolean found = false;
                for (int j = 0; j < this.fTables.size(); ++j) {
                    if (!tables.get(i).equals(this.fTables.get(j))) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                System.err.print("Invalid table name: ");
                System.err.println(tables.get(i));
            }
        }
        rs.close();
        if (tables != null && this.fTables.size() == tables.size()) {
            this.fTables.clear();
            this.fTables = tables;
        }
    }

    public void printTable(String name) throws SQLException {
        String s;
        int j;
        if (this.fConn == null || this.fConn.isClosed()) {
            System.err.println("Not connected to database");
            return;
        }
        Statement query = this.fConn.createStatement(1004, 1007);
        ResultSet rs = query.executeQuery("SELECT COUNT(*) FROM " + name);
        rs.next();
        int i = rs.getInt(1);
        System.err.println(rs.getInt(1) + " rows in table " + name);
        if (rs.wasNull() || i < 1) {
            rs.close();
            query.close();
            return;
        }
        this.fOut.print("save_");
        this.fOut.println(name);
        rs = query.executeQuery("SELECT * FROM " + name);
        ResultSetMetaData md = rs.getMetaData();
        for (i = 0; i < 4; ++i) {
            this.fOut.print(' ');
        }
        this.fOut.println("loop_");
        for (i = 1; i < md.getColumnCount() + 1; ++i) {
            for (j = 0; j < 8; ++j) {
                this.fOut.print(' ');
            }
            this.fOut.print('_');
            this.fOut.println(md.getColumnName(i));
        }
        int[] widths = new int[md.getColumnCount() + 1];
        for (i = 0; i < widths.length; ++i) {
            widths[i] = 0;
        }
        while (rs.next()) {
            for (i = 1; i < md.getColumnCount() + 1; ++i) {
                s = rs.getString(i);
                if (rs.wasNull() || s.length() <= widths[i - 1]) continue;
                widths[i - 1] = s.length();
            }
        }
        i = 0;
        while (i < widths.length) {
            int n = i++;
            widths[n] = widths[n] + 4;
        }
        rs = query.executeQuery("SELECT * FROM " + name);
        while (rs.next()) {
            for (j = 0; j < 8; ++j) {
                this.fOut.print(' ');
            }
            for (i = 1; i < md.getColumnCount() + 1; ++i) {
                s = rs.getString(i);
                s = rs.wasNull() ? "." : QuoteString.quoteForSTAR(s);
                this.fOut.print(s);
                for (j = s.length(); j < widths[i - 1]; ++j) {
                    this.fOut.print(' ');
                }
            }
            this.fOut.println();
        }
        rs.close();
        query.close();
        for (i = 0; i < 4; ++i) {
            this.fOut.print(' ');
        }
        this.fOut.println("stop_");
        this.fOut.println("save_");
        this.fOut.println();
        this.fOut.flush();
    }

    public void print() throws SQLException {
        if (this.fConn == null || this.fConn.isClosed()) {
            System.err.println("Not connected to database");
            return;
        }
        this.checkTableNames(null);
        this.fOut.println("data_TABLEDUMP");
        this.fOut.println();
        for (int i = 0; i < this.fTables.size(); ++i) {
            this.printTable((String)this.fTables.get(i));
        }
    }

    public void print(List tables) throws SQLException {
        if (this.fConn == null || this.fConn.isClosed()) {
            System.err.println("Not connected to database");
            return;
        }
        this.checkTableNames(tables);
        this.fOut.println("data_TABLEDUMP");
        this.fOut.println();
        for (int i = 0; i < this.fTables.size(); ++i) {
            this.printTable((String)this.fTables.get(i));
        }
    }

    public static void usage() {
        System.out.print("Usage: java EDU.bmrb.javalib.DbToStar [-h]");
        System.out.println(" [-c FILE] [-o FILE] [-t TABLE]");
        System.out.println("  -h: print this usage summary");
        System.out.println("  -c FILE: configuration FILE");
        System.out.println("  -o FILE: output FILE (default: stdout)");
        System.out.print("  -t TABLE: db table to print. Multiple -t options");
        System.out.println(" are allowed. Default: print all tables");
    }

    public static void main(String[] args) {
        int opt;
        Getopt g = new Getopt("EDU.bmrb.lib.DbToStar", args, "hc:o:t:");
        String conffile = null;
        String outfile = null;
        ArrayList<String> tables = null;
        block7: while ((opt = g.getopt()) != -1) {
            switch (opt) {
                case 99: {
                    conffile = g.getOptarg();
                    continue block7;
                }
                case 111: {
                    outfile = g.getOptarg();
                    continue block7;
                }
                case 116: {
                    if (tables == null) {
                        tables = new ArrayList<String>();
                    }
                    tables.add(g.getOptarg().toUpperCase());
                    continue block7;
                }
            }
            DbToStar.usage();
            return;
        }
        if (conffile == null) {
            DbToStar.usage();
            return;
        }
        Connection conn = null;
        try {
            Properties props = new Properties();
            FileInputStream fin = new FileInputStream(conffile);
            props.load(fin);
            fin.close();
            PrintWriter out = null;
            out = outfile == null ? new PrintWriter(System.out) : new PrintWriter(new FileOutputStream(outfile));
            String drv = props.getProperty(DRIVER_KEY);
            if (drv == null) {
                throw new NullPointerException("Missing DB driver");
            }
            String url = props.getProperty(DBURL_KEY);
            if (url == null) {
                throw new NullPointerException("Missing DB URL");
            }
            Class.forName(drv);
            conn = DriverManager.getConnection(url, props.getProperty(DBUSER_KEY), props.getProperty(DBPASSWD_KEY));
            conn.setAutoCommit(false);
            DbToStar o = new DbToStar(conn, out, null);
            o.checkTableNames(tables);
            if (tables != null) {
                tables.clear();
            }
            o.print();
            conn.close();
            out.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

