/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.nmrstar.utils;

import EDU.bmrb.sansj.ContentHandler;
import EDU.bmrb.sansj.DataItemNode;
import EDU.bmrb.sansj.ErrorHandler;
import EDU.bmrb.sansj.STARLexer;
import EDU.bmrb.sansj.SansParser;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class PDBMatch
implements ContentHandler,
ErrorHandler {
    public static final String BMRBNO_TAG = "_BMRB_accession_number";
    public static final String AUTHOR_SFCAT = "molecular_system";
    public static final String AUTO_SFCAT = "monomeric_polymer";
    public static final String DBNAME_TAG = "_Database_name";
    public static final String DBID_TAG = "_Database_accession_code";
    public static final String SFCAT_TAG = "_Saveframe_category";
    private PrintWriter fOut = null;
    private String fDbId = null;
    private boolean fBlastHits = false;
    private boolean fInSf = false;
    private String fBmrbId = null;
    private boolean fInLoop = false;
    private boolean fFetchNext = false;

    public void setOut(PrintWriter printWriter) {
        this.fOut = printWriter;
    }

    public void setDbId(String string) {
        if (string == null || string.length() < 1) {
            throw new NullPointerException("Invalid DB ID");
        }
        this.fDbId = string.toUpperCase();
    }

    public void setBlastHits(boolean bl) {
        this.fBlastHits = bl;
    }

    public static void usage() {
        System.out.print("Usage: java EDU.bmrb.nmrstar.utils.PDBMatch [-b]");
        System.out.println(" [-i filename] [-d id] [-o filename] [-h]");
        System.out.println("  -b: extract auto-generated IDs (default: extract ID provided by author");
        System.out.println("  -i filename: input file name (default: stdin)");
        System.out.println("  -d id: database id, e.g. PDB, SWISS-PROT (default: PDB)");
        System.out.println("  -o filename: output file name (default: stdout)");
        System.out.println("  -h: print this help message and exit");
    }

    public static void main(String[] stringArray) {
        int n;
        Getopt getopt = new Getopt("pdbmatch", stringArray, "bhd:i:o:");
        boolean bl = false;
        String string = "PDB";
        String string2 = null;
        String string3 = null;
        block10: while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 98: {
                    bl = true;
                    continue block10;
                }
                case 100: {
                    string = getopt.getOptarg();
                    continue block10;
                }
                case 105: {
                    string2 = getopt.getOptarg();
                    continue block10;
                }
                case 111: {
                    string3 = getopt.getOptarg();
                    continue block10;
                }
            }
            PDBMatch.usage();
            return;
        }
        BufferedReader bufferedReader = null;
        PrintWriter printWriter = null;
        try {
            bufferedReader = string2 == null || string2.length() < 1 ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new InputStreamReader(new FileInputStream(string2)));
        }
        catch (IOException iOException) {
            System.err.println("Cannot open input file");
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
            return;
        }
        try {
            printWriter = string3 == null || string3.length() < 1 ? new PrintWriter(System.out) : new PrintWriter(new FileOutputStream(string3));
        }
        catch (IOException iOException) {
            System.err.println("Cannot open output file");
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
            return;
        }
        PDBMatch pDBMatch = new PDBMatch();
        pDBMatch.setDbId(string);
        pDBMatch.setOut(printWriter);
        pDBMatch.setBlastHits(bl);
        STARLexer sTARLexer = new STARLexer(bufferedReader);
        SansParser sansParser = new SansParser(sTARLexer);
        sansParser.setContentHandler(pDBMatch);
        sansParser.setErrorHandler(pDBMatch);
        sansParser.parse();
        printWriter.flush();
    }

    public void error(int n, int n2, String string) {
        System.err.print("Entry ");
        System.err.print(this.fBmrbId);
        System.err.print(": parse error in line ");
        System.err.print(n);
        System.err.print(", column ");
        System.err.print(n2);
        System.err.print(": ");
        System.err.println(string);
    }

    public boolean warning(int n, int n2, String string) {
        return false;
    }

    public boolean comment(int n, String string) {
        return false;
    }

    public boolean startData(int n, String string) {
        return false;
    }

    public void endData(int n, String string) {
    }

    public boolean startSaveFrame(int n, String string) {
        return false;
    }

    public boolean endSaveFrame(int n, String string) {
        this.fInSf = false;
        return false;
    }

    public boolean startLoop(int n) {
        this.fInLoop = true;
        return false;
    }

    public boolean endLoop(int n) {
        this.fInLoop = false;
        return false;
    }

    public boolean data(DataItemNode dataItemNode) {
        if (dataItemNode.getName().equals(SFCAT_TAG)) {
            if (this.fBlastHits) {
                if (dataItemNode.getValue().equals(AUTO_SFCAT)) {
                    this.fInSf = true;
                }
            } else if (dataItemNode.getValue().equals(AUTHOR_SFCAT)) {
                this.fInSf = true;
            }
        } else if (dataItemNode.getName().equals(BMRBNO_TAG)) {
            this.fBmrbId = dataItemNode.getValue();
        }
        if (this.fInSf && this.fInLoop) {
            if (dataItemNode.getName().equals(DBNAME_TAG)) {
                this.fFetchNext = dataItemNode.getValue().toUpperCase().equals(this.fDbId);
            } else if (dataItemNode.getName().equals(DBID_TAG) && this.fFetchNext && !dataItemNode.getValue().equals(".") && !dataItemNode.getValue().equals("?")) {
                this.fOut.print(dataItemNode.getValue());
                this.fOut.print('\t');
                this.fOut.println(this.fBmrbId);
            }
        }
        return false;
    }
}

