/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.nmrstar.utils;

public class QuoteString {
    public static String quoteForSTAR(String str) {
        StringBuffer buf = new StringBuffer();
        int q = QuoteString.findSTARQuoteStyle(str);
        switch (q) {
            case 11: {
                buf.append("\n;\n");
                buf.append(str);
                buf.append("\n;");
                break;
            }
            case 10: {
                buf.append('\"');
                buf.append(str);
                buf.append('\"');
                break;
            }
            case 9: {
                buf.append('\'');
                buf.append(str);
                buf.append('\'');
                break;
            }
            default: {
                buf.append(str);
            }
        }
        return buf.toString();
    }

    public static String quote(String str) {
        return QuoteString.quoteForSTAR(str);
    }

    public static int findSTARQuoteStyle(String str) {
        if (str == null || str.length() < 1) {
            return 13;
        }
        int spc = str.indexOf(32);
        int tab = str.indexOf("\t");
        boolean has_whitespace = spc > -1 || tab > -1;
        boolean has_nl = str.indexOf("\n") > -1;
        boolean has_dq = false;
        int dq = str.indexOf(34);
        if (dq == 0) {
            has_dq = true;
        } else {
            dq = str.indexOf(" \"");
            if (dq > -1) {
                has_dq = true;
            }
        }
        boolean has_sq = false;
        int sq = str.indexOf(39);
        if (sq == 0) {
            has_sq = true;
        } else {
            sq = str.indexOf(" '");
            if (sq > -1) {
                has_sq = true;
            }
        }
        if (has_nl) {
            return 11;
        }
        if (has_sq && has_dq) {
            return 11;
        }
        if (has_sq && !has_dq) {
            return 10;
        }
        if (!has_sq && has_dq) {
            return 9;
        }
        if (has_whitespace && has_sq && has_dq) {
            return 11;
        }
        if (has_whitespace && has_dq) {
            return 9;
        }
        if (has_whitespace) {
            return 10;
        }
        if (str.charAt(0) == '_') {
            return 10;
        }
        return 13;
    }

    public static String quoteForDB(String str) {
        if (str == null || str.equals(".")) {
            return "NULL";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('\'');
        for (int i = 0; i < str.length(); ++i) {
            buf.append(str.charAt(i));
            if (str.charAt(i) != '\'') continue;
            buf.append("'");
        }
        buf.append('\'');
        return buf.toString();
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            System.out.println(QuoteString.quote(args[i]));
        }
    }
}

