/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.sansj;

import EDU.bmrb.sansj.ErrorHandler;
import EDU.bmrb.sansj.STARLexer;
import EDU.bmrb.sansj.StarContentHandler;
import EDU.bmrb.sansj.starlib.DataNameNode;
import EDU.bmrb.sansj.starlib.DataValueNode;
import EDU.bmrb.sansj.starlib.StarNode;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class SimpleStarParser {
    public static final String ERR_LEXER = "Lexer error: ";
    public static final String ERR_GLOBAL = "Global blocks are illegal in NMR-STAR";
    public static final String ERR_TOKEN = "Invalid token: ";
    public static final String ERR_EOF = "Premature end of file";
    public static final String ERR_EMPTYLOOP = "Loop with no values";
    public static final String ERR_LOOPNOTAGS = "Loop with no tags";
    public static final String WARN_KEYWORD = "Keyword in value: ";
    public static final String WARN_LOOPCOUNT = "Loop count error";
    public static final String TOKEN = "Token ";
    public static final String NOTINDATABLOCK = " is not allowed outside of a data block";
    public static final String ILLEGAL = " is not allowed inside a";
    public static final String DATA_BLOCK = " data block";
    public static final String SAVEFRAME = " saveframe";
    public static final String LOOP = " loop";
    public static final String NOTVALUE = ": value expected";
    public static final String AVALUE = ": value not expected here";
    public static String newline = System.getProperty("line.separator");
    private StarContentHandler fCh = null;
    private ErrorHandler fEh = null;
    STARLexer fLex = null;
    StringBuffer fComment = null;
    private boolean fNeedValue = false;
    private boolean fParsingTags = false;
    private boolean fParsingValues = false;

    public SimpleStarParser(STARLexer sTARLexer) {
        this.fLex = sTARLexer;
    }

    public SimpleStarParser(STARLexer sTARLexer, StarContentHandler starContentHandler, ErrorHandler errorHandler) {
        this.fLex = sTARLexer;
        this.fCh = starContentHandler;
        this.fEh = errorHandler;
    }

    public StarContentHandler getContentHandler() {
        return this.fCh;
    }

    public void setContentHandler(StarContentHandler starContentHandler) {
        this.fCh = starContentHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.fEh;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.fEh = errorHandler;
    }

    public STARLexer getScanner() {
        return this.fLex;
    }

    public void setScanner(STARLexer sTARLexer) {
        this.fLex = sTARLexer;
    }

    public void parse() {
        this.fComment = new StringBuffer();
        try {
            int n;
            block8: do {
                n = this.fLex.yylex();
                switch (n) {
                    case 0: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_LEXER + this.fLex.yytext());
                        return;
                    }
                    case 14: {
                        this.fComment.append(this.fLex.yytext());
                        this.fComment.append("\n");
                        break;
                    }
                    case 3: {
                        int n2;
                        StarNode starNode = new StarNode(this.fLex.getLine(), this.fLex.getColumn(), this.fLex.yytext().substring(5));
                        if (this.fComment.length() > 0) {
                            n2 = this.fComment.toString().lastIndexOf("\n");
                            if (n2 > -1) {
                                starNode.setPreComment(this.fComment.toString().substring(0, n2));
                            } else {
                                starNode.setPreComment(this.fComment.toString());
                            }
                            this.fComment.setLength(0);
                        }
                        if (this.fCh.startData(starNode)) {
                            return;
                        }
                        if (!this.parseDataBlock()) continue block8;
                        return;
                    }
                    case -1: {
                        int n2;
                        StarNode starNode = new StarNode(this.fLex.getLine(), this.fLex.getColumn());
                        if (this.fComment.length() > 0) {
                            n2 = this.fComment.toString().lastIndexOf("\n");
                            if (n2 > -1) {
                                starNode.setPreComment(this.fComment.toString().substring(0, n2));
                            } else {
                                starNode.setPreComment(this.fComment.toString());
                            }
                            this.fComment.setLength(0);
                        }
                        this.fCh.endData(starNode);
                        return;
                    }
                    default: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), TOKEN + this.fLex.yytext() + NOTINDATABLOCK);
                        return;
                    }
                }
            } while (n != -1);
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
            exception.printStackTrace();
        }
    }

    public boolean parseDataBlock() {
        try {
            int n;
            block8: do {
                n = this.fLex.yylex();
                switch (n) {
                    case 0: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_LEXER + this.fLex.yytext());
                        return true;
                    }
                    case 14: {
                        this.fComment.append(this.fLex.yytext());
                        this.fComment.append("\n");
                        break;
                    }
                    case 5: {
                        int n2;
                        StarNode starNode = new StarNode(this.fLex.getLine(), this.fLex.getColumn(), this.fLex.yytext().substring(5));
                        if (this.fComment.length() > 0) {
                            n2 = this.fComment.toString().lastIndexOf("\n");
                            if (n2 > -1) {
                                starNode.setPreComment(this.fComment.toString().substring(0, n2));
                            } else {
                                starNode.setPreComment(this.fComment.toString());
                            }
                            this.fComment.setLength(0);
                        }
                        if (this.fCh.startSaveFrame(starNode)) {
                            return true;
                        }
                        if (!this.parseSaveFrame()) continue block8;
                        return true;
                    }
                    case -1: {
                        int n2;
                        StarNode starNode = new StarNode(this.fLex.getLine(), this.fLex.getColumn());
                        if (this.fComment.length() > 0) {
                            n2 = this.fComment.toString().lastIndexOf("\n");
                            if (n2 > -1) {
                                starNode.setPreComment(this.fComment.toString().substring(0, n2));
                            } else {
                                starNode.setPreComment(this.fComment.toString());
                            }
                            this.fComment.setLength(0);
                        }
                        this.fCh.endData(starNode);
                        return true;
                    }
                    default: {
                        return true;
                    }
                }
            } while (n != -1);
            return false;
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
            exception.printStackTrace();
            return true;
        }
    }

    public boolean parseSaveFrame() {
        try {
            int n;
            block12: do {
                n = this.fLex.yylex();
                switch (n) {
                    case 0: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_LEXER + this.fLex.yytext());
                        return true;
                    }
                    case 1: {
                        if (!this.fEh.warning(this.fLex.getLine(), this.fLex.getColumn(), WARN_KEYWORD + this.fLex.yytext())) continue block12;
                        return true;
                    }
                    case 14: {
                        this.fComment.append(this.fLex.yytext());
                        this.fComment.append("\n");
                        break;
                    }
                    case 4: {
                        int n2;
                        if (this.fNeedValue) {
                            this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), TOKEN + this.fLex.yytext() + NOTVALUE);
                            return true;
                        }
                        StarNode starNode = new StarNode(this.fLex.getLine(), this.fLex.getColumn());
                        if (this.fComment.length() > 0) {
                            n2 = this.fComment.toString().lastIndexOf("\n");
                            if (n2 > -1) {
                                starNode.setPreComment(this.fComment.toString().substring(0, n2));
                            } else {
                                starNode.setPreComment(this.fComment.toString());
                            }
                            this.fComment.setLength(0);
                        }
                        return this.fCh.endSaveFrame(starNode);
                    }
                    case 6: {
                        int n2;
                        if (this.fNeedValue) {
                            this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), TOKEN + this.fLex.yytext() + NOTVALUE);
                            return true;
                        }
                        StarNode starNode = new StarNode(this.fLex.getLine(), this.fLex.getColumn());
                        if (this.fComment.length() > 0) {
                            n2 = this.fComment.toString().lastIndexOf("\n");
                            if (n2 > -1) {
                                starNode.setPreComment(this.fComment.toString().substring(0, n2));
                            } else {
                                starNode.setPreComment(this.fComment.toString());
                            }
                            this.fComment.setLength(0);
                        }
                        if (this.fCh.startLoop(starNode)) {
                            return true;
                        }
                        if (!this.parseLoop()) continue block12;
                        return true;
                    }
                    case 8: {
                        int n2;
                        if (this.fNeedValue) {
                            this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), TOKEN + this.fLex.yytext() + NOTVALUE);
                            return true;
                        }
                        DataNameNode dataNameNode = new DataNameNode(this.fLex.getLine(), this.fLex.getColumn(), this.fLex.yytext());
                        this.fNeedValue = true;
                        if (this.fComment.length() > 0) {
                            n2 = this.fComment.toString().lastIndexOf("\n");
                            if (n2 > -1) {
                                dataNameNode.setPreComment(this.fComment.toString().substring(0, n2));
                            } else {
                                dataNameNode.setPreComment(this.fComment.toString());
                            }
                            this.fComment.setLength(0);
                        }
                        if (!this.fCh.tag(dataNameNode)) continue block12;
                        return true;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        int n2;
                        if (!this.fNeedValue) {
                            this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), TOKEN + this.fLex.yytext() + AVALUE);
                            return true;
                        }
                        this.fNeedValue = false;
                        DataValueNode dataValueNode = new DataValueNode(this.fLex.getLine(), this.fLex.getColumn());
                        dataValueNode.setDelimType(n);
                        if (this.fComment.length() > 0) {
                            n2 = this.fComment.toString().lastIndexOf("\n");
                            if (n2 > -1) {
                                dataValueNode.setPreComment(this.fComment.toString().substring(0, n2));
                            } else {
                                dataValueNode.setPreComment(this.fComment.toString());
                            }
                            this.fComment.setLength(0);
                        }
                        if (n == 11) {
                            if (this.fLex.getText().indexOf(newline) == 0) {
                                dataValueNode.setValue(this.fLex.getText().substring(newline.length()));
                            } else {
                                dataValueNode.setValue(this.fLex.getText());
                            }
                        } else if (n == 12) {
                            dataValueNode.setValue(this.fLex.yytext().substring(1));
                        } else if (n == 13) {
                            dataValueNode.setValue(this.fLex.yytext());
                        } else {
                            dataValueNode.setValue(this.fLex.getText());
                        }
                        if (!this.fCh.data(dataValueNode)) continue block12;
                        return true;
                    }
                    case -1: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_EOF);
                        return true;
                    }
                    default: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), TOKEN + this.fLex.yytext() + ILLEGAL + SAVEFRAME);
                        return true;
                    }
                }
            } while (n != -1);
            return false;
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
            exception.printStackTrace();
            return true;
        }
    }

    public boolean parseLoop() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        this.fParsingTags = true;
        this.fParsingValues = false;
        try {
            int n7;
            block11: do {
                n7 = this.fLex.yylex();
                switch (n7) {
                    case 0: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_LEXER + this.fLex.yytext());
                        return true;
                    }
                    case 1: {
                        if (!this.fEh.warning(this.fLex.getLine(), this.fLex.getColumn(), WARN_KEYWORD + this.fLex.yytext())) continue block11;
                        return true;
                    }
                    case 14: {
                        this.fComment.append(this.fLex.yytext());
                        this.fComment.append("\n");
                        break;
                    }
                    case 7: {
                        int n8;
                        if (n < 1) {
                            this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_LOOPNOTAGS);
                            return true;
                        }
                        if (n2 < 1) {
                            this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_EMPTYLOOP);
                            return true;
                        }
                        this.fParsingTags = false;
                        this.fParsingValues = false;
                        boolean bl = false;
                        if (n2 % n != 0) {
                            bl = this.fEh.warning(n5 >= 0 ? n5 : this.fLex.getLine(), n6 >= 0 ? n6 : -1, WARN_LOOPCOUNT);
                        }
                        StarNode starNode = new StarNode(this.fLex.getLine(), this.fLex.getColumn());
                        if (this.fComment.length() > 0) {
                            n8 = this.fComment.toString().lastIndexOf("\n");
                            if (n8 > -1) {
                                starNode.setPreComment(this.fComment.toString().substring(0, n8));
                            } else {
                                starNode.setPreComment(this.fComment.toString());
                            }
                            this.fComment.setLength(0);
                        }
                        bl = bl || this.fCh.endLoop(starNode);
                        return bl;
                    }
                    case 8: {
                        int n8;
                        if (!this.fParsingTags) {
                            this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), TOKEN + this.fLex.yytext() + NOTVALUE);
                            return true;
                        }
                        DataNameNode dataNameNode = new DataNameNode(this.fLex.getLine(), this.fLex.getColumn(), this.fLex.yytext());
                        if (this.fComment.length() > 0) {
                            n8 = this.fComment.toString().lastIndexOf("\n");
                            if (n8 > -1) {
                                dataNameNode.setPreComment(this.fComment.toString().substring(0, n8));
                            } else {
                                dataNameNode.setPreComment(this.fComment.toString());
                            }
                            this.fComment.setLength(0);
                        }
                        ++n;
                        if (!this.fCh.tag(dataNameNode)) continue block11;
                        return true;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        int n8;
                        if (this.fParsingTags) {
                            this.fParsingTags = false;
                            this.fParsingValues = true;
                        }
                        if (!this.fParsingValues) {
                            this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), TOKEN + this.fLex.yytext() + AVALUE);
                            return true;
                        }
                        DataValueNode dataValueNode = new DataValueNode(this.fLex.getLine(), this.fLex.getColumn());
                        dataValueNode.setDelimType(n7);
                        if (this.fComment.length() > 0) {
                            n8 = this.fComment.toString().lastIndexOf("\n");
                            if (n8 > -1) {
                                dataValueNode.setPreComment(this.fComment.toString().substring(0, n8));
                            } else {
                                dataValueNode.setPreComment(this.fComment.toString());
                            }
                            this.fComment.setLength(0);
                        }
                        if (n7 == 11) {
                            if (this.fLex.getText().indexOf(newline) == 0) {
                                dataValueNode.setValue(this.fLex.getText().substring(newline.length()));
                            } else {
                                dataValueNode.setValue(this.fLex.getText());
                            }
                        } else if (n7 == 12) {
                            dataValueNode.setValue(this.fLex.yytext().substring(1));
                        } else if (n7 == 13) {
                            dataValueNode.setValue(this.fLex.yytext());
                        } else {
                            dataValueNode.setValue(this.fLex.getText());
                        }
                        ++n2;
                        if (++n3 == n && n4 < this.fLex.getLine() && n5 < 0) {
                            n5 = this.fLex.getLine();
                            n6 = this.fLex.getColumn();
                        }
                        n4 = this.fLex.getLine();
                        if (n3 == n) {
                            n3 = 0;
                        }
                        if (!this.fCh.data(dataValueNode)) continue block11;
                        return true;
                    }
                    case -1: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_EOF);
                        return true;
                    }
                    default: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), TOKEN + this.fLex.yytext() + ILLEGAL + LOOP);
                        return true;
                    }
                }
            } while (n7 != -1);
            return false;
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
            exception.printStackTrace();
            return true;
        }
    }

    private void test_parse() {
        try {
            int n = this.fLex.yylex();
            while (n != -1) {
                System.out.print(STARLexer.TOKEN_TYPES[n] + "(" + this.fLex.getLine() + ":" + this.fLex.getColumn() + "): ");
                switch (n) {
                    case 9: 
                    case 10: 
                    case 11: {
                        System.out.println(this.fLex.getText());
                        break;
                    }
                    default: {
                        System.out.println(this.fLex.yytext());
                    }
                }
                n = this.fLex.yylex();
            }
            System.out.println("End of data_ (EOF)");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        try {
            InputStream inputStream = stringArray.length < 1 ? System.in : new FileInputStream(stringArray[0]);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            STARLexer sTARLexer = new STARLexer(bufferedReader);
            SimpleStarParser simpleStarParser = new SimpleStarParser(sTARLexer);
            simpleStarParser.test_parse();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

