/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.stardb;

import EDU.bmrb.sansj.ContentHandler;
import EDU.bmrb.sansj.DataItemNode;
import EDU.bmrb.sansj.ErrorHandler;
import EDU.bmrb.sansj.STARLexer;
import EDU.bmrb.sansj.SansParser;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class AddComments
implements ContentHandler,
ErrorHandler {
    private static boolean DEBUG = false;
    public static final String PROPKEY = "Stardb.Comment";
    public static final String TAG_COMMENT = "_comment";
    public static final String TAG_SFCAT = "_category";
    public static final String TAG_EVERYSF = "_every_flag";
    public static final String TAG_TAGNAME = "_tagname";
    private static final String EXC_ERR = "Cannot add comments: caught exception. Check error output";
    private ErrorList fErrs = null;
    private Stardb fStar = null;
    private String fComment = null;
    private String fSfcat = null;
    private boolean fEverySf = false;
    private PreparedStatement fSfcatQuery = null;
    private PreparedStatement fSfcatUpdate = null;
    private PreparedStatement fTagQuery = null;
    private PreparedStatement fTagUpdate = null;
    private PreparedStatement fLoopUpdate = null;
    private StringBuffer fBuf = null;
    private boolean fReplace = false;

    public AddComments(Stardb star) {
        this.fStar = star;
        this.fBuf = new StringBuffer();
    }

    public AddComments(Stardb star, ErrorList errs) {
        this.fStar = star;
        this.fErrs = errs;
        this.fBuf = new StringBuffer();
    }

    private boolean init() {
        try {
            this.fSfcatQuery = this.fStar.getPreparedStatement("SELECT ID,PRECOMMENT FROM ENTRYSFS WHERE CATEGORY=? ORDER BY ID");
            this.fSfcatUpdate = this.fStar.getPreparedStatement("UPDATE ENTRYSFS SET PRECOMMENT=? WHERE  ID=?");
            this.fTagQuery = this.fStar.getPreparedStatement("SELECT t.ID,t.PRECOMMENT,t.LOOPID FROM ENTRYTAGS t,ENTRYSFS s WHERE t.NAME=? AND s.CATEGORY=? AND t.SFID=s.ID ORDER BY t.ID");
            this.fTagUpdate = this.fStar.getPreparedStatement("UPDATE ENTRYTAGS SET PRECOMMENT=? WHERE ID=?");
            this.fLoopUpdate = this.fStar.getPreparedStatement("UPDATE ENTRYLOOPS SET PRECOMMENT=? WHERE ID=?");
            return true;
        }
        catch (Exception e) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, -1, -1, -1, EXC_ERR));
            }
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return false;
        }
    }

    private void cleanup() {
        try {
            this.fSfcatQuery.close();
            if (!this.fSfcatUpdate.getConnection().getAutoCommit()) {
                this.fSfcatUpdate.getConnection().commit();
            }
            this.fSfcatUpdate.close();
            this.fTagQuery.close();
            if (!this.fTagUpdate.getConnection().getAutoCommit()) {
                this.fTagUpdate.getConnection().commit();
            }
            this.fTagUpdate.close();
            if (!this.fLoopUpdate.getConnection().getAutoCommit()) {
                this.fLoopUpdate.getConnection().commit();
            }
            this.fLoopUpdate.close();
        }
        catch (Exception e) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, -1, -1, -1, EXC_ERR));
            }
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    public boolean addComments(boolean replace) {
        this.fReplace = replace;
        try {
            this.fBuf.setLength(0);
            this.fBuf.append("Cannot add comments: ");
            String infile = this.fStar.getProperty(PROPKEY);
            if (infile == null) {
                this.fBuf.append(PROPKEY);
                this.fBuf.append(" is not defined in properties file");
                if (this.fErrs != null) {
                    this.fErrs.add(new Error(true, -1, -1, -1, this.fBuf.toString()));
                } else {
                    System.err.println(this.fBuf);
                }
                return false;
            }
            if (!this.fStar.isConnected()) {
                this.fStar.connect(false);
            }
            if (!this.fStar.hasDictionary()) {
                this.fBuf.append("dictionary is not loaded");
                if (this.fErrs != null) {
                    this.fErrs.add(new Error(true, -1, -1, -1, this.fBuf.toString()));
                } else {
                    System.err.println(this.fBuf);
                }
                return false;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(infile)));
            STARLexer lex = new STARLexer(in);
            SansParser parser = new SansParser(lex, this, this);
            parser.parse();
            return true;
        }
        catch (Exception e) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, -1, -1, -1, EXC_ERR));
            }
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return false;
        }
    }

    public boolean addSaveframeComment() {
        try {
            if (DEBUG) {
                System.err.println("addSaveframeComment()");
            }
            if (!this.fSfcatUpdate.getConnection().getAutoCommit()) {
                this.fSfcatUpdate.getConnection().setAutoCommit(true);
            }
            int count = 0;
            String str = null;
            this.fSfcatQuery.setString(1, this.fSfcat);
            ResultSet rs = this.fSfcatQuery.executeQuery();
            while (rs.next()) {
                ++count;
                this.fBuf.setLength(0);
                this.fSfcatUpdate.setInt(2, rs.getInt(1));
                str = rs.getString(2);
                if (rs.wasNull()) {
                    this.fSfcatUpdate.setString(1, this.fComment);
                } else {
                    this.fBuf.append(this.fComment);
                    if (!this.fReplace) {
                        this.fBuf.append("\n");
                        this.fBuf.append(str);
                    }
                    this.fSfcatUpdate.setString(1, this.fBuf.toString());
                }
                if (DEBUG) {
                    System.err.println(this.fBuf + "to saveframe " + rs.getInt(1));
                }
                this.fSfcatUpdate.executeUpdate();
                if (!this.fSfcatUpdate.getConnection().getAutoCommit()) {
                    this.fSfcatUpdate.getConnection().commit();
                }
                if (this.fEverySf || count <= 0) continue;
            }
            rs.close();
            this.fSfcatUpdate.getConnection().setAutoCommit(false);
            if (count < 1) {
                if (this.fErrs != null) {
                    this.fBuf.setLength(0);
                    this.fBuf.append("Cannot add comment to saveframe(s): no SF category ");
                    this.fBuf.append(this.fSfcat);
                    this.fErrs.add(new Error(true, -1, -1, -1, this.fBuf.toString()));
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, -1, -1, -1, EXC_ERR));
            }
            System.err.print("Error adding comment ");
            System.err.print(this.fComment);
            System.err.print(" to ");
            System.err.print(this.fSfcat);
            System.err.println(" saveframe(s)");
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return false;
        }
    }

    public boolean addTagComment(String tag) {
        try {
            int count = 0;
            int loopid = -1;
            String str = null;
            this.fTagQuery.setString(1, tag);
            this.fTagQuery.setString(2, this.fSfcat);
            ResultSet rs = this.fTagQuery.executeQuery();
            while (rs.next()) {
                PreparedStatement stat;
                ++count;
                loopid = rs.getInt(3);
                if (rs.wasNull()) {
                    stat = this.fTagUpdate;
                    stat.setInt(2, rs.getInt(1));
                } else {
                    stat = this.fLoopUpdate;
                    stat.setInt(2, loopid);
                }
                str = rs.getString(2);
                this.fBuf.setLength(0);
                if (rs.wasNull()) {
                    stat.setString(1, this.fComment);
                } else {
                    this.fBuf.append(this.fComment);
                    if (!this.fReplace) {
                        this.fBuf.append("\n");
                        this.fBuf.append(str);
                    }
                    stat.setString(1, this.fBuf.toString());
                }
                stat.executeUpdate();
                if (!stat.getConnection().getAutoCommit()) {
                    stat.getConnection().commit();
                }
                if (this.fEverySf || count <= 0) continue;
            }
            rs.close();
            if (count < 1) {
                if (this.fErrs != null) {
                    this.fBuf.setLength(0);
                    this.fBuf.append("Cannot add comment to ");
                    this.fBuf.append(this.fSfcat);
                    this.fBuf.append(", ");
                    this.fBuf.append(tag);
                    this.fBuf.append(" tag(s)");
                    this.fErrs.add(new Error(true, -1, -1, -1, this.fBuf.toString()));
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.fErrs.add(new Error(true, -1, -1, -1, EXC_ERR));
            System.err.print("Error adding comment ");
            System.err.print(this.fComment);
            System.err.print(" to ");
            System.err.print(tag);
            System.err.print(" tag in ");
            System.err.print(this.fSfcat);
            System.err.println(" saveframe(s)");
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return false;
        }
    }

    public void error(int line, int col, String msg) {
        this.fBuf.setLength(0);
        this.fBuf.append("Error in comment file at line ");
        this.fBuf.append(line);
        this.fBuf.append(", col ");
        this.fBuf.append(col);
        this.fBuf.append(": ");
        this.fBuf.append(msg);
        if (this.fErrs != null) {
            this.fErrs.add(new Error(true, -1, -1, line, this.fBuf.toString()));
        } else {
            System.err.println(this.fBuf.toString());
        }
    }

    public boolean warning(int line, int col, String msg) {
        this.fBuf.setLength(0);
        this.fBuf.append("Problem in comment file at line ");
        this.fBuf.append(line);
        this.fBuf.append(", col ");
        this.fBuf.append(col);
        this.fBuf.append(": ");
        this.fBuf.append(msg);
        if (this.fErrs != null) {
            this.fErrs.add(new Error(false, -1, -1, line, this.fBuf.toString()));
        } else {
            System.err.println(this.fBuf.toString());
        }
        return false;
    }

    public boolean comment(int line, String str) {
        return false;
    }

    public boolean startData(int line, String str) {
        return !this.init();
    }

    public void endData(int line, String str) {
        this.cleanup();
    }

    public boolean startSaveFrame(int line, String str) {
        return false;
    }

    public boolean endSaveFrame(int line, String str) {
        return false;
    }

    public boolean startLoop(int line) {
        return false;
    }

    public boolean endLoop(int line) {
        return false;
    }

    public boolean data(DataItemNode node) {
        if (TAG_COMMENT.equals(node.getName())) {
            this.fComment = node.getValue();
        } else if (TAG_SFCAT.equals(node.getName())) {
            this.fSfcat = node.getValue();
        } else if (TAG_EVERYSF.equals(node.getName())) {
            this.fEverySf = "Y".equals(node.getValue().toUpperCase());
        } else if (TAG_TAGNAME.equals(node.getName())) {
            if (".".equals(node.getValue())) {
                this.addSaveframeComment();
            } else {
                this.addTagComment(node.getValue());
            }
        }
        return false;
    }

    public static void main(String[] args) {
        long now = System.currentTimeMillis();
        Star_DB star = args.length > 0 ? new Star_DB(args[0]) : new Star_DB();
        star.connect(false);
        AddComments ac = new AddComments(star);
        if (!ac.addComments(false)) {
            System.err.println("Cannot add comments");
        }
        star.disconnect();
        System.out.println("Elapsed: " + (System.currentTimeMillis() - now));
    }
}

