/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.stardb;

import EDU.bmrb.sansj.ErrorHandler;
import EDU.bmrb.sansj.STARLexer;
import EDU.bmrb.sansj.SimpleStarParser;
import EDU.bmrb.sansj.StarContentHandler;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.stardb.UnparseToStarlib;
import EDU.bmrb.starlibj.BlockNode;
import EDU.bmrb.starlibj.DataItemNode;
import EDU.bmrb.starlibj.DataLoopNameListNode;
import EDU.bmrb.starlibj.DataLoopNode;
import EDU.bmrb.starlibj.DataNameNode;
import EDU.bmrb.starlibj.DataValueNode;
import EDU.bmrb.starlibj.LoopNameListNode;
import EDU.bmrb.starlibj.LoopRowNode;
import EDU.bmrb.starlibj.LoopTableNode;
import EDU.bmrb.starlibj.SaveFrameNode;
import EDU.bmrb.starlibj.StarNode;
import EDU.bmrb.starlibj.StarUnparser;
import EDU.bmrb.starlibj.VectorCheckType;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import gnu.getopt.Getopt;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class AddDataTags
implements ErrorHandler,
StarContentHandler {
    private static final boolean DEBUG = false;
    private boolean fStripSfIds = true;
    private ErrorList fErrs = null;
    private BlockNode fTree = null;
    private Stardb fStar = null;
    private StringBuffer fBuf = null;
    private VectorCheckType fHits = null;
    private SaveFrameNode fSf = null;
    private boolean fInLoop = false;
    private boolean fFirstTag = false;
    private boolean fFirstVal = false;
    private int fLoopCol = 0;
    private DataItemNode fDataTag = null;
    private LoopNameListNode fLoopNames = null;
    private LoopRowNode fLoopRow = null;
    private LoopTableNode fLoopVals = null;
    private boolean fAddValue = false;
    private int fRowIndexTagIdx = -1;

    public AddDataTags(BlockNode sfn, Stardb star) {
        this.fTree = sfn;
        this.fStar = star;
        this.fBuf = new StringBuffer();
    }

    public AddDataTags(BlockNode sfn, Stardb star, boolean strip_sfids) {
        this.fTree = sfn;
        this.fStar = star;
        this.fStripSfIds = strip_sfids;
        this.fBuf = new StringBuffer();
    }

    public AddDataTags(BlockNode sfn, Stardb star, ErrorList errs) {
        this.fTree = sfn;
        this.fStar = star;
        this.fErrs = errs;
        this.fBuf = new StringBuffer();
    }

    public void setErrorList(ErrorList errs) {
        this.fErrs = errs;
    }

    public void parse(Reader in) {
        STARLexer lex = new STARLexer(in);
        SimpleStarParser parser = new SimpleStarParser(lex, this, this);
        parser.parse();
    }

    public void error(int param, int param1, String str) {
        this.fBuf.setLength(0);
        this.fBuf.append("Parse error in line ");
        this.fBuf.append(param);
        this.fBuf.append(", col ");
        this.fBuf.append(param1);
        this.fBuf.append(": ");
        this.fBuf.append(str);
        if (this.fErrs != null) {
            this.fErrs.clear();
            this.fErrs.add(new Error(true, -1, -1, param, this.fBuf.toString()));
        } else {
            System.err.println(this.fBuf);
        }
    }

    public boolean warning(int param, int param1, String str) {
        this.fBuf.setLength(0);
        this.fBuf.append("Parse warning in line ");
        this.fBuf.append(param);
        this.fBuf.append(", col ");
        this.fBuf.append(param1);
        this.fBuf.append(": ");
        this.fBuf.append(str);
        if (this.fErrs != null) {
            this.fErrs.add(new Error(false, -1, -1, param, this.fBuf.toString()));
        } else {
            System.err.println(this.fBuf);
        }
        return false;
    }

    public boolean startData(EDU.bmrb.sansj.starlib.StarNode starNode) {
        return false;
    }

    public void endData(EDU.bmrb.sansj.starlib.StarNode starNode) {
    }

    public boolean startSaveFrame(EDU.bmrb.sansj.starlib.StarNode starNode) {
        this.fBuf.setLength(0);
        this.fBuf.append("save_");
        this.fBuf.append(starNode.getValue());
        this.fHits = this.fTree.searchForTypeByName(SaveFrameNode.class, this.fBuf.toString());
        if (this.fHits.size() > 1) {
            this.fBuf.setLength(0);
            this.fBuf.append("Found ");
            this.fBuf.append(this.fHits.size());
            this.fBuf.append(' ');
            this.fBuf.append(starNode.getValue());
            this.fBuf.append(" saveframes!");
            if (this.fErrs != null) {
                this.fErrs.add(new Error(false, -1, -1, starNode.getLineNum(), this.fBuf.toString()));
            } else {
                System.err.println(this.fBuf);
            }
        } else if (this.fHits.size() == 1) {
            this.fSf = (SaveFrameNode)this.fHits.elementAt(0);
        }
        return false;
    }

    public boolean endSaveFrame(EDU.bmrb.sansj.starlib.StarNode starNode) {
        this.fSf = null;
        return false;
    }

    public boolean startLoop(EDU.bmrb.sansj.starlib.StarNode starNode) {
        this.fInLoop = true;
        this.fFirstTag = true;
        this.fFirstVal = true;
        this.fLoopCol = 0;
        return false;
    }

    public boolean endLoop(EDU.bmrb.sansj.starlib.StarNode starNode) {
        this.fInLoop = false;
        this.fRowIndexTagIdx = -1;
        if (this.fAddValue) {
            this.fAddValue = false;
            this.insertLoop();
        }
        return false;
    }

    public boolean tag(EDU.bmrb.sansj.starlib.DataNameNode dataNameNode) {
        if (this.fSf == null) {
            return false;
        }
        this.fAddValue = false;
        this.fHits = !this.fInLoop ? this.fSf.searchForTypeByName(DataItemNode.class, dataNameNode.getValue()) : this.fSf.searchForTypeByName(DataNameNode.class, dataNameNode.getValue());
        if (this.fHits.size() > 1) {
            this.fBuf.setLength(0);
            this.fBuf.append("Found ");
            this.fBuf.append(this.fHits.size());
            this.fBuf.append(' ');
            this.fBuf.append(dataNameNode.getValue());
            this.fBuf.append(" tags!");
            if (this.fErrs != null) {
                this.fErrs.add(new Error(false, -1, -1, dataNameNode.getLineNum(), this.fBuf.toString()));
            } else {
                System.err.println(this.fBuf);
            }
        } else if (this.fHits.size() < 1 && this.isDataTag(dataNameNode)) {
            this.fAddValue = true;
            if (!this.fInLoop) {
                this.fDataTag = new DataItemNode(dataNameNode.getValue(), ".");
                this.fDataTag.setLineNum(dataNameNode.getLineNum());
            } else {
                if (this.fFirstTag) {
                    this.fLoopNames = new LoopNameListNode();
                }
                this.fLoopNames.addElement(new DataNameNode(dataNameNode.getValue()));
            }
        }
        if (this.fInLoop && this.fFirstTag) {
            this.fFirstTag = false;
        }
        return false;
    }

    public boolean data(EDU.bmrb.sansj.starlib.DataValueNode dataValueNode) {
        if (this.fAddValue) {
            if (this.fInLoop) {
                ++this.fLoopCol;
                if (this.fFirstVal) {
                    this.fFirstVal = false;
                    this.fLoopRow = new LoopRowNode();
                    this.fLoopVals = new LoopTableNode(true);
                }
                if (this.fLoopCol == this.fLoopNames.size()) {
                    this.fLoopRow.addElement(new DataValueNode(dataValueNode.getValue(), UnparseToStarlib.getDelim(dataValueNode.getDelimType())));
                    this.fLoopVals.addElement(this.fLoopRow);
                    this.fLoopRow = new LoopRowNode();
                    this.fLoopCol = 0;
                } else {
                    this.fLoopRow.addElement(new DataValueNode(dataValueNode.getValue(), UnparseToStarlib.getDelim(dataValueNode.getDelimType())));
                }
            } else {
                this.fDataTag.setValue(dataValueNode.getValue(), UnparseToStarlib.getDelim(dataValueNode.getDelimType()));
                this.insertFreeTag();
                this.fAddValue = false;
            }
        }
        return false;
    }

    public boolean isDataTag(EDU.bmrb.sansj.starlib.DataNameNode tag) {
        try {
            this.fBuf.setLength(0);
            if (this.fInLoop) {
                int pos = tag.getValue().indexOf(46);
                if (pos < 0) {
                    if (this.fErrs != null) {
                        this.fErrs.add(new Error(false, -1, -1, tag.getLineNum(), "Tag without category: " + tag.getValue()));
                    } else {
                        System.err.println("Tag without category: " + tag.getValue() + " in line " + tag.getLineNum());
                    }
                }
                this.fBuf.append("SELECT DISTINCT t.METADATA FROM TAGS t,ENTRYSFS s WHERE s.NAME='");
                this.fBuf.append(this.fSf.getLabel().substring(5));
                this.fBuf.append("' AND t.TAGNAME LIKE '");
                this.fBuf.append(tag.getValue().substring(0, pos + 1));
                this.fBuf.append("%' AND s.CATEGORY=t.SFCAT");
            } else {
                this.fBuf.append("SELECT t.METADATA FROM TAGS t,ENTRYSFS s WHERE s.NAME='");
                this.fBuf.append(this.fSf.getLabel().substring(5));
                this.fBuf.append("' AND t.TAGNAME='");
                this.fBuf.append(tag.getValue());
                this.fBuf.append("' AND s.CATEGORY=t.SFCAT");
            }
            Statement query = this.fStar.getQueryStatement();
            ResultSet rs = query.executeQuery(this.fBuf.toString());
            if (!rs.next()) {
                this.fBuf.setLength(0);
                this.fBuf.append("Tag not in dictionary: ");
                this.fBuf.append(tag.getValue());
                if (this.fErrs != null) {
                    this.fErrs.add(new Error(false, -1, -1, tag.getLineNum(), this.fBuf.toString()));
                } else {
                    this.fBuf.append(" in line ");
                    this.fBuf.append(tag.getLineNum());
                    System.err.println(this.fBuf);
                }
                rs.close();
                query.close();
                return false;
            }
            boolean rc = false;
            if (rs.getString(1).equals("N")) {
                rc = true;
            }
            rs.close();
            query.close();
            return rc;
        }
        catch (SQLException e) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(false, -1, -1, tag.getLineNum(), "DB exception, check error output"));
            }
            System.err.print("DB exception looking up tag ");
            System.err.print(tag.getValue());
            System.err.print(" (line ");
            System.err.print(tag.getLineNum());
            System.err.println(") in the dictionary");
            System.err.println(e);
            e.printStackTrace();
            return false;
        }
    }

    public void insertFreeTag() {
        try {
            this.fBuf.setLength(0);
            this.fBuf.append("SELECT t.SEQ FROM TAGS t,ENTRYSFS s WHERE s.NAME='");
            this.fBuf.append(this.fSf.getLabel().substring(5));
            this.fBuf.append("' AND t.TAGNAME='");
            this.fBuf.append(this.fDataTag.getLabel());
            this.fBuf.append("' AND s.CATEGORY=t.SFCAT");
            Statement query = this.fStar.getQueryStatement();
            ResultSet rs = query.executeQuery(this.fBuf.toString());
            if (!rs.next()) {
                this.fBuf.setLength(0);
                this.fBuf.append("Tag not in dictionary: ");
                this.fBuf.append(this.fDataTag.getValue());
                if (this.fErrs != null) {
                    this.fErrs.add(new Error(false, -1, -1, this.fDataTag.getLineNum(), this.fBuf.toString()));
                } else {
                    this.fBuf.append(" in line ");
                    this.fBuf.append(this.fDataTag.getLineNum());
                    System.err.println(this.fBuf);
                }
                rs.close();
                query.close();
                return;
            }
            int seq = rs.getInt(1);
            this.fBuf.setLength(0);
            this.fBuf.append("SELECT t.TAGNAME FROM TAGS t,ENTRYSFS s WHERE s.NAME='");
            this.fBuf.append(this.fSf.getLabel().substring(5));
            this.fBuf.append("' AND t.SEQ<");
            this.fBuf.append(seq);
            this.fBuf.append(" AND s.CATEGORY=t.SFCAT ORDER BY t.SEQ DESC");
            rs = query.executeQuery(this.fBuf.toString());
            while (rs.next()) {
                int pos = this.insertPosition(rs.getString(1));
                if (pos <= 0) continue;
                this.fSf.insertElementAt(this.fDataTag, pos);
                rs.close();
                query.close();
                return;
            }
            this.fSf.insertElementAt(this.fDataTag, 0);
            rs.close();
            query.close();
        }
        catch (SQLException e) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(false, -1, -1, this.fDataTag.getLineNum(), "DB exception, check error output"));
            }
            System.err.print("DB exception looking up sequence for tag ");
            System.err.print(this.fDataTag.getLabel());
            System.err.print(" (line ");
            System.err.print(this.fDataTag.getLineNum());
            System.err.println(") in the dictionary");
            System.err.println(e);
            e.printStackTrace();
        }
    }

    public void insertLoop() {
        try {
            int j;
            int i;
            int idx;
            int pos = -1;
            for (idx = 0; idx < this.fLoopNames.size() && (pos = this.fLoopNames.elementAt(idx).getLabel().indexOf(46)) < 0; ++idx) {
            }
            if (pos < 0) {
                System.err.println("Cannot insert loop " + this.fLoopNames.elementAt(0).getLabel());
                return;
            }
            LoopNameListNode properNames = new LoopNameListNode();
            this.fBuf.setLength(0);
            this.fBuf.append("SELECT SEQ,TAGNAME,ROWIDXFLAG,DELETEFLAG,SFIDFLAG FROM TAGS WHERE TAGNAME LIKE '" + this.fLoopNames.elementAt(idx).getLabel().substring(0, pos + 1) + "%' AND DELETEFLAG<>'Y' ORDER BY SEQ");
            Statement query = this.fStar.getQueryStatement();
            int[] indexmap = new int[this.fLoopNames.size()];
            for (i = 0; i < indexmap.length; ++i) {
                indexmap[i] = -1;
            }
            int seq = -1;
            i = 0;
            ResultSet rs = query.executeQuery(this.fBuf.toString());
            while (rs.next()) {
                if (seq < 0) {
                    seq = rs.getInt(1);
                }
                rs.getString(3);
                if (!rs.wasNull() && rs.getString(3).trim().toUpperCase().charAt(0) == 'Y') {
                    this.fRowIndexTagIdx = i;
                }
                rs.getString(4);
                if (!rs.wasNull() && rs.getString(4).trim().toUpperCase().charAt(0) != 'Y') {
                    rs.getString(5);
                    if (!rs.wasNull() && rs.getString(5).trim().toUpperCase().charAt(0) != 'Y') {
                        properNames.addElement(new DataNameNode(rs.getString(2)));
                    }
                }
                block5: for (j = 0; j < this.fLoopNames.size(); ++j) {
                    if (!rs.getString(2).equals(this.fLoopNames.elementAt(j).getLabel())) continue;
                    rs.getString(4);
                    if (!rs.wasNull() && rs.getString(4).trim().toUpperCase().charAt(0) == 'Y') {
                        indexmap[j] = -2;
                        continue;
                    }
                    rs.getString(5);
                    if (!rs.wasNull() && rs.getString(5).trim().toUpperCase().charAt(0) == 'Y') {
                        indexmap[j] = -3;
                        continue;
                    }
                    for (int k = 0; k < properNames.size(); ++k) {
                        if (!properNames.elementAt(k).getLabel().equals(this.fLoopNames.elementAt(j).getLabel())) continue;
                        indexmap[j] = k;
                        continue block5;
                    }
                }
                ++i;
            }
            for (i = 0; i < indexmap.length; ++i) {
                if (indexmap[i] != -1) continue;
                properNames.insertElementAt(this.fLoopNames.elementAt(i), 0);
                for (j = 0; j < indexmap.length; ++j) {
                    if (indexmap[j] < 0) continue;
                    int n = j;
                    indexmap[n] = indexmap[n] + 1;
                }
                indexmap[i] = 0;
            }
            LoopTableNode properLoopVals = new LoopTableNode(true);
            for (i = 0; i < this.fLoopVals.size(); ++i) {
                LoopRowNode oldRow = this.fLoopVals.elementAt(i);
                LoopRowNode newRow = new LoopRowNode();
                for (int j2 = 0; j2 < properNames.size(); ++j2) {
                    boolean found = false;
                    for (int k = 0; k < indexmap.length; ++k) {
                        if (indexmap[k] != j2) continue;
                        newRow.addElement(oldRow.elementAt(k));
                        found = true;
                        break;
                    }
                    if (found) continue;
                    newRow.addElement(new DataValueNode("?"));
                }
                properLoopVals.addElement(newRow);
            }
            DataLoopNameListNode names = new DataLoopNameListNode();
            names.addElement(properNames);
            DataLoopNode loop = new DataLoopNode(names, properLoopVals);
            this.fBuf.setLength(0);
            this.fBuf.append("SELECT t.TAGNAME FROM TAGS t,ENTRYSFS s WHERE s.NAME='");
            this.fBuf.append(this.fSf.getLabel().substring(5));
            this.fBuf.append("' AND t.SEQ<");
            this.fBuf.append(seq);
            this.fBuf.append(" AND s.CATEGORY=t.SFCAT ORDER BY t.SEQ DESC");
            rs = query.executeQuery(this.fBuf.toString());
            while (rs.next()) {
                pos = this.insertPosition(rs.getString(1));
                if (pos <= 0) continue;
                this.fSf.insertElementAt(loop, pos);
                rs.close();
                query.close();
                return;
            }
            this.fSf.insertElementAt(loop, 0);
            rs.close();
            query.close();
        }
        catch (SQLException e) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(false, -1, -1, this.fDataTag.getLineNum(), "DB exception, check error output"));
            }
            System.err.print("DB exception looking up sequence for tag ");
            System.err.print(this.fDataTag.getLabel());
            System.err.print(" (line ");
            System.err.print(this.fDataTag.getLineNum());
            System.err.println(") in the dictionary");
            System.err.println(e);
            e.printStackTrace();
        }
    }

    public int insertPosition(String tag) {
        int rc = 0;
        this.fHits = this.fSf.searchByName(tag);
        if (this.fHits.size() > 0) {
            if (this.fHits.elementAt(0) instanceof DataItemNode) {
                rc = this.fSf.indexOf(this.fHits.elementAt(0));
            } else {
                StarNode names = ((StarNode)this.fHits.elementAt(0)).getParent();
                StarNode tags = names.getParent();
                StarNode loop = tags.getParent();
                rc = this.fSf.indexOf(loop);
            }
            ++rc;
        }
        return rc;
    }

    public static void usage() {
        System.out.println("Usage: java EDU.bmrb.stardb.AddDataTags [-h] [-c FILE] [-i FILE] [-o FILE] [-r] [-s]");
        System.out.println("   -h: print this usage summary");
        System.out.println("   -c FILE: use config file FILE instead of ~/validator.properties");
        System.out.println("   -i FILE: input file (default: stdin)");
        System.out.println("   -o FILE: output file (default: stdout)");
        System.out.println("   -r: \"release\" output: do not strip Sf_ID tags");
        System.out.println("   -s: sort saveframes and tags by dictionary sequence");
    }

    public static void main(String[] args) {
        long now = System.currentTimeMillis();
        try {
            int opt;
            String conffile = null;
            String infile = null;
            String outfile = null;
            boolean strip_sfids = true;
            boolean sort = false;
            Getopt g = new Getopt("Unparse", args, "c:i:o:hrs");
            block9: while ((opt = g.getopt()) != -1) {
                switch (opt) {
                    case 99: {
                        conffile = g.getOptarg();
                        continue block9;
                    }
                    case 105: {
                        infile = g.getOptarg();
                        continue block9;
                    }
                    case 111: {
                        outfile = g.getOptarg();
                        continue block9;
                    }
                    case 114: {
                        strip_sfids = false;
                        continue block9;
                    }
                    case 115: {
                        sort = true;
                        continue block9;
                    }
                }
                AddDataTags.usage();
                return;
            }
            Star_DB star = conffile == null ? new Star_DB() : new Star_DB(conffile);
            star.setSortTags(sort);
            star.connect(false);
            System.err.println("DB open: " + (System.currentTimeMillis() - now));
            now = System.currentTimeMillis();
            BlockNode data = UnparseToStarlib.createDataNode(star, strip_sfids);
            AddDataTags adt = new AddDataTags(data, star);
            InputStreamReader in = infile == null ? new InputStreamReader(System.in) : new FileReader(infile);
            adt.parse(in);
            star.disconnect();
            StarUnparser unp = outfile == null ? new StarUnparser(System.out) : new StarUnparser(new FileOutputStream(outfile));
            unp.writeOut(data, 0);
            System.err.println("Done: " + (System.currentTimeMillis() - now));
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }
}

