/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.stardb;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.stardb.sdbException;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.Severity;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class AddDictionaryInfo {
    private static final boolean DEBUG = false;
    public static final String VERSION_TAG = "_Entry.NMR_STAR_version";

    public static void addDictionaryInfo(Stardb star) throws sdbException, SQLException {
        if (!star.isConnected()) {
            star.connect(false);
        }
        if (!star.hasDictionary()) {
            throw new sdbException("Dictionary is not loaded");
        }
        StringBuffer buf = new StringBuffer();
        Statement query = star.getQueryStatement();
        ResultSet rs = query.executeQuery("SELECT VAL FROM ENTRYVALS");
        ResultSetMetaData md = rs.getMetaData();
        star.setValueSize(md.getColumnDisplaySize(1));
        md = null;
        PreparedStatement pstat = star.getPreparedStatement("UPDATE ENTRYSFS SET CATEGORY=? WHERE ID=?");
        buf.append("SELECT TAGS.SFCAT,ENTRYSFS.ID FROM ENTRYSFS,TAGS,ENTRYTAGS ");
        buf.append("WHERE TAGS.SFCATFLAG='Y' AND ENTRYTAGS.NAME=TAGS.TAGNAME ");
        buf.append("AND ENTRYSFS.ID=ENTRYTAGS.SFID");
        rs = query.executeQuery(buf.toString());
        boolean flag = false;
        while (rs.next()) {
            flag = true;
            pstat.setString(1, rs.getString(1));
            pstat.setInt(2, rs.getInt(2));
            pstat.executeUpdate();
        }
        if (!flag) {
            throw new sdbException("No valid saveframes");
        }
        pstat.getConnection().commit();
        pstat.close();
        Statement stat = star.getStatement();
        if (star.isHSQLDB() || star.isOracle()) {
            stat.executeUpdate("UPDATE ENTRYSFS SET SEQ=(SELECT SFCATS.ID FROM SFCATS WHERE SFCATS.SFCAT=ENTRYSFS.CATEGORY)");
            stat.getConnection().commit();
        } else {
            rs = query.executeQuery("SELECT d.ID,e.ID FROM SFCATS d,ENTRYSFS e WHERE d.SFCAT=e.CATEGORY");
            pstat = star.getPreparedStatement("UPDATE ENTRYSFS SET SEQ=? WHERE ID=?");
            while (rs.next()) {
                pstat.setInt(1, rs.getInt(1));
                pstat.setInt(2, rs.getInt(2));
                pstat.executeUpdate();
            }
            pstat.getConnection().commit();
            pstat.close();
        }
        rs = query.executeQuery("SELECT t.SEQ,e.ID FROM ENTRYSFS s,ENTRYTAGS e,TAGS t WHERE t.SEQ IS NOT NULL AND t.TAGNAME=e.NAME AND t.SFCAT=s.CATEGORY AND e.SFID=s.ID");
        pstat = star.getPreparedStatement("UPDATE ENTRYTAGS SET SEQ=? WHERE ID=?");
        while (rs.next()) {
            pstat.setInt(1, rs.getInt(1));
            pstat.setInt(2, rs.getInt(2));
            pstat.executeUpdate();
        }
        pstat.getConnection().commit();
        pstat.close();
        if (star.isHSQLDB() || star.isOracle()) {
            stat.executeUpdate("UPDATE ENTRYVALS SET SEQ=(SELECT ENTRYTAGS.SEQ FROM ENTRYTAGS WHERE ENTRYVALS.TAGID=ENTRYTAGS.ID)");
            stat.getConnection().commit();
        } else {
            rs = query.executeQuery("SELECT SEQ,ID FROM ENTRYTAGS WHERE SEQ IS NOT NULL ORDER BY ID");
            pstat = star.getPreparedStatement("UPDATE ENTRYVALS SET SEQ=? WHERE TAGID=?");
            while (rs.next()) {
                pstat.setInt(1, rs.getInt(1));
                pstat.setInt(2, rs.getInt(2));
                pstat.executeUpdate();
            }
            pstat.getConnection().commit();
            pstat.close();
        }
        stat.getConnection().commit();
        if (star.isHSQLDB()) {
            stat.executeUpdate("CHECKPOINT");
        }
        stat.getConnection().commit();
        stat.close();
    }

    public static boolean checkVersion(Stardb star, ErrorList errs) {
        try {
            Statement query = star.getQueryStatement();
            ResultSet rs = query.executeQuery("SELECT VERSION FROM INFO");
            rs.next();
            String dict = rs.getString(1);
            String entry = null;
            int line = -1;
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT v.VAL,v.LINE FROM ENTRYVALS v,ENTRYTAGS t WHERE t.NAME='");
            sql.append(VERSION_TAG);
            sql.append("' AND v.TAGID=t.ID");
            rs = query.executeQuery(sql.toString());
            if (rs.next()) {
                entry = rs.getString(1);
                if (rs.wasNull()) {
                    entry = null;
                }
                line = rs.getInt(2);
                if (rs.wasNull()) {
                    line = -1;
                }
            }
            rs.close();
            query.close();
            if (entry == null || entry.equals("?")) {
                if (errs != null) {
                    errs.add(new Error(Severity.ERR, -1, -1, line, "No NMR-STAR version in the entry"));
                }
                return false;
            }
            if (!entry.equals(dict)) {
                if (errs != null) {
                    errs.add(new Error(Severity.WARN, -1, -1, line, "NMR-STAR version in the entry (%s) does not match dictionary (%s)\n", entry, dict));
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            if (errs != null) {
                errs.add(new Error(Severity.CRIT, -1, -1, -1, "Exception while checking NMR-STAR version"));
            }
            System.err.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static void usage() {
        System.out.println("Usage: java EDU.bmrb.stardb.AddDictionaryInfo [CONFFILE] [-h]");
        System.out.print(" CONFFILE: config file, default: ~/");
        System.out.println("stardb.properties");
        System.out.println(" -h: print this message and exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        Stardb star = null;
        try {
            if (args.length > 0) {
                if (args[0].toUpperCase().equals("-H")) {
                    AddDictionaryInfo.usage();
                    return;
                }
                star = new Star_DB(args[0]);
            } else {
                star = new Star_DB();
            }
            AddDictionaryInfo.addDictionaryInfo(star);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (star != null) {
                star.close();
            }
        }
        System.out.println("Elapsed: " + (System.currentTimeMillis() - start));
    }
}

