/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.stardb;

import EDU.bmrb.stardb.CreateSchema;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.stardb.Tag;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class CreateTemplate {
    private static final boolean DEBUG = false;
    private ErrorList fErrs = null;
    private Stardb fStar = null;
    private StringBuffer fBuf = null;
    private int fLine = 1;
    private int fLoopId = 0;
    private boolean fInLoop = false;

    public CreateTemplate(Stardb star) throws Exception {
        this.fStar = star;
        if (!star.hasDictionary()) {
            throw new Exception("No dictionary");
        }
        this.fBuf = new StringBuffer();
    }

    public CreateTemplate(Stardb star, ErrorList errs) throws Exception {
        this.fStar = star;
        if (!star.hasDictionary()) {
            throw new Exception("No dictionary");
        }
        this.fErrs = errs;
        this.fBuf = new StringBuffer();
    }

    public void setStartLine(int num) {
        this.fLine = num;
    }

    public boolean createTemplate() {
        if (!CreateSchema.createSchema(this.fStar.getConnection(), this.fStar.getProperty("DB.schema"), null, this.fErrs)) {
            return false;
        }
        if (!this.addDataBlock("template")) {
            return false;
        }
        List sfcats = this.getSFCategories();
        if (sfcats == null) {
            return false;
        }
        StringBuffer name = new StringBuffer();
        for (int i = 0; i < sfcats.size(); ++i) {
            Tag sfcat = (Tag)sfcats.get(i);
            name.setLength(0);
            name.append(sfcat.getName());
            name.append("_one");
            int sfid = this.addSaveFrame(name.toString(), sfcat.getName(), sfcat.getSeq());
            if (sfid < 0) {
                return false;
            }
            if (this.addTags(name.toString(), sfcat.getName(), sfid)) continue;
            return false;
        }
        sfcats.clear();
        sfcats = null;
        return true;
    }

    public boolean addDataBlock(String name) {
        try {
            this.fBuf.setLength(0);
            this.fBuf.append("INSERT INTO ENTRYINFO (NAME, LINE, PRECOMMENT) VALUES ('");
            this.fBuf.append(name);
            this.fBuf.append("', ");
            this.fBuf.append(this.fLine);
            this.fBuf.append(", '# Blank NMR-STAR file.\n");
            this.fBuf.append("# Contains all mandatory tags  and saveframe categories.\n");
            this.fBuf.append("# Most values are set to ? (question mark), exceptions are\n");
            this.fBuf.append("# .Sf_category tags: value is saveframe category name\n");
            this.fBuf.append("# .Sf_framecode tags: value is saveframe name\n");
            this.fBuf.append("# .Sf_ID tags: saveframe IDs are unique within BMRB relational database\n");
            this.fBuf.append("#   Until the entry is loaded into RDB, these tags contain \"fake\" IDs:\n");
            this.fBuf.append("#   negative numbers\n");
            this.fBuf.append("# loop row index tags: value is loop row number (1 as all loops\n");
            this.fBuf.append("#   in the template have only one row)\n#\n')");
            Statement stat = this.fStar.getStatement();
            stat.executeUpdate(this.fBuf.toString());
            if (!stat.getConnection().getAutoCommit()) {
                stat.getConnection().commit();
            }
            stat.close();
            ++this.fLine;
            return true;
        }
        catch (SQLException e) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, -1, -1, -1, "Cannot create data block, check error output"));
            }
            System.err.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private List getSFCategories() {
        try {
            Statement query = this.fStar.getQueryStatement();
            ResultSet rs = query.executeQuery("SELECT ID, SFCAT FROM SFCATS WHERE MANDATORY = 'M' ORDER BY ID");
            ArrayList<Tag> rc = new ArrayList<Tag>();
            while (rs.next()) {
                Tag t = new Tag(-1, rs.getInt(1), rs.getString(2));
                rc.add(t);
            }
            rs.close();
            query.close();
            if (rc.size() < 1) {
                rc = null;
            }
            return rc;
        }
        catch (SQLException e) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, -1, -1, -1, "Cannot read list of saveframe categories, check error output"));
            }
            System.err.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public int addSaveFrame(String name, String category, int seq) {
        try {
            int id = this.fStar.nextId("ENTRYSFS");
            if (id < 0) {
                id = 0;
            }
            this.fBuf.setLength(0);
            this.fBuf.append("INSERT INTO ENTRYSFS (ID, SEQ, CATEGORY, NAME, LINE) VALUES (");
            this.fBuf.append(id);
            this.fBuf.append(',');
            this.fBuf.append(seq);
            this.fBuf.append(",'");
            this.fBuf.append(category);
            this.fBuf.append("','");
            this.fBuf.append(name);
            this.fBuf.append("',");
            this.fBuf.append(this.fLine);
            this.fBuf.append(')');
            Statement stat = this.fStar.getStatement();
            stat.executeUpdate(this.fBuf.toString());
            if (!stat.getConnection().getAutoCommit()) {
                stat.getConnection().commit();
            }
            stat.close();
            ++this.fLine;
            return id;
        }
        catch (SQLException e) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, -1, -1, -1, "Cannot add saveframe, check error output"));
            }
            System.err.println(e.getMessage());
            e.printStackTrace();
            return -1;
        }
    }

    public boolean addTags(String name, String category, int id) {
        try {
            boolean rc = true;
            String newcat = null;
            String oldcat = null;
            this.fBuf.setLength(0);
            this.fBuf.append("SELECT SEQ,LOOPFLAG,TAGNAME FROM TAGS WHERE SFCAT='");
            this.fBuf.append(category);
            this.fBuf.append("' AND (MANDATORY='M' OR MANDATORY='V' OR MANDATORY='C' ");
            this.fBuf.append("OR MANDATORY='R') ORDER BY SEQ");
            Statement query = this.fStar.getQueryStatement();
            ResultSet rs = query.executeQuery(this.fBuf.toString());
            while (rs.next()) {
                if (rs.getString(2).equals("N")) {
                    this.fInLoop = false;
                    oldcat = null;
                    rc = this.addFreeTag(rs.getInt(1), name, category, id);
                    continue;
                }
                if (this.fInLoop) {
                    int pos = rs.getString(3).indexOf(46);
                    newcat = rs.getString(3).substring(0, pos);
                    if (oldcat == null) {
                        oldcat = newcat;
                        this.fInLoop = false;
                    }
                    if (!newcat.equals(oldcat)) {
                        this.fInLoop = false;
                        oldcat = newcat;
                    }
                }
                if (this.fInLoop) continue;
                this.addLoop(id, name, category, newcat);
                this.fInLoop = true;
            }
            return rc;
        }
        catch (SQLException e) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, -1, -1, -1, "Cannot add saveframe, check error output"));
            }
            System.err.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public boolean addFreeTag(int seq, String sfname, String sfcat, int sfid) {
        try {
            this.fBuf.setLength(0);
            this.fBuf.append("SELECT TAGNAME, SFIDFLAG, SFLABELFLAG, SFCATFLAG FROM TAGS WHERE SEQ = ");
            this.fBuf.append(seq);
            Statement query = this.fStar.getQueryStatement();
            ResultSet rs = query.executeQuery(this.fBuf.toString());
            if (!rs.next()) {
                return false;
            }
            int tagid = this.fStar.nextId("ENTRYTAGS");
            this.fBuf.setLength(0);
            this.fBuf.append("INSERT INTO ENTRYTAGS (ID, SFID, SEQ, NAME, LINE) VALUES (");
            this.fBuf.append(tagid);
            this.fBuf.append(',');
            this.fBuf.append(sfid);
            this.fBuf.append(',');
            this.fBuf.append(seq);
            this.fBuf.append(",'");
            this.fBuf.append(rs.getString(1));
            this.fBuf.append("',");
            this.fBuf.append(this.fLine);
            this.fBuf.append(')');
            Statement stat = this.fStar.getStatement();
            stat.executeUpdate(this.fBuf.toString());
            int valid = this.fStar.nextId("ENTRYVALS");
            this.fBuf.setLength(0);
            this.fBuf.append("INSERT INTO ENTRYVALS (ID, TAGID, SEQ, VAL, DELIMITER, LINE) VALUES (");
            this.fBuf.append(valid);
            this.fBuf.append(',');
            this.fBuf.append(tagid);
            this.fBuf.append(',');
            this.fBuf.append(seq);
            this.fBuf.append(",'");
            if (rs.getString(2).equals("Y")) {
                this.fBuf.append('-');
                this.fBuf.append(sfid);
            } else if (rs.getString(3).equals("Y")) {
                this.fBuf.append(sfname);
            } else if (rs.getString(4).equals("Y")) {
                this.fBuf.append(sfcat);
            } else {
                this.fBuf.append('?');
            }
            rs.close();
            query.close();
            this.fBuf.append("',");
            this.fBuf.append(13);
            this.fBuf.append(',');
            this.fBuf.append(this.fLine);
            this.fBuf.append(')');
            stat.executeUpdate(this.fBuf.toString());
            if (!stat.getConnection().getAutoCommit()) {
                stat.getConnection().commit();
            }
            stat.close();
            ++this.fLine;
            return true;
        }
        catch (SQLException e) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, -1, -1, -1, "Cannot add free tag, check error output"));
            }
            System.err.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public boolean addLoop(int sfid) {
        try {
            this.fLoopId = this.fStar.nextId("ENTRYLOOPS");
            this.fBuf.setLength(0);
            this.fBuf.append("INSERT INTO ENTRYLOOPS (ID, SFID, LINE) VALUES (");
            this.fBuf.append(this.fLoopId);
            this.fBuf.append(',');
            this.fBuf.append(sfid);
            this.fBuf.append(',');
            this.fBuf.append(this.fLine);
            this.fBuf.append(')');
            Statement stat = this.fStar.getStatement();
            stat.executeUpdate(this.fBuf.toString());
            if (!stat.getConnection().getAutoCommit()) {
                stat.getConnection().commit();
            }
            stat.close();
            ++this.fLine;
            return true;
        }
        catch (SQLException e) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, -1, -1, -1, "Cannot add loop, check error output"));
            }
            System.err.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public boolean addLoop(int sfid, String sfname, String sfcat, String tagcat) {
        try {
            this.fLoopId = this.fStar.nextId("ENTRYLOOPS");
            this.fBuf.setLength(0);
            this.fBuf.append("INSERT INTO ENTRYLOOPS (ID, SFID, LINE) VALUES (");
            this.fBuf.append(this.fLoopId);
            this.fBuf.append(',');
            this.fBuf.append(sfid);
            this.fBuf.append(',');
            this.fBuf.append(this.fLine);
            this.fBuf.append(')');
            Statement stat = this.fStar.getStatement();
            stat.executeUpdate(this.fBuf.toString());
            stat.getConnection().commit();
            stat.close();
            ++this.fLine;
            this.fBuf.setLength(0);
            this.fBuf.append("SELECT SEQ FROM TAGS WHERE SFCAT='");
            this.fBuf.append(sfcat);
            this.fBuf.append("' AND TAGNAME LIKE '");
            this.fBuf.append(tagcat);
            this.fBuf.append("%' AND LOOPFLAG='Y' ORDER BY SEQ");
            Statement query = this.fStar.getQueryStatement();
            ResultSet rs = query.executeQuery(this.fBuf.toString());
            while (rs.next()) {
                this.addLoopTag(rs.getInt(1), sfname, sfcat, sfid, this.fLoopId);
            }
            rs.close();
            query.close();
            return true;
        }
        catch (SQLException e) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, -1, -1, -1, "Cannot add loop, check error output"));
            }
            System.err.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public boolean addLoopTag(int seq, String sfname, String sfcat, int sfid, int loopid) {
        try {
            this.fBuf.setLength(0);
            this.fBuf.append("SELECT TAGNAME, ROWIDXFLAG FROM TAGS WHERE SEQ = ");
            this.fBuf.append(seq);
            Statement query = this.fStar.getQueryStatement();
            ResultSet rs = query.executeQuery(this.fBuf.toString());
            if (!rs.next()) {
                return false;
            }
            int tagid = this.fStar.nextId("ENTRYTAGS");
            this.fBuf.setLength(0);
            this.fBuf.append("INSERT INTO ENTRYTAGS (ID, SFID, LOOPID, SEQ, NAME, LINE) VALUES (");
            this.fBuf.append(tagid);
            this.fBuf.append(',');
            this.fBuf.append(sfid);
            this.fBuf.append(',');
            this.fBuf.append(this.fLoopId);
            this.fBuf.append(',');
            this.fBuf.append(seq);
            this.fBuf.append(",'");
            this.fBuf.append(rs.getString(1));
            this.fBuf.append("',");
            this.fBuf.append(this.fLine);
            this.fBuf.append(')');
            Statement stat = this.fStar.getStatement();
            stat.executeUpdate(this.fBuf.toString());
            int valid = this.fStar.nextId("ENTRYVALS");
            this.fBuf.setLength(0);
            this.fBuf.append("INSERT INTO ENTRYVALS (ID, TAGID, LOOPID, SEQ, VAL, DELIMITER, LINE, LOOPROW) VALUES (");
            this.fBuf.append(valid);
            this.fBuf.append(',');
            this.fBuf.append(tagid);
            this.fBuf.append(',');
            this.fBuf.append(this.fLoopId);
            this.fBuf.append(',');
            this.fBuf.append(seq);
            this.fBuf.append(",'");
            if (rs.getString(2).equals("Y")) {
                this.fBuf.append("1");
            } else {
                this.fBuf.append('?');
            }
            rs.close();
            query.close();
            this.fBuf.append("',");
            this.fBuf.append(13);
            this.fBuf.append(',');
            this.fBuf.append(this.fLine);
            this.fBuf.append(",0)");
            stat.executeUpdate(this.fBuf.toString());
            if (!stat.getConnection().getAutoCommit()) {
                stat.getConnection().commit();
            }
            stat.close();
            ++this.fLine;
            return true;
        }
        catch (SQLException e) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, -1, -1, -1, "Cannot add loop tag, check error output"));
            }
            System.err.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        long now = System.currentTimeMillis();
        Star_DB star = args.length > 0 ? new Star_DB(args[0]) : new Star_DB();
        star.connect(false);
        try {
            CreateTemplate ct = new CreateTemplate(star);
            if (!ct.createTemplate()) {
                System.err.println("Error creating template");
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        finally {
            star.disconnect();
        }
        System.out.println("Elapsed: " + (System.currentTimeMillis() - now));
    }
}

