/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.stardb;

import EDU.bmrb.nmrstar.utils.QuoteString;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.stardb.Tag;
import EDU.bmrb.stardb.sdbException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class Entry {
    private static final boolean DEBUG = false;

    public static int[] getSaveframeIDs(Stardb star, String sfcat) throws SQLException {
        StringBuffer sql = new StringBuffer("SELECT ID FROM ENTRYSFS WHERE CATEGORY='");
        sql.append(sfcat);
        sql.append("' ORDER BY ID");
        Statement query = star.getQueryStatement();
        ResultSet rs = query.executeQuery(sql.toString());
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (rs.next()) {
            list.add(new Integer(rs.getInt(1)));
        }
        rs.close();
        query.close();
        if (list.size() < 1) {
            return null;
        }
        int[] rc = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            rc[i] = (Integer)list.get(i);
        }
        list.clear();
        sql.setLength(0);
        return rc;
    }

    public static int[] getLoopIDs(Stardb star, String sfcat, String tag) throws SQLException {
        int pos = tag.indexOf(46);
        if (pos < 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer("SELECT DISTINCT LOOPID FROM ENTRYSFS s,");
        sql.append("ENTRYTAGS t WHERE s.CATEGORY='");
        sql.append(sfcat);
        sql.append("' AND t.NAME LIKE '");
        sql.append(tag.substring(0, pos + 1));
        sql.append("%' ORDER BY LOOPID");
        Statement query = star.getQueryStatement();
        ResultSet rs = query.executeQuery(sql.toString());
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (rs.next()) {
            list.add(new Integer(rs.getInt(1)));
        }
        rs.close();
        query.close();
        if (list.size() < 1) {
            return null;
        }
        int[] rc = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            rc[i] = (Integer)list.get(i);
        }
        list.clear();
        sql.setLength(0);
        return rc;
    }

    public static int[] getLoopIDs(Stardb star, int sfid, String tag) throws SQLException {
        int pos = tag.indexOf(46);
        if (pos < 0) {
            return null;
        }
        StringBuffer sql = new StringBuffer("SELECT DISTINCT LOOPID FROM ENTRYTAGS");
        sql.append(" WHERE SFID=");
        sql.append(sfid);
        sql.append(" AND NAME LIKE '");
        sql.append(tag.substring(0, pos + 1));
        sql.append("%' ORDER BY LOOPID");
        Statement query = star.getQueryStatement();
        ResultSet rs = query.executeQuery(sql.toString());
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (rs.next()) {
            list.add(new Integer(rs.getInt(1)));
        }
        rs.close();
        query.close();
        if (list.size() < 1) {
            return null;
        }
        int[] rc = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            rc[i] = (Integer)list.get(i);
        }
        list.clear();
        sql.setLength(0);
        return rc;
    }

    public static boolean isFramecode(Stardb star, int tagid) throws SQLException, sdbException {
        if (!star.hasDictionary()) {
            throw new sdbException("Dictionary is not loaded");
        }
        int seq = Entry.getTagNumber(star, tagid);
        if (seq < 0) {
            throw new sdbException("No sequence number for tag " + tagid);
        }
        StringBuffer sql = new StringBuffer("SELECT VALTYPE FROM TAGS WHERE SEQ=");
        sql.append(seq);
        Statement query = star.getQueryStatement();
        ResultSet rs = query.executeQuery(sql.toString());
        rs.next();
        boolean rc = rs.getString(1).equals("FRAMECODE");
        if (rs.wasNull()) {
            rc = false;
        }
        rs.close();
        query.close();
        sql.setLength(0);
        return rc;
    }

    public static int getRowIndexTagNumber(Stardb star, String sfcat, String tag) throws SQLException, sdbException {
        if (!star.hasDictionary()) {
            throw new sdbException("Dictionary is not loaded");
        }
        int pos = tag.indexOf(46);
        String tagcat = tag.substring(0, pos + 1);
        StringBuffer sql = new StringBuffer("SELECT SEQ FROM TAGS WHERE ROWIDXFLAG='Y' AND SFCAT='");
        sql.append(sfcat);
        sql.append("' AND TAGNAME LIKE '");
        sql.append(tagcat);
        sql.append("%'");
        Statement query = star.getQueryStatement();
        ResultSet rs = query.executeQuery(sql.toString());
        pos = -1;
        if (rs.next()) {
            pos = rs.getInt(1);
            if (rs.wasNull()) {
                throw new sdbException("Dictionary error: tag with no sequence number");
            }
        }
        rs.close();
        query.close();
        sql.setLength(0);
        return pos;
    }

    public static int getRowIndexTagNumber(Stardb star, int loopid) throws SQLException, sdbException {
        if (!star.hasDictionary()) {
            throw new sdbException("Dictionary is not loaded");
        }
        StringBuffer sql = star.isHSQLDB() ? new StringBuffer("SELECT TOP 1 t.NAME,s.CATEGORY FROM ") : new StringBuffer("SELECT t.NAME,s.CATEGORY FROM ");
        sql.append("ENTRYTAGS t,ENTRYSFS s WHERE t.LOOPID=");
        sql.append(loopid);
        sql.append(" AND t.SFID=s.ID");
        Statement query = star.getQueryStatement();
        ResultSet rs = query.executeQuery(sql.toString());
        if (!rs.next()) {
            throw new sdbException("Invalid tag id");
        }
        int rc = Entry.getRowIndexTagNumber(star, rs.getString(2), rs.getString(1));
        rs.close();
        query.close();
        sql.setLength(0);
        return rc;
    }

    public static int[] getTagIDs(Stardb star, String sfcat, String tag) throws SQLException {
        StringBuffer sql = new StringBuffer("SELECT t.ID FROM ENTRYSFS s,ENTRYTAGS t ");
        sql.append("WHERE s.CATEGORY='");
        sql.append(sfcat);
        sql.append("' AND t.NAME='");
        sql.append(tag);
        sql.append("' AND t.SFID=s.ID ORDER BY t.ID");
        Statement query = star.getQueryStatement();
        ResultSet rs = query.executeQuery(sql.toString());
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (rs.next()) {
            list.add(new Integer(rs.getInt(1)));
        }
        rs.close();
        query.close();
        if (list.size() < 1) {
            return null;
        }
        int[] rc = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            rc[i] = (Integer)list.get(i);
        }
        list.clear();
        sql.setLength(0);
        return rc;
    }

    public static Tag[] getLoopTags(Stardb star, int loopid) throws SQLException, sdbException {
        StringBuffer sql = new StringBuffer("SELECT ID,SEQ,NAME FROM ENTRYTAGS t WHERE LOOPID=");
        sql.append(loopid);
        sql.append(" ORDER BY SEQ");
        Statement query = star.getQueryStatement();
        ResultSet rs = query.executeQuery(sql.toString());
        if (!rs.next()) {
            throw new sdbException("Invalid loop id: " + loopid);
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        do {
            tags.add(new Tag(rs.getInt(1), rs.getInt(2), rs.getString(3)));
        } while (rs.next());
        rs.close();
        query.close();
        Tag[] rc = new Tag[tags.size()];
        for (int i = 0; i < tags.size(); ++i) {
            rc[i] = (Tag)tags.get(i);
        }
        tags.clear();
        return rc;
    }

    public static String[] getLoopTagNames(Stardb star, int loopid) throws SQLException {
        StringBuffer sql = new StringBuffer("SELECT NAME FROM ENTRYTAGS t WHERE LOOPID=");
        sql.append(loopid);
        sql.append(" ORDER BY SEQ");
        Statement query = star.getQueryStatement();
        ResultSet rs = query.executeQuery(sql.toString());
        ArrayList<String> tags = new ArrayList<String>();
        while (rs.next()) {
            tags.add(rs.getString(1));
        }
        rs.close();
        query.close();
        if (tags.size() < 1) {
            return null;
        }
        String[] rc = new String[tags.size()];
        for (int i = 0; i < tags.size(); ++i) {
            rc[i] = (String)tags.get(i);
        }
        tags.clear();
        return rc;
    }

    public static int getTagID(Stardb star, int sfid, String tag) throws SQLException {
        StringBuffer sql = new StringBuffer("SELECT ID FROM ENTRYTAGS ");
        sql.append("WHERE SFID=");
        sql.append(sfid);
        sql.append(" AND NAME='");
        sql.append(tag);
        sql.append('\'');
        Statement query = star.getQueryStatement();
        ResultSet rs = query.executeQuery(sql.toString());
        int rc = -1;
        if (rs.next()) {
            rc = rs.getInt(1);
            if (rs.wasNull()) {
                rc = -1;
            }
        }
        rs.close();
        query.close();
        sql.setLength(0);
        return rc;
    }

    public static int getTagID(Stardb star, int sfid, int tagnum) throws SQLException {
        StringBuffer sql = new StringBuffer("SELECT ID FROM ENTRYTAGS ");
        sql.append("WHERE SFID=");
        sql.append(sfid);
        sql.append(" AND SEQ=");
        sql.append(tagnum);
        Statement query = star.getQueryStatement();
        ResultSet rs = query.executeQuery(sql.toString());
        int rc = -1;
        if (rs.next()) {
            rc = rs.getInt(1);
            if (rs.wasNull()) {
                rc = -1;
            }
        }
        rs.close();
        query.close();
        sql.setLength(0);
        return rc;
    }

    public static String getSaveframeCategory(Stardb star, int sfid) throws SQLException {
        StringBuffer sql = new StringBuffer("SELECT CATEGORY FROM ENTRYSFS ");
        sql.append("WHERE ID=");
        sql.append(sfid);
        sql.append(" AND CATEGORY IS NOT NULL");
        Statement query = star.getQueryStatement();
        ResultSet rs = query.executeQuery(sql.toString());
        String rc = null;
        if (rs.next()) {
            rc = rs.getString(1);
            if (rs.wasNull()) {
                rc = null;
            }
        }
        rs.close();
        query.close();
        sql.setLength(0);
        return rc;
    }

    public static int getTagNumber(Stardb star, int tagid) throws SQLException {
        StringBuffer sql = new StringBuffer("SELECT SEQ FROM ENTRYTAGS ");
        sql.append("WHERE ID=");
        sql.append(tagid);
        Statement query = star.getQueryStatement();
        ResultSet rs = query.executeQuery(sql.toString());
        int rc = -1;
        if (rs.next()) {
            rc = rs.getInt(1);
            if (rs.wasNull()) {
                rc = -1;
            }
        }
        rs.close();
        query.close();
        sql.setLength(0);
        return rc;
    }

    public static void updateValue(Stardb star, int valid, String value) throws SQLException {
        StringBuffer sql = new StringBuffer("UPDATE ENTRYVALS SET VAL=");
        sql.append(QuoteString.quoteForDB(value));
        sql.append(",DELIMITER=");
        sql.append(QuoteString.findSTARQuoteStyle(value));
        sql.append(" WHERE ID=");
        sql.append(valid);
        Statement stat = star.getStatement();
        stat.executeUpdate(sql.toString());
        stat.getConnection().commit();
        stat.close();
        sql.setLength(0);
    }

    public static void insertFreeValue(Stardb star, int tagid, String value) throws SQLException {
        Entry.insertFreeValue(star, tagid, value, QuoteString.findSTARQuoteStyle(value));
    }

    public static void insertFreeValue(Stardb star, int tagid, String value, int delim) throws SQLException {
        StringBuffer sql = new StringBuffer("SELECT ID FROM ENTRYVALS WHERE TAGID=");
        sql.append(tagid);
        sql.append(" AND LOOPID IS NULL");
        Statement stat = star.getStatement();
        ResultSet rs = stat.executeQuery(sql.toString());
        int id = -1;
        if (rs.next()) {
            id = rs.getInt(1);
            if (rs.wasNull()) {
                id = -1;
            }
        }
        rs.close();
        sql.setLength(0);
        if (id < 0) {
            id = star.nextId("ENTRYVALS");
            int tagnum = Entry.getTagNumber(star, tagid);
            sql.append("INSERT INTO ENTRYVALS (ID,TAGID,SEQ,VAL,DELIMITER,LINE) VALUES (");
            sql.append(id);
            sql.append(',');
            sql.append(tagid);
            sql.append(',');
            if (tagnum < 0) {
                sql.append("NULL");
            } else {
                sql.append(tagnum);
            }
            sql.append(',');
            sql.append(QuoteString.quoteForDB(value));
            sql.append(',');
            sql.append(delim);
            sql.append(',');
            sql.append(0);
            sql.append(')');
        } else {
            sql.append("UPDATE ENTRYVALS SET VAL=");
            sql.append(QuoteString.quoteForDB(value));
            sql.append(",DELIMITER=");
            sql.append(delim);
            sql.append(" WHERE ID=");
            sql.append(id);
        }
        stat.executeUpdate(sql.toString());
        stat.getConnection().commit();
        stat.close();
        sql.setLength(0);
    }

    public static void insertLoopValue(Stardb star, int loopid, int tagid, int row, String value) throws SQLException, sdbException {
        StringBuffer sql = new StringBuffer("SELECT ID FROM ENTRYVALS WHERE TAGID=");
        sql.append(tagid);
        sql.append(" AND LOOPID=");
        sql.append(loopid);
        sql.append(" AND LOOPROW=");
        sql.append(row);
        Statement stat = star.getStatement();
        ResultSet rs = stat.executeQuery(sql.toString());
        int id = -1;
        if (rs.next()) {
            id = rs.getInt(1);
            if (rs.wasNull()) {
                id = -1;
            }
        }
        rs.close();
        if (id < 0) {
            Entry.insertLoopRow(star, loopid, row);
        }
        sql.setLength(0);
        sql.append("UPDATE ENTRYVALS SET VAL=");
        sql.append(QuoteString.quoteForDB(value));
        sql.append(",DELIMITER=");
        sql.append(QuoteString.findSTARQuoteStyle(value));
        sql.append(" WHERE TAGID=");
        sql.append(tagid);
        sql.append(" AND LOOPROW=");
        sql.append(row);
        stat.executeUpdate(sql.toString());
        stat.getConnection().commit();
        stat.close();
        sql.setLength(0);
    }

    public static int updateLoopColumn(Stardb star, int sfid, String tag, String value) throws SQLException {
        int tagid = Entry.getTagID(star, sfid, tag);
        if (tagid < 0) {
            return -1;
        }
        StringBuffer sql = new StringBuffer("UPDATE ENTRYVALS SET VAL=");
        if (value == null) {
            sql.append("NULL");
        } else {
            sql.append(QuoteString.quoteForDB(value));
        }
        sql.append(",DELIMITER=");
        if (value == null) {
            sql.append(13);
        } else {
            sql.append(QuoteString.findSTARQuoteStyle(value));
        }
        sql.append(" WHERE TAGID= ");
        sql.append(tagid);
        sql.append(" AND VAL IS NULL");
        Statement stat = star.getStatement();
        int rc = stat.executeUpdate(sql.toString());
        stat.getConnection().commit();
        stat.close();
        return rc;
    }

    public static void insertFreeTagValue(Stardb star, int sfid, String tag, String val) throws SQLException, sdbException {
        Entry.insertFreeTagValue(star, sfid, tag, val, QuoteString.findSTARQuoteStyle(val));
    }

    public static void insertFreeTagValue(Stardb star, int sfid, String tag, String val, int delim) throws SQLException, sdbException {
        if (val.length() > star.getValueSize()) {
            throw new sdbException("Value too long");
        }
        int seq = -1;
        StringBuffer sql = new StringBuffer();
        Statement query = star.getQueryStatement();
        ResultSet rs = null;
        if (star.hasDictionary()) {
            sql.append("SELECT CATEGORY FROM ENTRYSFS WHERE ID=");
            sql.append(sfid);
            rs = query.executeQuery(sql.toString());
            if (!rs.next()) {
                throw new sdbException("Invalid saveframe ID");
            }
            sql.setLength(0);
            sql.append("SELECT SEQ FROM TAGS WHERE SFCAT='");
            sql.append(rs.getString(1));
            sql.append("' AND TAGNAME='");
            sql.append(tag);
            sql.append('\'');
            rs = query.executeQuery(sql.toString());
            if (rs.next()) {
                seq = rs.getInt(1);
            }
        }
        sql.setLength(0);
        sql.append("INSERT INTO ENTRYTAGS (ID,SFID,SEQ,NAME,LINE) VALUES (");
        if (star.isOracle()) {
            sql.append("ETAGSEQ.NEXTVAL");
        } else {
            sql.append(star.nextId("ENTRYTAGS"));
        }
        sql.append(',');
        sql.append(sfid);
        sql.append(',');
        if (seq < 0) {
            sql.append("NULL");
        } else {
            sql.append(seq);
        }
        sql.append(",'");
        sql.append(tag);
        sql.append("',0)");
        Statement stat = star.getStatement();
        stat.executeUpdate(sql.toString());
        rs = star.isOracle() ? query.executeQuery("SELECT ETAGSEQ.CURRVAL FROM ENTRYTAGS") : query.executeQuery("SELECT MAX(ID) FROM ENTRYTAGS");
        if (!rs.next()) {
            throw new sdbException("Cannot get current tag id");
        }
        int tagid = rs.getInt(1);
        rs.close();
        query.close();
        sql.setLength(0);
        sql.append("INSERT INTO ENTRYVALS (ID,TAGID,SEQ,VAL,DELIMITER,LINE) VALUES (");
        if (star.isOracle()) {
            sql.append("EVALSEQ.NEXTVAL");
        } else {
            sql.append(star.nextId("ENTRYVALS"));
        }
        sql.append(',');
        sql.append(tagid);
        sql.append(',');
        if (seq < 0) {
            sql.append("NULL");
        } else {
            sql.append(seq);
        }
        sql.append(",'");
        sql.append(val);
        sql.append("',");
        sql.append(delim);
        sql.append(",0)");
        stat.executeUpdate(sql.toString());
        stat.getConnection().commit();
        stat.close();
    }

    public static int insertLoop(Stardb star, int sfid, String tag) throws SQLException, sdbException {
        int loopid = Entry.insertLoopTags(star, sfid, tag);
        Entry.insertLoopRow(star, loopid, 0);
        star.getConnection().commit();
        return loopid;
    }

    public static int insertLoopTags(Stardb star, int sfid, String tag) throws SQLException, sdbException {
        int idx;
        String sfcat = Entry.getSaveframeCategory(star, sfid);
        if (sfcat == null) {
            throw new sdbException("Invalid saveframe");
        }
        int i = tag.indexOf(46);
        if (i < 0) {
            throw new sdbException("Invalid tag: no category");
        }
        String tagcat = tag.substring(0, i + 1);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT SEQ,TAGNAME FROM TAGS WHERE SFCAT='");
        sql.append(sfcat);
        sql.append("' AND TAGNAME LIKE '");
        sql.append(tagcat);
        sql.append("%' AND LOOPFLAG='Y' ORDER BY SEQ");
        ArrayList<Tag> tags = new ArrayList<Tag>();
        Statement query = star.getQueryStatement();
        ResultSet rs = query.executeQuery(sql.toString());
        while (rs.next()) {
            tags.add(new Tag(-1, rs.getInt(1), rs.getString(2)));
        }
        rs.close();
        query.close();
        if (tags.size() < 1) {
            throw new sdbException("Invalid tag category");
        }
        int loopid = -1;
        if (!star.isOracle() && !star.isHSQLDB() && (loopid = star.nextId("ENTRYLOOPS")) < 0) {
            throw new sdbException("Cannot get next loop id");
        }
        sql.setLength(0);
        sql.append("INSERT INTO ENTRYLOOPS (SFID,LINE");
        if (!star.isOracle() && !star.isHSQLDB()) {
            sql.append(",ID");
        }
        sql.append(") VALUES(");
        sql.append(sfid);
        sql.append(",0");
        if (!star.isOracle() && !star.isHSQLDB()) {
            sql.append(',');
            sql.append(loopid);
        }
        sql.append(')');
        Statement stat = star.getStatement();
        stat.executeUpdate(sql.toString());
        stat.getConnection().commit();
        stat.close();
        if (star.isOracle() || star.isHSQLDB()) {
            loopid = star.getIdValue("ENTRYLOOPS");
        }
        if (loopid < 0) {
            throw new sdbException("Cannot get next loop id");
        }
        sql.setLength(0);
        if (star.isOracle() || star.isHSQLDB()) {
            sql.append("INSERT INTO ENTRYTAGS (SFID,LOOPID,SEQ,NAME,LINE) VALUES (");
            sql.append(sfid);
            sql.append(',');
            sql.append(loopid);
            sql.append(",?,?,0)");
            idx = 1;
        } else {
            sql.append("INSERT INTO ENTRYTAGS (ID,SFID,LOOPID,SEQ,NAME,LINE) VALUES (?,");
            sql.append(sfid);
            sql.append(',');
            sql.append(loopid);
            sql.append(",?,?,0)");
            idx = 2;
        }
        PreparedStatement pstat = star.getPreparedStatement(sql.toString());
        for (i = 0; i < tags.size(); ++i) {
            pstat.setInt(idx, ((Tag)tags.get(i)).getSeq());
            pstat.setString(idx + 1, ((Tag)tags.get(i)).getName());
            if (!star.isOracle() && !star.isHSQLDB()) {
                pstat.setInt(1, star.nextId("ENTRYTAGS"));
            }
            pstat.executeUpdate();
        }
        pstat.getConnection().commit();
        pstat.close();
        sql.setLength(0);
        tags.clear();
        return loopid;
    }

    public static void insertLoopRow(Stardb star, int loopid, int index) throws SQLException, sdbException {
        int idx;
        if (!star.hasDictionary()) {
            throw new sdbException("Dictionary is not loaded");
        }
        StringBuffer sql = new StringBuffer("INSERT INTO ENTRYVALS (");
        if (star.isOracle() || star.isHSQLDB()) {
            sql.append("TAGID,LOOPID,SEQ,VAL,DELIMITER,LINE,LOOPROW)");
            sql.append("VALUES (?,");
            sql.append(loopid);
            sql.append(",?,?,");
            sql.append(13);
            sql.append(",0,?)");
            idx = 1;
        } else {
            sql.append("ID,TAGID,LOOPID,SEQ,VAL,DELIMITER,LINE,LOOPROW)");
            sql.append("VALUES (?,?,");
            sql.append(loopid);
            sql.append(",?,?,");
            sql.append(13);
            sql.append(",0,?)");
            idx = 2;
        }
        PreparedStatement pstat = star.getPreparedStatement(sql.toString());
        sql.setLength(0);
        sql.append("SELECT e.ID,e.SEQ,d.ROWIDXFLAG ");
        sql.append(" FROM ENTRYTAGS e,TAGS d WHERE e.LOOPID=");
        sql.append(loopid);
        sql.append(" AND d.SEQ=e.SEQ ORDER BY e.SEQ");
        Statement query = star.getQueryStatement();
        ResultSet rs = query.executeQuery(sql.toString());
        while (rs.next()) {
            pstat.setInt(idx, rs.getInt(1));
            pstat.setInt(idx + 1, rs.getInt(2));
            if (rs.getString(3).charAt(0) == 'Y') {
                pstat.setString(idx + 2, Integer.toString(index));
            } else {
                pstat.setNull(idx + 2, 12);
            }
            pstat.setInt(idx + 3, index);
            if (!star.isOracle() && !star.isHSQLDB()) {
                pstat.setInt(1, star.nextId("ENTRYVALS"));
            }
            pstat.executeUpdate();
        }
        pstat.close();
        rs.close();
        query.close();
        sql.setLength(0);
    }

    public static void insertLoopColumn(Stardb star, int sfid, int loopid, String tag, String value) throws SQLException, sdbException {
        if (!star.hasDictionary()) {
            throw new sdbException("Dictionary is not loaded");
        }
        StringBuffer sql = new StringBuffer("SELECT SEQ FROM TAGS WHERE TAGNAME='");
        sql.append(tag);
        sql.append('\'');
        Statement query = star.getQueryStatement();
        ResultSet rs = query.executeQuery(sql.toString());
        if (!rs.next()) {
            query.close();
            throw new sdbException("Invalid tag: " + tag);
        }
        int seq = rs.getInt(1);
        sql.setLength(0);
        sql.append("SELECT ID FROM ENTRYTAGS WHERE LOOPID=");
        sql.append(loopid);
        sql.append(" AND SEQ=");
        sql.append(seq);
        rs = query.executeQuery(sql.toString());
        if (rs.next()) {
            query.close();
            throw new sdbException("Tag already exists: " + tag);
        }
        sql.setLength(0);
        sql.append("INSERT INTO ENTRYTAGS (");
        if (!star.isHSQLDB() && !star.isOracle()) {
            sql.append("ID,");
        }
        sql.append("SFID,LOOPID,SEQ,NAME,LINE) VALUES (");
        if (!star.isHSQLDB() && !star.isOracle()) {
            sql.append(star.nextId("ENTRYTAGS"));
            sql.append(',');
        }
        sql.append(sfid);
        sql.append(',');
        sql.append(loopid);
        sql.append(',');
        sql.append(seq);
        sql.append(",'");
        sql.append(tag);
        sql.append("',0)");
        Statement stat = star.getStatement();
        stat.executeUpdate(sql.toString());
        stat.getConnection().commit();
        stat.close();
        sql.setLength(0);
        sql.append("SELECT ID FROM ENTRYTAGS WHERE LOOPID=");
        sql.append(loopid);
        sql.append(" AND SEQ=");
        sql.append(seq);
        int tagid = -1;
        rs = query.executeQuery(sql.toString());
        rs.next();
        tagid = rs.getInt(1);
        sql.setLength(0);
        sql.append("SELECT MAX(LOOPROW) FROM ENTRYVALS WHERE LOOPID=");
        sql.append(loopid);
        rs = query.executeQuery(sql.toString());
        rs.next();
        int maxrow = rs.getInt(1);
        query.close();
        sql.setLength(0);
        sql.append("INSERT INTO ENTRYVALS(");
        if (!star.isHSQLDB() && !star.isOracle()) {
            sql.append("ID,");
        }
        sql.append("TAGID,LOOPID,SEQ,VAL,DELIMITER,LINE,LOOPROW) VALUES (");
        if (!star.isHSQLDB() && !star.isOracle()) {
            sql.append(star.nextId("ENTRYVALS"));
            sql.append(',');
        }
        sql.append(tagid);
        sql.append(',');
        sql.append(loopid);
        sql.append(',');
        sql.append(seq);
        sql.append(",'");
        sql.append(value);
        sql.append("',");
        sql.append(QuoteString.findSTARQuoteStyle(value));
        sql.append(",0,?)");
        PreparedStatement pstat = star.getPreparedStatement(sql.toString());
        for (int i = 0; i <= maxrow; ++i) {
            pstat.setInt(1, i);
            pstat.executeUpdate();
        }
        pstat.getConnection().commit();
        pstat.close();
    }
}

