/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.stardb;

import EDU.bmrb.lib.CreateDBSchema;
import EDU.bmrb.nmrstar.utils.QuoteString;
import EDU.bmrb.sansj.ErrorHandler;
import EDU.bmrb.sansj.STARLexer;
import EDU.bmrb.sansj.SimpleStarParser;
import EDU.bmrb.sansj.StarContentHandler;
import EDU.bmrb.sansj.starlib.DataNameNode;
import EDU.bmrb.sansj.starlib.DataValueNode;
import EDU.bmrb.sansj.starlib.StarNode;
import EDU.bmrb.stardb.AddDictionaryInfo;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.stardb.sdbException;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import gnu.getopt.Getopt;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class LoadEntry
implements StarContentHandler,
ErrorHandler {
    private static final String EXC_ERR = "Cannot load entry: caught exception. Check error output";
    private static final String STRLEN_MSG = "value longer than DB data type";
    private Stardb fStar = null;
    private ErrorList fErrs = null;
    private StringBuffer fBuf = null;
    private Statement fStat = null;
    private int fSfId = -1;
    private int fLoopId = -1;
    private int fLoopRow = -1;
    private int fLoopCol = -1;
    private List fLoopTags = null;
    private int fTagId = -1;
    private boolean fOK = true;
    private PrintWriter fOut = null;
    private PreparedStatement fSfStat = null;
    private PreparedStatement fLoopStat = null;
    private PreparedStatement fTagStat = null;
    private PreparedStatement fValStat = null;
    private int fCount = 0;
    private boolean fHasAutoIds = false;

    public LoadEntry(Stardb star) {
        this.fStar = star;
        this.init();
    }

    public LoadEntry(Stardb star, ErrorList errs) {
        this.fStar = star;
        this.fErrs = errs;
        this.init();
    }

    private void init() {
        this.fBuf = new StringBuffer();
        this.fStat = this.fStar.getStatement();
        this.fLoopTags = new ArrayList();
    }

    public void setOut(PrintWriter out) {
        this.fOut = out;
    }

    public boolean load(Reader in, boolean create_schema) throws SQLException, sdbException, IOException {
        if (!this.fStar.isConnected()) {
            this.fStar.connect(false);
        }
        if (create_schema) {
            CreateDBSchema.runScript(this.fStar.getConnection(), this.fStar.getProperty("DB.schema"), this.fOut);
        }
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery("SELECT VAL FROM ENTRYVALS");
        ResultSetMetaData md = rs.getMetaData();
        this.fStar.setValueSize(md.getColumnDisplaySize(1));
        STARLexer lex = new STARLexer(in);
        SimpleStarParser parser = new SimpleStarParser(lex, this, this);
        parser.parse();
        if (create_schema) {
            CreateDBSchema.runScript(this.fStar.getConnection(), this.fStar.getProperty("DB.constraints"), this.fOut);
        }
        return this.fOK;
    }

    public void error(int param, int param1, String str) {
        this.fOK = false;
        this.fBuf.setLength(0);
        this.fBuf.append("Parse error in line ");
        this.fBuf.append(param);
        this.fBuf.append(", col ");
        this.fBuf.append(param1);
        this.fBuf.append(": ");
        this.fBuf.append(str);
        if (this.fErrs != null) {
            this.fErrs.clear();
            this.fErrs.add(new Error(true, -1, -1, param, this.fBuf.toString()));
        } else {
            System.err.println(this.fBuf.toString());
        }
    }

    public boolean warning(int param, int param1, String str) {
        this.fBuf.setLength(0);
        this.fBuf.append("Parse warning in line ");
        this.fBuf.append(param);
        this.fBuf.append(", col ");
        this.fBuf.append(param1);
        this.fBuf.append(": ");
        this.fBuf.append(str);
        if (this.fErrs != null) {
            this.fErrs.add(new Error(false, -1, -1, param, this.fBuf.toString()));
        } else {
            System.err.println(this.fBuf.toString());
        }
        return false;
    }

    public boolean startData(StarNode node) {
        try {
            if (this.fStar.isOracle()) {
                this.fHasAutoIds = true;
                this.fSfStat = this.fStar.getPreparedStatement("INSERT INTO ENTRYSFS (NAME,LINE,COL,PRECOMMENT) VALUES (?,?,?,?)");
                this.fLoopStat = this.fStar.getPreparedStatement("INSERT INTO ENTRYLOOPS (SFID,LINE,COL,PRECOMMENT) VALUES (?,?,?,?)");
                this.fValStat = this.fStar.getPreparedStatement("INSERT INTO ENTRYVALS (TAGID,LOOPID,VAL,DELIMITER,LINE,COL,LOOPROW,PRECOMMENT) VALUES (?,?,?,?,?,?,?,?)");
                this.fTagStat = this.fStar.getPreparedStatement("INSERT INTO ENTRYTAGS (SFID,LOOPID,NAME,LINE,COL,PRECOMMENT) VALUES (?,?,?,?,?,?)");
            } else if (this.fStar.isHSQLDB()) {
                this.fHasAutoIds = true;
                this.fSfStat = this.fStar.getPreparedStatement("INSERT INTO ENTRYSFS (NAME,LINE,COL,PRECOMMENT) VALUES (?,?,?,?)");
                this.fLoopStat = this.fStar.getPreparedStatement("INSERT INTO ENTRYLOOPS (SFID,LINE,COL,PRECOMMENT) VALUES (?,?,?,?)");
                this.fValStat = this.fStar.getPreparedStatement("INSERT INTO ENTRYVALS (TAGID,LOOPID,VAL,DELIMITER,LINE,COL,LOOPROW,PRECOMMENT) VALUES (?,?,?,?,?,?,?,?)");
                this.fTagStat = this.fStar.getPreparedStatement("INSERT INTO ENTRYTAGS (SFID,LOOPID,NAME,LINE,COL,PRECOMMENT) VALUES (?,?,?,?,?,?)");
            } else if (this.fStar.isPostgres()) {
                this.fHasAutoIds = true;
                this.fSfStat = this.fStar.getPreparedStatement("INSERT INTO ENTRYSFS (ID,NAME,LINE,COL,PRECOMMENT) VALUES (NEXTVAL('ESFSEQ'),?,?,?,?)");
                this.fLoopStat = this.fStar.getPreparedStatement("INSERT INTO ENTRYLOOPS (ID,SFID,LINE,COL,PRECOMMENT) VALUES (NEXTVAL('ELOOPSEQ'),?,?,?,?)");
                this.fValStat = this.fStar.getPreparedStatement("INSERT INTO ENTRYVALS (ID,TAGID,LOOPID,VAL,DELIMITER,LINE,COL,LOOPROW,PRECOMMENT) VALUES (NEXTVAL('EVALSEQ'),?,?,?,?,?,?,?,?)");
                this.fTagStat = this.fStar.getPreparedStatement("INSERT INTO ENTRYTAGS (ID,SFID,LOOPID,NAME,LINE,COL,PRECOMMENT) VALUES (NEXTVAL('ETAGSEQ'),?,?,?,?,?,?)");
            } else if (this.fStar.isMimer()) {
                this.fHasAutoIds = true;
                this.fSfStat = this.fStar.getPreparedStatement("INSERT INTO ENTRYSFS (ID,NAME,LINE,COL,PRECOMMENT) VALUES (NEXT_VALUE OF ESFSEQ,?,?,?,?)");
                this.fLoopStat = this.fStar.getPreparedStatement("INSERT INTO ENTRYLOOPS (ID,SFID,LINE,COL,PRECOMMENT) VALUES (NEXT_VALUE OF ELOOPSEQ,?,?,?,?)");
                this.fValStat = this.fStar.getPreparedStatement("INSERT INTO ENTRYVALS (ID,TAGID,LOOPID,VAL,DELIMITER,LINE,COL,LOOPROW,PRECOMMENT) VALUES (NEXT_VALUE OF EVALSEQ,?,?,?,?,?,?,?,?)");
                this.fTagStat = this.fStar.getPreparedStatement("INSERT INTO ENTRYTAGS (ID,SFID,LOOPID,NAME,LINE,COL,PRECOMMENT) VALUES (NEXT_VALUE OF ETAGSEQ,?,?,?,?,?,?)");
            } else {
                this.fHasAutoIds = false;
                this.fSfStat = this.fStar.getPreparedStatement("INSERT INTO ENTRYSFS (ID,NAME,LINE,COL,PRECOMMENT) VALUES (?,?,?,?,?)");
                this.fLoopStat = this.fStar.getPreparedStatement("INSERT INTO ENTRYLOOPS (ID,SFID,LINE,COL,PRECOMMENT) VALUES (?,?,?,?,?)");
                this.fValStat = this.fStar.getPreparedStatement("INSERT INTO ENTRYVALS (ID,TAGID,LOOPID,VAL,DELIMITER,LINE,COL,LOOPROW,PRECOMMENT) VALUES (?,?,?,?,?,?,?,?,?)");
                this.fTagStat = this.fStar.getPreparedStatement("INSERT INTO ENTRYTAGS (ID,SFID,LOOPID,NAME,LINE,COL,PRECOMMENT) VALUES (?,?,?,?,?,?,?)");
            }
            this.fBuf.setLength(0);
            this.fBuf.append("INSERT INTO ENTRYINFO (NAME,LINE,COL,PRECOMMENT) VALUES ('");
            this.fBuf.append(node.getValue());
            this.fBuf.append("',");
            this.fBuf.append(node.getLineNum());
            this.fBuf.append(',');
            this.fBuf.append(node.getColNum());
            this.fBuf.append(',');
            if (node.getPreComment() != null) {
                if (this.fStar.isHSQLDB()) {
                    this.fBuf.append(QuoteString.quoteForDB(node.getPreComment()));
                } else if (node.getPreComment().length() > this.fStar.getCommentSize()) {
                    this.fBuf.append(QuoteString.quoteForDB(node.getPreComment().substring(0, this.fStar.getCommentSize())));
                    System.err.print("Truncated comment at line ");
                    System.err.println(node.getLineNum());
                } else {
                    this.fBuf.append(QuoteString.quoteForDB(node.getPreComment()));
                }
            } else {
                this.fBuf.append("NULL");
            }
            this.fBuf.append(')');
            if (this.fOut != null) {
                this.fOut.println(this.fBuf);
                this.fOut.flush();
            }
            this.fStat.executeUpdate(this.fBuf.toString());
            return false;
        }
        catch (SQLException e) {
            this.fOK = false;
            if (this.fErrs != null) {
                this.fErrs.clear();
                this.fErrs.add(new Error(true, -1, -1, node.getLineNum(), EXC_ERR));
            } else {
                this.fBuf.setLength(0);
                this.fBuf.append("DB exception while loading data block node ");
                this.fBuf.append(node.getValue());
                this.fBuf.append(" at line ");
                this.fBuf.append(node.getLineNum());
                this.fBuf.append(", col ");
                this.fBuf.append(node.getColNum());
                System.err.println(this.fBuf.toString());
            }
            System.err.println(e.getMessage());
            e.printStackTrace();
            return true;
        }
    }

    public void endData(StarNode node) {
        try {
            this.fStat.getConnection().commit();
            this.fSfStat.close();
            this.fLoopStat.close();
            this.fTagStat.close();
            this.fValStat.close();
        }
        catch (SQLException e) {
            this.fOK = false;
            if (this.fErrs != null) {
                this.fErrs.clear();
                this.fErrs.add(new Error(true, -1, -1, node.getLineNum(), EXC_ERR));
            } else {
                this.fBuf.setLength(0);
                this.fBuf.append("DB exception in endDataBlock ");
                this.fBuf.append(node.getValue());
                this.fBuf.append(" at line ");
                this.fBuf.append(node.getLineNum());
                this.fBuf.append(", col ");
                this.fBuf.append(node.getColNum());
                System.err.println(this.fBuf.toString());
            }
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean startSaveFrame(StarNode node) {
        try {
            int sfid = !this.fHasAutoIds ? 2 : 1;
            this.fSfStat.setString(sfid, node.getValue());
            this.fSfStat.setInt(++sfid, node.getLineNum());
            this.fSfStat.setInt(++sfid, node.getColNum());
            ++sfid;
            if (node.getPreComment() != null) {
                if (this.fStar.isHSQLDB()) {
                    this.fSfStat.setString(sfid, node.getPreComment());
                } else if (node.getPreComment().length() > this.fStar.getCommentSize()) {
                    this.fSfStat.setString(sfid, node.getPreComment().substring(0, this.fStar.getCommentSize()));
                } else {
                    this.fSfStat.setString(sfid, node.getPreComment());
                }
            } else {
                this.fSfStat.setNull(sfid, 12);
            }
            if (!this.fHasAutoIds) {
                sfid = this.fStar.nextId(Stardb.TABLES_ENTRY[0]);
                if (sfid < 0) {
                    System.err.println("startSaveFrame: cannot generate sf id");
                    return true;
                }
                this.fSfStat.setInt(1, sfid);
            }
            this.fSfStat.executeUpdate();
            if (this.fOut != null) {
                ++this.fCount;
                this.fOut.print(this.fCount);
                this.fOut.println(" rows inserted");
            }
            if (this.fHasAutoIds && (sfid = this.fStar.getIdValue(Stardb.TABLES_ENTRY[0])) < 0) {
                System.err.println("startSaveFrame: cannot generate sf id");
                return true;
            }
            this.fSfId = sfid;
            return false;
        }
        catch (SQLException e) {
            this.fOK = false;
            if (this.fErrs != null) {
                this.fErrs.clear();
                this.fErrs.add(new Error(true, -1, -1, node.getLineNum(), EXC_ERR));
            } else {
                this.fBuf.setLength(0);
                this.fBuf.append("DB exception in startSaveFrame() ");
                this.fBuf.append(node.getValue());
                this.fBuf.append(" at line ");
                this.fBuf.append(node.getLineNum());
                this.fBuf.append(", col ");
                this.fBuf.append(node.getColNum());
                System.err.println(this.fBuf.toString());
            }
            System.err.println(e.getMessage());
            e.printStackTrace();
            return true;
        }
    }

    public boolean endSaveFrame(StarNode node) {
        this.fSfId = -1;
        try {
            if (this.fOut != null) {
                this.fOut.flush();
            }
            this.fStat.getConnection().commit();
            return false;
        }
        catch (SQLException e) {
            this.fOK = false;
            if (this.fErrs != null) {
                this.fErrs.clear();
                this.fErrs.add(new Error(true, -1, -1, node.getLineNum(), EXC_ERR));
            } else {
                this.fBuf.setLength(0);
                this.fBuf.append("DB exception in endSaveFrame ");
                this.fBuf.append(node.getValue());
                this.fBuf.append(" at line ");
                this.fBuf.append(node.getLineNum());
                this.fBuf.append(", col ");
                this.fBuf.append(node.getColNum());
                System.err.println(this.fBuf.toString());
            }
            System.err.println(e.getMessage());
            e.printStackTrace();
            return true;
        }
    }

    public boolean startLoop(StarNode node) {
        this.fLoopCol = 0;
        this.fLoopRow = -1;
        try {
            int id = this.fHasAutoIds ? 1 : 2;
            this.fLoopStat.setInt(id, this.fSfId);
            this.fLoopStat.setInt(++id, node.getLineNum());
            this.fLoopStat.setInt(++id, node.getColNum());
            ++id;
            if (node.getPreComment() != null) {
                if (this.fStar.isHSQLDB()) {
                    this.fLoopStat.setString(id, node.getPreComment());
                } else if (node.getPreComment().length() > this.fStar.getCommentSize()) {
                    this.fLoopStat.setString(id, node.getPreComment().substring(0, this.fStar.getCommentSize()));
                } else {
                    this.fLoopStat.setString(id, node.getPreComment());
                }
            } else {
                this.fLoopStat.setNull(id, 12);
            }
            if (!this.fHasAutoIds) {
                id = this.fStar.nextId(Stardb.TABLES_ENTRY[1]);
                if (id < 0) {
                    System.err.println("startLoop: cannot generate loop id");
                    return true;
                }
                this.fLoopStat.setInt(1, id);
            }
            this.fLoopStat.executeUpdate();
            if (this.fOut != null) {
                ++this.fCount;
                this.fOut.print(this.fCount);
                this.fOut.println(" rows inserted");
            }
            if (this.fHasAutoIds && (id = this.fStar.getIdValue(Stardb.TABLES_ENTRY[1])) < 0) {
                System.err.println("startLoop: cannot generate loop id");
                return true;
            }
            this.fLoopId = id;
            return false;
        }
        catch (SQLException e) {
            this.fOK = false;
            if (this.fErrs != null) {
                this.fErrs.clear();
                this.fErrs.add(new Error(true, -1, -1, node.getLineNum(), EXC_ERR));
            }
            this.fBuf.setLength(0);
            this.fBuf.append("DB exception in startLoop() at line ");
            this.fBuf.append(node.getLineNum());
            this.fBuf.append(", col ");
            this.fBuf.append(node.getColNum());
            System.err.println(this.fBuf.toString());
            System.err.println(e.getMessage());
            e.printStackTrace();
            return true;
        }
    }

    public boolean endLoop(StarNode node) {
        this.fLoopId = -1;
        this.fLoopTags.clear();
        try {
            this.fStat.getConnection().commit();
            return false;
        }
        catch (SQLException e) {
            this.fOK = false;
            if (this.fErrs != null) {
                this.fErrs.clear();
                this.fErrs.add(new Error(true, -1, -1, node.getLineNum(), EXC_ERR));
            } else {
                this.fBuf.setLength(0);
                this.fBuf.append("DB exception in endLoop ");
                this.fBuf.append(node.getValue());
                this.fBuf.append(" at line ");
                this.fBuf.append(node.getLineNum());
                this.fBuf.append(", col ");
                this.fBuf.append(node.getColNum());
                System.err.println(this.fBuf.toString());
            }
            System.err.println(e.getMessage());
            e.printStackTrace();
            return true;
        }
    }

    public boolean tag(DataNameNode node) {
        try {
            int id = this.fHasAutoIds ? 1 : 2;
            this.fTagStat.setInt(id, this.fSfId);
            ++id;
            if (this.fLoopId >= 0) {
                this.fTagStat.setInt(id, this.fLoopId);
            } else {
                this.fTagStat.setNull(id, 4);
            }
            this.fTagStat.setString(++id, node.getValue());
            this.fTagStat.setInt(++id, node.getLineNum());
            this.fTagStat.setInt(++id, node.getColNum());
            ++id;
            if (node.getPreComment() != null) {
                if (this.fStar.isHSQLDB()) {
                    this.fTagStat.setString(id, node.getPreComment());
                } else if (node.getPreComment().length() > this.fStar.getCommentSize()) {
                    this.fTagStat.setString(id, node.getPreComment().substring(0, this.fStar.getCommentSize()));
                } else {
                    this.fTagStat.setString(id, node.getPreComment());
                }
            } else {
                this.fTagStat.setNull(id, 12);
            }
            if (!this.fHasAutoIds) {
                id = this.fStar.nextId(Stardb.TABLES_ENTRY[2]);
                if (id < 0) {
                    System.err.println("tag: cannot generate tag id");
                    return true;
                }
                this.fTagStat.setInt(1, id);
            }
            this.fTagStat.executeUpdate();
            if (this.fOut != null) {
                ++this.fCount;
                this.fOut.print(this.fCount);
                this.fOut.println(" rows inserted");
            }
            if (this.fHasAutoIds && (id = this.fStar.getIdValue(Stardb.TABLES_ENTRY[2])) < 0) {
                System.err.println("tag: cannot generate tag id");
                return true;
            }
            this.fTagId = id;
            if (this.fLoopId >= 0) {
                this.fLoopTags.add(new Integer(this.fTagId));
            }
            return false;
        }
        catch (SQLException e) {
            this.fOK = false;
            if (this.fErrs != null) {
                this.fErrs.clear();
                this.fErrs.add(new Error(true, -1, -1, node.getLineNum(), EXC_ERR));
            }
            this.fBuf.setLength(0);
            this.fBuf.append("DB exception while loading tag ");
            this.fBuf.append(node.getValue());
            this.fBuf.append(" at line ");
            this.fBuf.append(node.getLineNum());
            this.fBuf.append(", col ");
            this.fBuf.append(node.getColNum());
            System.err.println(this.fBuf.toString());
            System.err.println(e.getMessage());
            e.printStackTrace();
            return true;
        }
    }

    public boolean data(DataValueNode node) {
        int tagid = -1;
        if (this.fLoopId >= 0) {
            if (this.fLoopCol == 0) {
                ++this.fLoopRow;
            }
            tagid = (Integer)this.fLoopTags.get(this.fLoopCol);
            ++this.fLoopCol;
            if (this.fLoopCol >= this.fLoopTags.size()) {
                this.fLoopCol = 0;
            }
        } else {
            tagid = this.fTagId;
        }
        try {
            int id = this.fHasAutoIds ? 1 : 2;
            this.fValStat.setInt(id, tagid);
            ++id;
            if (this.fLoopId >= 0) {
                this.fValStat.setInt(id, this.fLoopId);
            } else {
                this.fValStat.setNull(id, 4);
            }
            ++id;
            if (node.getValue().equals(".")) {
                this.fValStat.setNull(id, 12);
            } else {
                if (node.getValue().length() > this.fStar.getValueSize()) {
                    if (this.fErrs != null) {
                        this.fErrs.add(new Error(false, -1, -1, node.getLineNum(), STRLEN_MSG));
                    }
                    System.err.print("Warning in line ");
                    System.err.print(node.getLineNum());
                    System.err.print(": ");
                    System.err.println(STRLEN_MSG);
                }
                this.fValStat.setString(id, node.getValue());
            }
            this.fValStat.setInt(++id, node.getDelimType());
            this.fValStat.setInt(++id, node.getLineNum());
            this.fValStat.setInt(++id, node.getColNum());
            ++id;
            if (this.fLoopId >= 0) {
                this.fValStat.setInt(id, this.fLoopRow);
            } else {
                this.fValStat.setNull(id, 4);
            }
            ++id;
            if (node.getPreComment() != null) {
                if (this.fStar.isHSQLDB()) {
                    this.fValStat.setString(id, node.getPreComment());
                } else if (node.getPreComment().length() > this.fStar.getCommentSize()) {
                    this.fValStat.setString(id, node.getPreComment().substring(0, this.fStar.getCommentSize()));
                } else {
                    this.fValStat.setString(id, node.getPreComment());
                }
            } else {
                this.fValStat.setNull(id, 12);
            }
            if (!this.fHasAutoIds) {
                id = this.fStar.nextId(Stardb.TABLES_ENTRY[3]);
                if (id < 0) {
                    System.err.println("value: cannot generate value id");
                    return true;
                }
                this.fValStat.setInt(1, id);
            }
            this.fValStat.executeUpdate();
            if (this.fOut != null) {
                ++this.fCount;
                this.fOut.print(this.fCount);
                this.fOut.println(" rows inserted");
            }
            return false;
        }
        catch (SQLException e) {
            this.fOK = false;
            if (this.fErrs != null) {
                this.fErrs.clear();
                this.fErrs.add(new Error(true, -1, -1, node.getLineNum(), EXC_ERR));
            }
            this.fBuf.setLength(0);
            this.fBuf.append("DB exception while loading value ");
            this.fBuf.append(node.getValue());
            this.fBuf.append(" at line ");
            this.fBuf.append(node.getLineNum());
            this.fBuf.append(", col ");
            this.fBuf.append(node.getColNum());
            System.err.println(this.fBuf.toString());
            System.err.println(e.getMessage());
            e.printStackTrace();
            return true;
        }
    }

    public static void usage() {
        System.out.print("Usage: java EDU.bmrb.stardb.LoadEntry [-c FILE] [-i FILE] ");
        System.out.println("[-o FILE] [-s] [-d] [-h]");
        System.out.print(" -c FILE: config FILE, default: ~/");
        System.out.println("stardb.properties");
        System.out.println(" -i FILE: input FILE, default: stdin");
        System.out.println(" -o FILE: output FILE for SQL statements, use dash for stdout");
        System.out.println(" -s: skip schema creation");
        System.out.println(" -d: do not add dictionary information");
        System.out.println(" -h: print this message and exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        long now = System.currentTimeMillis();
        Stardb star = null;
        ErrorList errs = null;
        boolean rc = true;
        try {
            int opt;
            Getopt g = new Getopt("LoadEntry", args, "dhsc:i:o:");
            String conffile = null;
            String infile = null;
            String outfile = null;
            boolean create_schema = true;
            boolean add_dictionary = true;
            block13: while ((opt = g.getopt()) != -1) {
                switch (opt) {
                    case 100: {
                        add_dictionary = false;
                        continue block13;
                    }
                    case 115: {
                        create_schema = false;
                        continue block13;
                    }
                    case 99: {
                        conffile = g.getOptarg();
                        continue block13;
                    }
                    case 105: {
                        infile = g.getOptarg();
                        continue block13;
                    }
                    case 111: {
                        outfile = g.getOptarg();
                        continue block13;
                    }
                }
                LoadEntry.usage();
                return;
            }
            star = conffile != null ? new Star_DB(conffile) : new Star_DB();
            star.connect(false);
            System.err.println("DB open: " + (System.currentTimeMillis() - now));
            now = System.currentTimeMillis();
            InputStreamReader in = infile == null ? new InputStreamReader(System.in, "ISO-8859-15") : new InputStreamReader((InputStream)new FileInputStream(infile), "ISO-8859-15");
            errs = new ErrorList(true);
            LoadEntry ldr = new LoadEntry(star, errs);
            PrintWriter out = null;
            if (outfile != null) {
                out = outfile.equals("-") ? new PrintWriter(System.out) : new PrintWriter(new FileOutputStream(outfile));
            }
            ldr.setOut(out);
            rc = ldr.load(in, create_schema);
            if (rc) {
                star.getConnection().commit();
                System.err.println("Entry loaded: " + (System.currentTimeMillis() - now));
                now = System.currentTimeMillis();
                if (add_dictionary) {
                    AddDictionaryInfo.addDictionaryInfo(star);
                    AddDictionaryInfo.checkVersion(star, errs);
                }
            }
            System.err.println("Added dictionary overrides: " + (System.currentTimeMillis() - now));
            now = System.currentTimeMillis();
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
        }
        finally {
            if (star != null) {
                star.disconnect();
            }
            System.err.println("DB closed: " + (System.currentTimeMillis() - now));
            if (errs != null && errs.size() > 0) {
                errs.printErrors(System.out);
            }
            if (!rc) {
                System.exit(1);
            }
        }
    }
}

