/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.stardb;

import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class LockDB {
    public static final String PROPKEY_DRIVER = "DB.Driver";
    public static final String PROPKEY_DBURL = "DB.Url";
    public static final String PROPKEY_DBUSER = "DB.User";
    public static final String PROPKEY_DBPASSWD = "DB.Password";
    public static final String PROPFILE = "validator.properties";

    public static boolean setLock(Properties p, boolean lock) throws NullPointerException, ClassNotFoundException, SQLException {
        String str = p.getProperty(PROPKEY_DRIVER);
        if (str == null || str.equals("")) {
            throw new NullPointerException("No database driver");
        }
        Class.forName(str);
        String url = p.getProperty(PROPKEY_DBURL);
        if (url == null || url.length() == 0) {
            throw new NullPointerException("No database URL");
        }
        Connection conn = DriverManager.getConnection(url, p.getProperty(PROPKEY_DBUSER), p.getProperty(PROPKEY_DBPASSWD));
        conn.setAutoCommit(false);
        int flag = 0;
        Statement stat = conn.createStatement();
        ResultSet rs = null;
        try {
            rs = stat.executeQuery("SELECT INUSE FROM LOCKTABLE");
            if (rs.next()) {
                str = rs.getString(1);
                if (!rs.wasNull()) {
                    flag = str.toUpperCase().charAt(0);
                }
            }
            rs.close();
        }
        catch (SQLException se) {
            stat.executeUpdate("CREATE TABLE LOCKTABLE (INUSE CHAR(1) NOT NULL)");
            conn.commit();
        }
        if (flag == 0) {
            if (lock) {
                stat.executeUpdate("INSERT INTO LOCKTABLE (INUSE) VALUES ('Y')");
            } else {
                stat.executeUpdate("INSERT INTO LOCKTABLE (INUSE) VALUES ('N')");
            }
        } else if (flag == 89) {
            if (lock) {
                stat.close();
                conn.close();
                return false;
            }
            stat.executeUpdate("UPDATE LOCKTABLE SET INUSE='N'");
        } else if (lock) {
            stat.executeUpdate("UPDATE LOCKTABLE SET INUSE='Y'");
        }
        conn.commit();
        stat.close();
        conn.close();
        return true;
    }

    public static boolean setLock(Properties p, boolean lock, int retries) throws NullPointerException, ClassNotFoundException, SQLException {
        for (int i = 0; i < retries; ++i) {
            if (LockDB.setLock(p, lock)) {
                return true;
            }
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            boolean lock;
            String str = null;
            if (args.length <= 0) {
                System.out.println("Usage: java EDU.bmrb.stardb.LockDB [config file] <lock|unlock>");
                return;
            }
            str = args[args.length - 1].toLowerCase();
            if (str.equals("lock")) {
                lock = true;
            } else if (str.equals("unlock")) {
                lock = false;
            } else {
                System.out.println("Usage: java EDU.bmrb.stardb.LockDB [config file] <lock|unlock>");
                return;
            }
            Properties p = new Properties();
            FileInputStream in = args.length > 1 ? new FileInputStream(args[0]) : new FileInputStream(System.getProperty("user.home") + File.separator + PROPFILE);
            p.load(in);
            in.close();
            if (!LockDB.setLock(p, lock) && lock) {
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

