/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.stardb;

import EDU.bmrb.nmrstar.utils.QuoteString;
import EDU.bmrb.stardb.Entry;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.stardb.Tag;
import EDU.bmrb.stardb.sdbException;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import gnu.getopt.Getopt;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class LoopTable {
    private String fName = "TMPLOOP";
    private int fId = -1;
    private Stardb fStar = null;
    private ErrorList fErrs = null;
    private List fTags = null;
    private int fRowIdx = -1;
    private StringBuffer fBuf = null;
    private int fVerbose = 0;
    private boolean fAddSfIds = false;

    public LoopTable(Stardb star) {
        this.fStar = star;
        this.init();
    }

    public LoopTable(Stardb star, ErrorList errs) {
        this.fStar = star;
        this.fErrs = errs;
        this.init();
    }

    public void init() {
        this.fTags = new ArrayList();
        this.fBuf = new StringBuffer();
    }

    public void setLoopId(int id) {
        this.fId = id;
    }

    public void setTableName(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        this.fName = name;
    }

    public Stardb getStar() {
        return this.fStar;
    }

    public ErrorList getErrs() {
        return this.fErrs;
    }

    public boolean getSfIDFlag() {
        return this.fAddSfIds;
    }

    public void setSfIDFlag(boolean flag) {
        this.fAddSfIds = flag;
    }

    public int getVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(int verbose) {
        this.fVerbose = verbose;
    }

    public boolean load() {
        this.fRowIdx = -1;
        try {
            this.getLoopTags();
        }
        catch (Exception e) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, -1, -1, -1, "DB exception, check error output"));
            }
            System.err.println("Cannot fetch loop tags");
            System.err.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
        try {
            if (this.fStar.isOracle()) {
                this.createTable_oracle();
            } else {
                this.createTable();
            }
        }
        catch (Exception e) {
            System.err.println("Cannot create temporary table");
            System.err.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
        try {
            this.loadTable();
        }
        catch (Exception e) {
            System.err.println("Cannot populate temporary table");
            System.err.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void getLoopTags() throws SQLException, sdbException {
        int i;
        Tag t;
        if (!this.fStar.hasDictionary()) {
            throw new sdbException("Dictionary is not loaded");
        }
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT t.ID,t.NAME,t.SEQ,s.CATEGORY FROM ENTRYTAGS t,ENTRYSFS s ");
        this.fBuf.append("WHERE t.LOOPID=");
        this.fBuf.append(this.fId);
        this.fBuf.append(" AND t.SFID=s.ID ORDER BY t.SEQ");
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery(this.fBuf.toString());
        if (!rs.next()) {
            throw new sdbException("Loop with no tags");
        }
        this.fTags.clear();
        String tagcat = null;
        String sfcat = null;
        int pos = -1;
        boolean have_sfcat = false;
        do {
            if (this.fVerbose > 2) {
                System.err.println("Loop " + this.fId + ", tag " + rs.getString(2) + ", id " + rs.getInt(1));
            }
            rs.getInt(3);
            if (rs.wasNull()) {
                if (this.fVerbose > 2) {
                    System.err.println("*** invalid tag");
                }
                t = new Tag();
                t.setId(rs.getInt(1));
                t.setName(rs.getString(2));
                this.fTags.add(t);
                continue;
            }
            if (have_sfcat) continue;
            sfcat = rs.getString(4);
            pos = rs.getString(2).indexOf(46);
            if (pos >= 0) {
                tagcat = rs.getString(2).substring(0, pos + 1);
                have_sfcat = true;
                continue;
            }
            t = new Tag();
            t.setId(rs.getInt(1));
            t.setName(rs.getString(2));
            this.fTags.add(t);
        } while (rs.next());
        if (this.fVerbose > 2) {
            System.err.println("Loop " + this.fId + ", tagcat " + tagcat + ", sfcat " + sfcat);
        }
        if (tagcat != null && sfcat != null) {
            this.fBuf.setLength(0);
            this.fBuf.append("SELECT TAGNAME,SEQ FROM TAGS WHERE TAGNAME LIKE '");
            this.fBuf.append(tagcat);
            this.fBuf.append("%' AND LOOPFLAG='Y' AND SFCAT='");
            this.fBuf.append(sfcat);
            this.fBuf.append('\'');
            if (!this.fAddSfIds) {
                this.fBuf.append(" AND SFIDFLAG<>'Y'");
            }
            this.fBuf.append(" ORDER BY SEQ");
            rs = query.executeQuery(this.fBuf.toString());
            if (!rs.next()) {
                throw new sdbException("Loop not in dictionary");
            }
            do {
                t = new Tag();
                t.setName(rs.getString(1));
                t.setSeq(rs.getInt(2));
                this.fTags.add(t);
            } while (rs.next());
        }
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT ID,SEQ,NAME FROM ENTRYTAGS WHERE LOOPID=");
        this.fBuf.append(this.fId);
        this.fBuf.append(" AND SEQ IS NOT NULL ORDER BY SEQ");
        rs = query.executeQuery(this.fBuf.toString());
        pos = 0;
        while (rs.next()) {
            int seq = rs.getInt(2);
            for (i = 0; i < this.fTags.size(); ++i) {
                if (((Tag)this.fTags.get(i)).getSeq() != seq) continue;
                ((Tag)this.fTags.get(i)).setId(rs.getInt(1));
            }
        }
        rs.close();
        query.close();
        pos = 0;
        for (i = 0; i < this.fTags.size(); ++i) {
            if (((Tag)this.fTags.get(i)).getId() >= 0) continue;
            pos = pos == 0 ? this.fStar.nextId("ENTRYTAGS") : ++pos;
            ((Tag)this.fTags.get(i)).setId(pos);
        }
        if (this.fVerbose > 2) {
            for (i = 0; i < this.fTags.size(); ++i) {
                System.err.println(this.fTags.get(i));
            }
        }
    }

    private boolean hasRowIndexes() {
        try {
            if (this.fRowIdx < 0) {
                this.fRowIdx = Entry.getRowIndexTagNumber(this.fStar, this.fId);
                if (this.fRowIdx < 0) {
                    if (this.fVerbose > 1) {
                        System.err.println("No row index tag on loop " + this.fId);
                    }
                    return true;
                }
            }
            boolean rc = true;
            this.fBuf.setLength(0);
            this.fBuf.append("SELECT VAL FROM ENTRYVALS WHERE VAL IS NOT NULL AND SEQ=");
            this.fBuf.append(this.fRowIdx);
            this.fBuf.append(" AND VAL<>'?' AND LOOPID=");
            this.fBuf.append(this.fId);
            Statement query = this.fStar.getQueryStatement();
            ResultSet rs = query.executeQuery(this.fBuf.toString());
            if (!rs.next()) {
                rc = false;
            }
            rs.close();
            query.close();
            if (this.fVerbose > 1) {
                System.err.println("hasRowIndexes returning " + rc);
            }
            return rc;
        }
        catch (Exception e) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, -1, -1, -1, "DB exception, check error output"));
            }
            System.err.println("Cannot check row indexes");
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return true;
        }
    }

    private void createTable_oracle() throws SQLException {
        int i;
        Statement stat = this.fStar.getStatement();
        this.fBuf.setLength(0);
        this.fBuf.append("DROP TABLE ");
        this.fBuf.append(this.fName);
        if (this.fStar.getEngineVersion() >= 10) {
            this.fBuf.append(" PURGE");
        }
        try {
            stat.executeUpdate(this.fBuf.toString());
            stat.getConnection().commit();
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        this.fBuf.setLength(0);
        this.fBuf.append("CREATE TABLE ");
        this.fBuf.append(this.fName);
        if (this.fStar.getEngineVersion() >= 10) {
            this.fBuf.append(" PURGE");
        }
        this.fBuf.append(" AS SELECT DISTINCT v.LOOPROW,");
        for (i = 0; i < this.fTags.size(); ++i) {
            this.fBuf.append('v');
            this.fBuf.append(i);
            this.fBuf.append(".VAL AS \"");
            this.fBuf.append(((Tag)this.fTags.get(i)).getId());
            this.fBuf.append('\"');
            if (i >= this.fTags.size() - 1) continue;
            this.fBuf.append(',');
        }
        this.fBuf.append(" FROM ENTRYVALS v,");
        for (i = 0; i < this.fTags.size(); ++i) {
            this.fBuf.append("ENTRYVALS v");
            this.fBuf.append(i);
            if (i >= this.fTags.size() - 1) continue;
            this.fBuf.append(',');
        }
        this.fBuf.append(" WHERE v.LOOPID=");
        this.fBuf.append(this.fId);
        for (i = 0; i < this.fTags.size(); ++i) {
            this.fBuf.append(" AND v");
            this.fBuf.append(i);
            this.fBuf.append(".TAGID=");
            this.fBuf.append(((Tag)this.fTags.get(i)).getId());
        }
        for (i = 0; i < this.fTags.size(); ++i) {
            this.fBuf.append(" AND v");
            this.fBuf.append(i);
            this.fBuf.append(".LOOPROW=v.LOOPROW");
        }
        if (this.fVerbose > 2) {
            System.err.println(this.fBuf);
        }
        stat.executeUpdate(this.fBuf.toString());
        stat.getConnection().commit();
        stat.close();
    }

    private void loadTable_oracle() throws SQLException, sdbException {
        Statement stat = this.fStar.getStatement();
        this.fBuf.setLength(0);
        this.fBuf.append("UPDATE ");
        this.fBuf.append(this.fName);
        this.fBuf.append(" t SET ");
        for (int i = 0; i < this.fTags.size(); ++i) {
            this.fBuf.append('\"');
            this.fBuf.append(((Tag)this.fTags.get(i)).getId());
            this.fBuf.append("\"=(SELECT VAL FROM ENTRYVALS v WHERE TAGID=");
            this.fBuf.append(((Tag)this.fTags.get(i)).getId());
            this.fBuf.append(" AND v.LOOPROW=t.LOOPROW)");
            if (i >= this.fTags.size() - 1) continue;
            this.fBuf.append(',');
        }
        if (this.fVerbose > 2) {
            System.err.println(this.fBuf);
        }
        stat.executeUpdate(this.fBuf.toString());
        stat.getConnection().commit();
        stat.close();
    }

    private void createTable() throws SQLException {
        Statement stat = this.fStar.getStatement();
        this.fBuf.setLength(0);
        this.fBuf.append("DROP TABLE ");
        this.fBuf.append(this.fName);
        try {
            stat.executeUpdate(this.fBuf.toString());
            stat.getConnection().commit();
        }
        catch (SQLException sqle) {
            // empty catch block
        }
        this.fBuf.setLength(0);
        this.fBuf.append("CREATE ");
        if (this.fStar.isHSQLDB()) {
            if (this.fStar.isCachedTables()) {
                this.fBuf.append("CACHED ");
            } else if (this.fStar.isTextTables()) {
                this.fBuf.append("TEXT ");
            }
        }
        this.fBuf.append("TABLE ");
        this.fBuf.append(this.fName);
        this.fBuf.append(" (LOOPROW INTEGER,");
        for (int i = 0; i < this.fTags.size(); ++i) {
            this.fBuf.append('\"');
            this.fBuf.append(((Tag)this.fTags.get(i)).getId());
            this.fBuf.append("\" ");
            this.fBuf.append(this.fStar.getValueType());
            if (i >= this.fTags.size() - 1) continue;
            this.fBuf.append(',');
        }
        this.fBuf.append(')');
        if (this.fVerbose > 2) {
            System.err.println(this.fBuf);
        }
        stat.executeUpdate(this.fBuf.toString());
        stat.getConnection().commit();
        stat.close();
    }

    private void loadTable() throws SQLException, sdbException {
        Statement query = this.fStar.getQueryStatement();
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT DISTINCT LOOPROW FROM ENTRYVALS WHERE LOOPID=");
        this.fBuf.append(this.fId);
        this.fBuf.append(" ORDER BY LOOPROW");
        ResultSet rs = query.executeQuery(this.fBuf.toString());
        int numrows = 0;
        this.fBuf.setLength(0);
        this.fBuf.append("INSERT INTO ");
        this.fBuf.append(this.fName);
        this.fBuf.append(" (LOOPROW) VALUES (?)");
        if (this.fVerbose > 2) {
            System.err.println(this.fBuf);
        }
        PreparedStatement pstat = this.fStar.getPreparedStatement(this.fBuf.toString());
        while (rs.next()) {
            pstat.setInt(1, rs.getInt(1));
            pstat.executeUpdate();
            ++numrows;
        }
        pstat.getConnection().commit();
        rs.close();
        pstat.close();
        query.close();
        for (int i = 0; i < this.fTags.size(); ++i) {
            int rowcount = this.insertColumn((Tag)this.fTags.get(i));
            if (numrows == rowcount) continue;
            if (this.fVerbose > 2) {
                System.err.println("Inserting column failed: loop " + this.fId + ", tag " + this.fTags.get(i) + ": numrows = " + numrows + ", rowcout = " + rowcount);
            }
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, -1, -1, -1, "DB exception, check error output"));
            }
            throw new sdbException("Error inserting column");
        }
    }

    private int insertColumn(Tag tag) throws SQLException {
        ResultSet rs;
        Statement query = this.fStar.getQueryStatement();
        Statement stat = this.fStar.getStatement();
        int rowcount = 0;
        this.fBuf.setLength(0);
        this.fBuf.append("UPDATE ");
        this.fBuf.append(this.fName);
        this.fBuf.append(" SET \"");
        this.fBuf.append(tag.getId());
        this.fBuf.append("\"=? WHERE LOOPROW=?");
        if (this.fVerbose > 2) {
            System.err.println(this.fBuf);
        }
        PreparedStatement pstat = this.fStar.getPreparedStatement(this.fBuf.toString());
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT VAL,LOOPROW FROM ENTRYVALS WHERE TAGID=");
        this.fBuf.append(tag.getId());
        this.fBuf.append(" ORDER BY LOOPROW");
        if (this.fVerbose > 2) {
            System.err.println(this.fBuf);
        }
        if ((rs = query.executeQuery(this.fBuf.toString())).next()) {
            do {
                pstat.setString(1, rs.getString(1));
                pstat.setInt(2, rs.getInt(2));
                if (this.fVerbose > 2) {
                    System.err.println(pstat);
                }
                pstat.executeUpdate();
                ++rowcount;
            } while (rs.next());
        } else {
            this.fBuf.setLength(0);
            this.fBuf.append("UPDATE ");
            this.fBuf.append(this.fName);
            this.fBuf.append(" SET \"");
            this.fBuf.append(tag.getId());
            this.fBuf.append("\"=NULL");
            if (this.fVerbose > 2) {
                System.err.println(this.fBuf);
            }
            rowcount = stat.executeUpdate(this.fBuf.toString());
            stat.getConnection().commit();
        }
        rs.close();
        pstat.getConnection().commit();
        pstat.close();
        stat.close();
        this.fBuf.setLength(0);
        return rowcount;
    }

    private int insertRowIndexes() {
        try {
            int id = -1;
            int rowcount = 0;
            for (int i = 0; i < this.fTags.size(); ++i) {
                if (this.fVerbose > 1) {
                    System.err.println("Inserting row indexes: loop " + this.fId + ", tag " + this.fTags.get(i) + " row idx " + this.fRowIdx);
                }
                if (((Tag)this.fTags.get(i)).getSeq() != this.fRowIdx) continue;
                id = ((Tag)this.fTags.get(i)).getId();
            }
            Statement stat = this.fStar.getStatement();
            if (id >= 0) {
                this.fBuf.setLength(0);
                this.fBuf.append("UPDATE ");
                this.fBuf.append(this.fName);
                this.fBuf.append(" SET \"");
                this.fBuf.append(id);
                this.fBuf.append("\"=(LOOPROW + 1)");
                if (this.fVerbose > 2) {
                    System.err.println(this.fBuf);
                }
                rowcount = stat.executeUpdate(this.fBuf.toString());
                stat.getConnection().commit();
                stat.close();
            }
            return rowcount;
        }
        catch (Exception e) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, -1, -1, -1, "Cannot insert row indexes, check error output"));
            }
            System.err.println("Cannot insert row indexes");
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return -1;
        }
    }

    private int[] getColumnWidths() throws SQLException {
        int i;
        int[] rc = null;
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = null;
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT ");
        for (i = 0; i < this.fTags.size(); ++i) {
            this.fBuf.append('\"');
            this.fBuf.append(((Tag)this.fTags.get(i)).getId());
            this.fBuf.append('\"');
            if (i >= this.fTags.size() - 1) continue;
            this.fBuf.append(", ");
        }
        this.fBuf.append(" FROM ");
        this.fBuf.append(this.fName);
        if (this.fVerbose > 2) {
            System.err.println(this.fBuf);
        }
        if ((rs = query.executeQuery(this.fBuf.toString())).next()) {
            rc = new int[this.fTags.size()];
            do {
                for (i = 0; i < this.fTags.size(); ++i) {
                    String val = QuoteString.quoteForSTAR(rs.getString(i + 1));
                    if (rs.wasNull() || val.length() <= rc[i]) continue;
                    rc[i] = val.length();
                }
            } while (rs.next());
            for (i = 0; i < rc.length; ++i) {
                rc[i] = rc[i] + 4;
            }
        }
        rs.close();
        query.close();
        return rc;
    }

    private int[] getColumnWidths_oracle() throws SQLException {
        int i;
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = null;
        int[] rc = new int[this.fTags.size()];
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT ");
        for (i = 0; i < this.fTags.size(); ++i) {
            this.fBuf.append("MAX(LENGTH(");
            this.fBuf.append('\"');
            this.fBuf.append(((Tag)this.fTags.get(i)).getId());
            this.fBuf.append('\"');
            this.fBuf.append("))");
            if (i >= this.fTags.size() - 1) continue;
            this.fBuf.append(',');
        }
        this.fBuf.append(" FROM ");
        this.fBuf.append(this.fName);
        if (this.fVerbose > 2) {
            System.err.println(this.fBuf);
        }
        if ((rs = query.executeQuery(this.fBuf.toString())).next()) {
            for (i = 0; i < this.fTags.size(); ++i) {
                if (this.fVerbose > 2) {
                    System.err.println("rc[" + i + "] = " + " col( " + (i + 1) + ") ");
                    System.err.println(rs.getInt(i + 1));
                }
                rc[i] = rs.getInt(i + 1);
                if (!rs.wasNull()) continue;
                rc[i] = 0;
            }
        }
        rs.close();
        query.close();
        for (i = 0; i < rc.length; ++i) {
            rc[i] = rc[i] + 4;
        }
        return rc;
    }

    private int[] getColumnWidths_oracle_10() throws SQLException {
        int i;
        int[] rc = new int[this.fTags.size()];
        int numtags = 0;
        for (i = 0; i < this.fTags.size(); ++i) {
            if (((Tag)this.fTags.get(i)).getId() < 0) continue;
            ++numtags;
        }
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT ");
        for (i = 0; i < numtags; ++i) {
            this.fBuf.append("MAX(LENGTH(v");
            this.fBuf.append(i);
            this.fBuf.append(".VAL))");
            if (i >= numtags - 1) continue;
            this.fBuf.append(',');
        }
        this.fBuf.append(" FROM ");
        for (i = 0; i < numtags; ++i) {
            this.fBuf.append("ENTRYVALS v");
            this.fBuf.append(i);
            if (i >= numtags - 1) continue;
            this.fBuf.append(',');
        }
        this.fBuf.append(" WHERE ");
        int j = 0;
        for (i = 0; i < this.fTags.size(); ++i) {
            if (((Tag)this.fTags.get(i)).getId() < 0) continue;
            this.fBuf.append('v');
            this.fBuf.append(j);
            this.fBuf.append(".TAGID=");
            this.fBuf.append(((Tag)this.fTags.get(i)).getId());
            this.fBuf.append(" AND v");
            this.fBuf.append(j);
            this.fBuf.append(".LOOPID = v0.LOOPID");
            if (j < numtags - 1) {
                this.fBuf.append(" AND ");
            }
            ++j;
        }
        if (this.fVerbose > 2) {
            System.err.println(this.fBuf);
        }
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery(this.fBuf.toString());
        j = 1;
        if (rs.next()) {
            for (i = 0; i < this.fTags.size(); ++i) {
                if (((Tag)this.fTags.get(i)).getId() < 0) {
                    rc[i] = 0;
                    continue;
                }
                rc[i] = rs.getInt(j);
                ++j;
                if (!rs.wasNull()) continue;
                rc[i] = 0;
            }
        }
        rs.close();
        query.close();
        for (i = 0; i < rc.length; ++i) {
            rc[i] = rc[i] + 4;
        }
        return rc;
    }

    public void print(PrintWriter out) throws SQLException {
        if (this.fStar.getReindexLoops() && !this.hasRowIndexes()) {
            this.insertRowIndexes();
        }
        this.printLoop(out);
    }

    private void printLoop(PrintWriter out) throws SQLException {
        int i;
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = null;
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT PRECOMMENT FROM ENTRYLOOPS WHERE ID=");
        this.fBuf.append(this.fId);
        out.println();
        if (this.fVerbose > 2) {
            System.err.println(this.fBuf);
        }
        if ((rs = query.executeQuery(this.fBuf.toString())).next()) {
            String tmp = rs.getString(1);
            if (!rs.wasNull()) {
                out.println(tmp);
            }
        }
        for (i = 0; i < 4; ++i) {
            out.print(" ");
        }
        out.print("loop_");
        this.printLoopTags(out);
        out.println();
        this.printLoopBody(out);
        for (i = 0; i < 4; ++i) {
            out.print(" ");
        }
        out.println("stop_\n");
        rs.close();
        query.close();
    }

    private void printLoopTags(PrintWriter out) throws SQLException {
        PreparedStatement pstat = this.fStar.getPreparedQuery("SELECT PRECOMMENT FROM ENTRYTAGS WHERE ID=?");
        ResultSet rs = null;
        for (int i = 0; i < this.fTags.size(); ++i) {
            int j;
            pstat.setInt(1, ((Tag)this.fTags.get(i)).getId());
            rs = pstat.executeQuery();
            if (rs.next()) {
                String tmp = rs.getString(1);
                if (!rs.wasNull()) {
                    for (j = 0; j < 4; ++j) {
                        out.print(" ");
                    }
                    out.print(tmp);
                }
            }
            out.println();
            for (j = 0; j < 8; ++j) {
                out.print(" ");
            }
            out.print(((Tag)this.fTags.get(i)).getName());
        }
        out.println();
        if (rs != null) {
            rs.close();
        }
        pstat.close();
    }

    private void printLoopBody(PrintWriter out) throws SQLException {
        int i;
        int[] widths = this.fStar.isOracle() || this.fStar.isHSQLDB() ? this.getColumnWidths_oracle() : this.getColumnWidths();
        if (widths == null) {
            return;
        }
        boolean has_dict = false;
        boolean[] framecodes = null;
        if (this.fStar.hasDictionary()) {
            has_dict = true;
        }
        if (has_dict) {
            framecodes = new boolean[this.fTags.size()];
            for (i = 0; i < this.fTags.size(); ++i) {
                try {
                    framecodes[i] = Entry.isFramecode(this.fStar, ((Tag)this.fTags.get(i)).getId());
                    continue;
                }
                catch (sdbException e) {
                    framecodes[i] = false;
                }
            }
        }
        StringBuffer row = new StringBuffer();
        StringBuffer val = new StringBuffer();
        ResultSet commentRs = null;
        PreparedStatement commentStat = this.fStar.getPreparedQuery("SELECT DISTINCT PRECOMMENT FROM ENTRYVALS WHERE PRECOMMENT IS NOT NULL AND TAGID=? AND LOOPROW=?");
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT DISTINCT LOOPROW, ");
        for (i = 0; i < this.fTags.size(); ++i) {
            this.fBuf.append('\"');
            this.fBuf.append(((Tag)this.fTags.get(i)).getId());
            this.fBuf.append('\"');
            if (i >= this.fTags.size() - 1) continue;
            this.fBuf.append(',');
        }
        this.fBuf.append(" FROM ");
        this.fBuf.append(this.fName);
        this.fBuf.append(" ORDER BY LOOPROW");
        Statement query = this.fStar.getQueryStatement();
        if (this.fVerbose > 2) {
            System.err.println(this.fBuf);
        }
        ResultSet rs = query.executeQuery(this.fBuf.toString());
        while (rs.next()) {
            row.setLength(0);
            for (i = 0; i < 8; ++i) {
                row.append(' ');
            }
            int length = 0;
            for (i = 0; i < this.fTags.size(); ++i) {
                int j;
                int qstyle;
                val.setLength(0);
                String tmp = rs.getString(i + 2);
                if (rs.wasNull()) {
                    tmp = ".";
                }
                if (tmp.equals(".") || tmp.equals("?")) {
                    qstyle = 13;
                    val.append(tmp);
                } else {
                    qstyle = QuoteString.findSTARQuoteStyle(tmp);
                    boolean fc = has_dict ? framecodes[i] : this.isFramecode(((Tag)this.fTags.get(i)).getId(), rs.getInt(1));
                    if (fc) {
                        val.append('$');
                        val.append(tmp.replaceAll("\\s+", "_"));
                    } else {
                        val.append(QuoteString.quoteForSTAR(tmp));
                    }
                }
                if (qstyle == 11) {
                    val.append("\n");
                    length = 0;
                } else {
                    length = val.length();
                }
                if (this.fVerbose > 2) {
                    System.err.println(tmp + ", " + val);
                }
                row.append(val);
                if (length > 0) {
                    for (j = length; j < widths[i]; ++j) {
                        row.append(' ');
                    }
                    continue;
                }
                for (j = 0; j < 4; ++j) {
                    row.append(' ');
                }
            }
            val.setLength(0);
            for (i = 0; i < this.fTags.size(); ++i) {
                commentStat.setInt(1, ((Tag)this.fTags.get(i)).getId());
                commentStat.setInt(2, rs.getInt(1));
                commentRs = commentStat.executeQuery();
                if (!commentRs.next()) continue;
                val.append(' ');
                val.append(commentRs.getString(1));
            }
            if (val.length() > 0) {
                row.append(val);
            }
            out.println(row);
        }
        rs.close();
        if (commentRs != null) {
            commentRs.close();
        }
        query.close();
        commentStat.close();
        out.println();
    }

    private boolean isFramecode(int tagid, int row) throws SQLException {
        boolean rc = false;
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT DELIMITER FROM ENTRYVALS WHERE TAGID=");
        this.fBuf.append(tagid);
        this.fBuf.append(" AND LOOPROW=");
        this.fBuf.append(row);
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery(this.fBuf.toString());
        if (rs.next() && rs.getInt(1) == 12) {
            rc = true;
        }
        rs.close();
        query.close();
        return rc;
    }

    public static void usage() {
        System.out.print("Usage: java EDU.bmrb.stardb.LoopTable <-l NUM> [-c FILE]");
        System.out.println(" [-o FILE] [-a] [-s] [-i] [-h] [-v]");
        System.out.println("   -h: print this usage summary");
        System.out.println("   -l NUM: loop number in the file, counting from 0 (required)");
        System.out.print("   -c FILE: use config file FILE instead of ~/");
        System.out.println("stardb.properties");
        System.out.println("   -o FILE: output file (default: stdout)");
        System.out.println("   -s: sort tags by sequence number");
        System.out.println("   -i: add row index if not already there");
        System.out.println("   -v: verbose (use multiple -v's to see more debugging messages)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        long now = System.currentTimeMillis();
        PrintWriter out = null;
        Stardb star = null;
        try {
            int opt;
            String conffile = null;
            String outfile = null;
            int num = -1;
            int verbose = 0;
            boolean sort = false;
            boolean index = false;
            boolean atom_sort = false;
            Getopt g = new Getopt("LoopTable", args, "c:o:l:ahisv");
            block17: while ((opt = g.getopt()) != -1) {
                switch (opt) {
                    case 97: {
                        atom_sort = true;
                        continue block17;
                    }
                    case 99: {
                        conffile = g.getOptarg();
                        continue block17;
                    }
                    case 105: {
                        index = true;
                        continue block17;
                    }
                    case 108: {
                        num = Integer.parseInt(g.getOptarg());
                        continue block17;
                    }
                    case 111: {
                        outfile = g.getOptarg();
                        continue block17;
                    }
                    case 115: {
                        sort = true;
                        continue block17;
                    }
                    case 118: {
                        ++verbose;
                        continue block17;
                    }
                }
                LoopTable.usage();
                return;
            }
            if (num < 0) {
                LoopTable.usage();
                return;
            }
            System.err.println("Init. StarDB");
            star = conffile == null ? new Star_DB() : new Star_DB(conffile);
            star.setSortTags(sort);
            star.setReindexLoops(index);
            star.setSortAtoms(atom_sort);
            System.err.println("open outfile");
            out = outfile == null ? new PrintWriter(System.out) : new PrintWriter(new FileOutputStream(outfile));
            System.err.println("Connecting to DB");
            star.connect(false);
            System.err.println("Init. LoopTable");
            LoopTable lt = new LoopTable(star);
            lt.setLoopId(num);
            lt.setVerbose(verbose);
            if (!lt.load()) {
                star.disconnect();
                return;
            }
            lt.print(out);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                out.flush();
            }
            if (star != null) {
                star.disconnect();
            }
            System.err.println("Elapsed: " + (System.currentTimeMillis() - now));
        }
    }
}

