/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.stardb;

import EDU.bmrb.stardb.Stardb;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Properties;

public class Star_DB
implements Stardb {
    private Properties fProps = null;
    private Connection fConn = null;
    private boolean fConnected = false;
    private boolean fBatch = false;
    private int fServer = -1;
    private int fVersion = -1;
    private int fValSize = -1;
    private int fCommSize = -1;
    private boolean fSortTags = false;
    private boolean fReindexLoops = false;
    private boolean fSortAtoms = false;
    private boolean fAddComments = true;
    private StringBuffer fBuf = null;

    public static final int strlen(String str) {
        if (str == null) {
            return 0;
        }
        return str.length();
    }

    public Star_DB() {
        this.fProps = new Properties();
        this.fBuf = new StringBuffer();
        this.fBuf.append(System.getProperty("user.home"));
        this.fBuf.append(File.separatorChar);
        this.fBuf.append("stardb.properties");
        this.loadProperties(this.fBuf.toString());
    }

    public Star_DB(String name) {
        this.fProps = new Properties();
        this.fBuf = new StringBuffer();
        this.loadProperties(name);
    }

    public Star_DB(Properties props) {
        this.fProps = props;
        this.fBuf = new StringBuffer();
    }

    private boolean loadProperties(String file) {
        try {
            FileInputStream in = new FileInputStream(file);
            this.fProps.load(in);
        }
        catch (Exception e) {
            System.err.println("Cannot load configuraton file");
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public Properties getProperties() {
        return this.fProps;
    }

    public void setProperties(Properties props) {
        this.fProps = props;
    }

    public String getProperty(String key) {
        return this.fProps.getProperty(key);
    }

    public boolean getSortTags() {
        return this.fSortTags;
    }

    public void setSortTags(boolean flag) {
        this.fSortTags = flag;
    }

    public boolean getReindexLoops() {
        return this.fReindexLoops;
    }

    public void setReindexLoops(boolean flag) {
        this.fReindexLoops = flag;
    }

    public boolean getSortAtoms() {
        return this.fSortAtoms;
    }

    public void setSortAtoms(boolean flag) {
        this.fSortAtoms = flag;
    }

    public boolean getAddComments() {
        return this.fAddComments;
    }

    public void setAddComments(boolean flag) {
        this.fAddComments = flag;
    }

    public boolean isHSQLDB() {
        return this.fServer == 0;
    }

    public boolean isOracle() {
        return this.fServer == 1;
    }

    public boolean isFirebird() {
        return this.fServer == 2;
    }

    public boolean isMimer() {
        return this.fServer == 3;
    }

    public boolean isPostgres() {
        return this.fServer == 4;
    }

    public boolean isMySQL() {
        return this.fServer == 5;
    }

    public int getEngineVersion() {
        return this.fVersion;
    }

    public boolean isConnected() {
        return this.fConnected;
    }

    public boolean isCachedTables() {
        String str;
        return this.isHSQLDB() && (str = this.fProps.getProperty("HSQL.cachedTables")) != null && str.length() > 0 && str.toUpperCase().equals("YES");
    }

    public boolean isTextTables() {
        String str;
        return this.isHSQLDB() && (str = this.fProps.getProperty("HSQL.textTables")) != null && str.length() > 0 && str.toUpperCase().equals("YES");
    }

    public boolean hasDictionary() throws SQLException {
        ResultSet rs;
        Statement query = this.fConn.createStatement(1003, 1007);
        try {
            rs = query.executeQuery("SELECT DICTFLAG FROM INFO");
        }
        catch (SQLException e) {
            query.close();
            return false;
        }
        boolean rc = true;
        if (!rs.next()) {
            rc = false;
        } else if (rs.getString(1).charAt(0) != 'Y') {
            rc = false;
        }
        rs.close();
        query.close();
        return rc;
    }

    public String getValueType() {
        StringBuffer buf = new StringBuffer("VARCHAR(");
        if (this.fValSize > 0) {
            buf.append(this.fValSize);
            buf.append(')');
            return buf.toString();
        }
        String rc = this.fProps.getProperty("Value.type");
        if (rc != null && rc.length() > 0) {
            return rc;
        }
        buf.append("127)");
        return buf.toString();
    }

    public int getValueSize() {
        return this.fValSize;
    }

    public int getCommentSize() {
        return this.fCommSize;
    }

    public void setValueSize(int size) {
        this.fValSize = size;
    }

    public Statement getQueryStatement() {
        try {
            return this.fConn.createStatement(1003, 1007);
        }
        catch (SQLException e) {
            System.err.println("Cannot create statement");
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return null;
        }
    }

    public Statement getStatement() {
        try {
            return this.fConn.createStatement();
        }
        catch (SQLException e) {
            System.err.println("Cannot create statement");
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return null;
        }
    }

    public PreparedStatement getPreparedStatement(String sql) {
        try {
            return this.fConn.prepareStatement(sql);
        }
        catch (SQLException e) {
            System.err.println("Cannot prepare statement");
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return null;
        }
    }

    public PreparedStatement getPreparedQuery(String sql) {
        try {
            return this.fConn.prepareStatement(sql, 1003, 1007);
        }
        catch (SQLException e) {
            System.err.println("Cannot prepare statement");
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return null;
        }
    }

    public PreparedStatement getPreparedUpdate(String sql) {
        try {
            return this.fConn.prepareStatement(sql, 1003, 1008);
        }
        catch (SQLException e) {
            System.err.println("Cannot prepare statement");
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return null;
        }
    }

    public void setConnection(Connection conn) {
        if (conn != null) {
            this.fConn = conn;
            this.fConnected = true;
            this.checkDB();
        }
    }

    public Connection getConnection() {
        return this.fConn;
    }

    public boolean connect(boolean autocommit) {
        return this.openDB(autocommit);
    }

    public boolean openDB(boolean autocommit) {
        try {
            if (this.fConn != null && !this.fConn.isClosed()) {
                return true;
            }
            String str = this.fProps.getProperty("DB.Driver");
            if (str == null || str.equals("")) {
                System.err.println("No database driver");
                return false;
            }
            Class.forName(str).newInstance();
            String url = this.fProps.getProperty("DB.Url");
            if (url == null || url.length() == 0) {
                System.err.println("No database URL");
                return false;
            }
            this.fConn = DriverManager.getConnection(url, this.fProps.getProperty("DB.User"), this.fProps.getProperty("DB.Password"));
            this.fConn.setAutoCommit(autocommit);
            this.fConnected = true;
            this.checkDB();
            if (this.isHSQLDB() && this.fVersion >= 7) {
                try {
                    Statement stat = this.fConn.createStatement();
                    stat.executeUpdate("SET WRITE_DELAY TRUE");
                    stat.executeUpdate("SET PROPERTY \"hsqldb.cache_scale\" 8");
                    stat.executeUpdate("SET LOGSIZE 0");
                    this.fConn.commit();
                    stat.executeUpdate("SHUTDOWN");
                    this.fConnected = false;
                    this.fConn = null;
                    this.fConn = DriverManager.getConnection(url, this.fProps.getProperty("DB.User"), this.fProps.getProperty("DB.Password"));
                    this.fConn.setAutoCommit(autocommit);
                    this.fConnected = true;
                }
                catch (SQLException ex) {
                    System.err.println(ex.getLocalizedMessage());
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean disconnect() {
        return this.closeDB();
    }

    public boolean close() {
        return this.closeDB();
    }

    public boolean closeDB() {
        if (this.fConn == null) {
            return false;
        }
        try {
            this.fConn.close();
            this.fConn = null;
            this.fConnected = false;
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void checkDB() {
        try {
            DatabaseMetaData md = this.fConn.getMetaData();
            this.fBatch = md.supportsBatchUpdates();
            String dbname = md.getDatabaseProductName();
            for (int i = 0; i < SERVER_NAMES.length; ++i) {
                if (!dbname.equals(SERVER_NAMES[i])) continue;
                this.fServer = i;
                break;
            }
            if (this.fServer == 0) {
                this.fVersion = md.getDatabaseMinorVersion();
            } else if (this.fServer == 1) {
                String tmp = md.getDatabaseProductVersion();
                int pos = tmp.indexOf("Release");
                if (pos > -1) {
                    this.fVersion = tmp.charAt(pos + 9) == '8' ? 8 : (tmp.charAt(pos + 9) == '1' && tmp.charAt(pos + 10) == '0' ? 10 : -1);
                }
            } else {
                this.fVersion = md.getDatabaseMajorVersion();
            }
            if (this.isHSQLDB()) {
                Statement stat = this.fConn.createStatement();
                stat.executeUpdate("CREATE ALIAS LENGTH FOR \"EDU.bmrb.stardb.Star_DB.strlen\"");
                this.fConn.commit();
            }
            Statement query = this.getQueryStatement();
            try {
                ResultSet rs = query.executeQuery("SELECT VAL,PRECOMMENT FROM ENTRYVALS");
                ResultSetMetaData rmd = rs.getMetaData();
                this.fValSize = rmd.getColumnDisplaySize(1);
                this.fCommSize = rmd.getColumnDisplaySize(2);
            }
            catch (SQLException e) {}
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    public boolean canBatch() {
        return this.fBatch;
    }

    public int getIdValue(String table) {
        int i = -1;
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT MAX(ID) FROM ");
        this.fBuf.append(table);
        try {
            Statement stat = this.getQueryStatement();
            ResultSet rs = stat.executeQuery(this.fBuf.toString());
            if (rs.next()) {
                i = rs.getInt(1);
                if (rs.wasNull()) {
                    i = -1;
                }
            }
            rs.close();
            stat.close();
        }
        catch (Exception e) {
            this.fBuf.append(": Cannot fetch ID from ");
            this.fBuf.append(table);
            System.err.println(this.fBuf.toString());
            System.err.println(e.getMessage());
            e.printStackTrace();
            i = -1;
        }
        return i;
    }

    public int nextId(String table) {
        int rc = this.getIdValue(table);
        if (rc < 0) {
            return 0;
        }
        return rc + 1;
    }

    public String toString() {
        this.fBuf.setLength(0);
        Enumeration<?> e = this.fProps.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.fBuf.append(key);
            this.fBuf.append(": ");
            this.fBuf.append(this.fProps.getProperty(key));
            this.fBuf.append("\n");
        }
        return this.fBuf.toString();
    }

    public static void main(String[] args) {
        Star_DB s = args.length > 0 ? new Star_DB(args[0]) : new Star_DB();
        System.out.println(s);
    }
}

