/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.stardb;

import EDU.bmrb.sansj.ErrorHandler;
import EDU.bmrb.sansj.STARLexer;
import EDU.bmrb.sansj.SimpleStarParser;
import EDU.bmrb.sansj.StarContentHandler;
import EDU.bmrb.sansj.starlib.DataNameNode;
import EDU.bmrb.sansj.starlib.DataValueNode;
import EDU.bmrb.sansj.starlib.StarNode;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Vector;

public class ToCSV
implements StarContentHandler,
ErrorHandler {
    private ErrorList fErrs = null;
    private PrintWriter fInfo = new PrintWriter(new FileOutputStream("entryinfo.csv"));
    private PrintWriter fSfs = new PrintWriter(new FileOutputStream("entrysfs.csv"));
    private int fSfId = -1;
    private PrintWriter fLoops = new PrintWriter(new FileOutputStream("entryloops.csv"));
    private int fLoopId = -1;
    private boolean fInLoop = false;
    private PrintWriter fTags = new PrintWriter(new FileOutputStream("entrytags.csv"));
    private int fTagId = -1;
    private Vector fLoopTags = new Vector();
    private PrintWriter fVals = new PrintWriter(new FileOutputStream("entryvals.csv"));
    private int fValId = -1;
    private int fLoopCol = -1;
    private int fLoopRow = 0;

    public static void usage() {
        System.out.println("Usage: java EDU.bmrb.stardb.ToCSV [-c FILE] [-i FILE] [-h]");
        System.out.print(" -c FILE: config FILE, default: ~/");
        System.out.println("stardb.properties");
        System.out.println(" -i FILE: input FILE, default: stdin");
        System.out.println(" -h: print this message and exit");
    }

    public static void main(String[] args) {
        try {
            int opt;
            Getopt g = new Getopt("tocsv", args, "hc:i:");
            String conffile = null;
            String infile = null;
            boolean create_schema = true;
            block7: while ((opt = g.getopt()) != -1) {
                switch (opt) {
                    case 104: {
                        ToCSV.usage();
                        return;
                    }
                    case 99: {
                        conffile = g.getOptarg();
                        continue block7;
                    }
                    case 105: {
                        infile = g.getOptarg();
                        continue block7;
                    }
                }
                ToCSV.usage();
                return;
            }
            long now = System.currentTimeMillis();
            ToCSV ldr = new ToCSV();
            InputStream sin = infile == null ? System.in : new FileInputStream(infile);
            BufferedReader in = new BufferedReader(new InputStreamReader(sin));
            STARLexer lex = new STARLexer(in);
            SimpleStarParser parser = new SimpleStarParser(lex, ldr, ldr);
            parser.parse();
            System.out.println("Elapsed: " + (System.currentTimeMillis() - now));
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    public void error(int line, int col, String msg) {
        if (this.fErrs != null) {
            this.fErrs.add(new Error(true, -1, -1, line, msg));
        } else {
            System.err.println("Parse error in line " + line + ", col " + col + ": " + msg);
        }
    }

    public boolean warning(int line, int col, String msg) {
        if (this.fErrs != null) {
            this.fErrs.add(new Error(false, -1, -1, line, msg));
        } else {
            System.err.println("Parse warning in line " + line + ", col " + col + ": " + msg);
        }
        return false;
    }

    public boolean startData(StarNode node) {
        try {
            this.fInfo.print(node.getValue());
            this.fInfo.print(',');
            this.fInfo.print(node.getLineNum());
            this.fInfo.print(',');
            this.fInfo.print(node.getColNum());
            this.fInfo.print(',');
            if (node.getPreComment() != null) {
                this.fInfo.print(node.getPreComment());
            }
            this.fInfo.println(',');
            return false;
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return true;
        }
    }

    public void endData(StarNode node) {
        try {
            this.fInfo.close();
            this.fSfs.close();
            this.fLoops.close();
            this.fTags.close();
            this.fVals.close();
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    public boolean startSaveFrame(StarNode node) {
        try {
            ++this.fSfId;
            this.fSfs.print(this.fSfId);
            this.fSfs.print(',');
            this.fSfs.print(',');
            this.fSfs.print(',');
            this.fSfs.print(node.getValue());
            this.fSfs.print(',');
            this.fSfs.print(node.getLineNum());
            this.fSfs.print(',');
            this.fSfs.print(node.getColNum());
            this.fSfs.print(',');
            if (node.getPreComment() != null) {
                this.fSfs.print(node.getPreComment());
            }
            this.fSfs.println(',');
            return false;
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return true;
        }
    }

    public boolean endSaveFrame(StarNode node) {
        return false;
    }

    public boolean startLoop(StarNode node) {
        try {
            this.fInLoop = true;
            this.fLoopRow = 0;
            this.fLoopCol = -1;
            ++this.fLoopId;
            this.fLoops.print(this.fLoopId);
            this.fLoops.print(',');
            this.fLoops.print(this.fSfId);
            this.fLoops.print(',');
            this.fLoops.print(node.getLineNum());
            this.fLoops.print(',');
            this.fLoops.print(node.getColNum());
            this.fLoops.print(',');
            if (node.getPreComment() != null) {
                this.fLoops.print(node.getPreComment());
            }
            this.fLoops.println(',');
            this.fLoopTags.clear();
            return false;
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return true;
        }
    }

    public boolean endLoop(StarNode node) {
        this.fInLoop = false;
        return false;
    }

    public boolean tag(DataNameNode node) {
        try {
            ++this.fTagId;
            if (this.fInLoop) {
                this.fLoopTags.addElement(new Integer(this.fTagId));
            }
            this.fTags.print(this.fTagId);
            this.fTags.print(',');
            this.fTags.print(this.fSfId);
            this.fTags.print(',');
            if (this.fInLoop) {
                this.fTags.print(this.fLoopId);
            }
            this.fTags.print(',');
            this.fTags.print(',');
            this.fTags.print(node.getValue());
            this.fTags.print(',');
            this.fTags.print(node.getLineNum());
            this.fTags.print(',');
            this.fTags.print(node.getColNum());
            this.fTags.print(',');
            if (node.getPreComment() != null) {
                this.fTags.print(node.getPreComment());
            }
            this.fTags.println(',');
            return false;
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return true;
        }
    }

    public boolean data(DataValueNode node) {
        try {
            int tagid;
            ++this.fValId;
            if (this.fInLoop) {
                ++this.fLoopCol;
                if (this.fLoopCol == this.fLoopTags.size()) {
                    this.fLoopCol = 0;
                    ++this.fLoopRow;
                }
                tagid = (Integer)this.fLoopTags.elementAt(this.fLoopCol);
            } else {
                tagid = this.fTagId;
            }
            this.fVals.print(this.fValId);
            this.fVals.print(',');
            this.fVals.print(tagid);
            this.fVals.print(',');
            if (this.fInLoop) {
                this.fVals.print(this.fLoopId);
            }
            this.fVals.print(',');
            this.fVals.print(',');
            String tmp = node.getValue().trim();
            if (!tmp.equals(".")) {
                if (tmp.indexOf("\n") > -1) {
                    this.fVals.print('\"');
                    tmp = tmp.replaceAll("\\p{Blank}{2,}", " ");
                    tmp = tmp.replaceAll("\n\\p{Blank}", "\n");
                    this.fVals.print(tmp);
                    this.fVals.print('\"');
                } else {
                    this.fVals.print(node.getValue());
                }
            }
            this.fVals.print(',');
            this.fVals.print(node.getDelimType());
            this.fVals.print(',');
            this.fVals.print(node.getLineNum());
            this.fVals.print(',');
            this.fVals.print(node.getColNum());
            this.fVals.print(',');
            if (this.fInLoop) {
                this.fVals.print(this.fLoopRow);
            }
            this.fVals.print(',');
            if (node.getPreComment() != null) {
                this.fVals.print(node.getPreComment());
            }
            this.fVals.println(",|");
            return false;
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return true;
        }
    }
}

