/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.stardb;

import EDU.bmrb.stardb.AddDataTags;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.stardb.UnparseToStarlib;
import EDU.bmrb.starlibj.BlockNode;
import EDU.bmrb.starlibj.StarUnparser;
import EDU.bmrb.validator.ErrorList;
import gnu.getopt.Getopt;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class UnparseEntry {
    private static final boolean DEBUG = false;

    public static void usage() {
        System.out.println("Usage: java EDU.bmrb.stardb.UnparseEntry [-h] [-c FILE] [-i FILE] [-o FILE] [-r] [-s] [-x]");
        System.out.println("   -h: print this usage summary");
        System.out.println("   -c FILE: use config file FILE instead of ~/validator.properties");
        System.out.println("   -i FILE: input file (default: stdin)");
        System.out.println("   -o FILE: output file (default: stdout)");
        System.out.println("   -r: \"release\" output: do not strip Sf_ID tags");
        System.out.println("   -s: sort saveframes and tags by dictionary sequence");
        System.out.println("   -x: add loop row indexes if not already there");
    }

    public static void main(String[] args) {
        long now = System.currentTimeMillis();
        try {
            int opt;
            String conffile = null;
            String infile = null;
            String outfile = null;
            boolean strip_sfids = true;
            boolean sort = false;
            boolean reindex = false;
            Getopt g = new Getopt("Unparse", args, "c:i:o:hrsx");
            block10: while ((opt = g.getopt()) != -1) {
                switch (opt) {
                    case 99: {
                        conffile = g.getOptarg();
                        continue block10;
                    }
                    case 105: {
                        infile = g.getOptarg();
                        continue block10;
                    }
                    case 111: {
                        outfile = g.getOptarg();
                        continue block10;
                    }
                    case 114: {
                        strip_sfids = false;
                        continue block10;
                    }
                    case 115: {
                        sort = true;
                        continue block10;
                    }
                    case 120: {
                        reindex = true;
                        continue block10;
                    }
                }
                UnparseEntry.usage();
                return;
            }
            Star_DB star = conffile == null ? new Star_DB() : new Star_DB(conffile);
            star.setSortTags(sort);
            star.setReindexLoops(reindex);
            star.connect(false);
            System.err.println("DB open: " + (System.currentTimeMillis() - now));
            now = System.currentTimeMillis();
            ErrorList errs = new ErrorList();
            BlockNode data = UnparseToStarlib.createDataNode(star, strip_sfids);
            AddDataTags adt = new AddDataTags(data, (Stardb)star, strip_sfids);
            adt.setErrorList(errs);
            InputStreamReader in = infile == null ? new InputStreamReader(System.in, "ISO-8859-15") : new InputStreamReader((InputStream)new FileInputStream(infile), "ISO-8859-15");
            adt.parse(in);
            star.disconnect();
            StarUnparser unp = outfile == null ? new StarUnparser(System.out) : new StarUnparser(new FileOutputStream(outfile));
            unp.writeOut(data, 0);
            if (errs.size() > 0) {
                errs.printErrors(System.out);
            }
            System.err.println("Done: " + (System.currentTimeMillis() - now));
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }
}

