/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.starlibj;

import EDU.bmrb.starlibj.LoopNameListNode;
import EDU.bmrb.starlibj.NameListVector;
import EDU.bmrb.starlibj.RemoteInt;
import EDU.bmrb.starlibj.StarNode;
import EDU.bmrb.starlibj.StarValidity;
import EDU.bmrb.starlibj.VectorCheckType;
import java.util.Enumeration;

public class DataLoopNameListNode
extends StarNode
implements Cloneable {
    NameListVector myRows = new NameListVector();

    public DataLoopNameListNode() {
    }

    public DataLoopNameListNode(DataLoopNameListNode copyMe) {
        super(copyMe);
        for (int i = 0; i < copyMe.size(); ++i) {
            this.addElement((LoopNameListNode)copyMe.elementAt(i).clone());
        }
    }

    public DataLoopNameListNode(NameListVector copyMe) {
        for (int i = 0; i < copyMe.size(); ++i) {
            this.addElement((LoopNameListNode)((LoopNameListNode)copyMe.elementAt(i)).clone());
        }
    }

    public Object clone() {
        return new DataLoopNameListNode(this);
    }

    public void setSize(int newSize) {
        this.myRows.setSize(newSize);
    }

    public int capacity() {
        return this.myRows.capacity();
    }

    public int size() {
        return this.myRows.size();
    }

    public boolean isEmpty() {
        return this.myRows.isEmpty();
    }

    public Enumeration elements() {
        return this.myRows.elements();
    }

    public boolean contains(LoopNameListNode row) {
        return this.myRows.contains(row);
    }

    public int indexOf(LoopNameListNode row) {
        return this.myRows.indexOf(row);
    }

    public int indexOf(LoopNameListNode row, int index) {
        return this.myRows.indexOf(row, index);
    }

    public int lastIndexOf(LoopNameListNode row) {
        return this.myRows.lastIndexOf(row);
    }

    public int lastIndexOf(LoopNameListNode row, int index) {
        return this.myRows.lastIndexOf(row, index);
    }

    public LoopNameListNode elementAt(int index) {
        return (LoopNameListNode)this.myRows.elementAt(index);
    }

    public LoopNameListNode firstElement() {
        return (LoopNameListNode)this.myRows.firstElement();
    }

    public LoopNameListNode lastElement() {
        return (LoopNameListNode)this.myRows.lastElement();
    }

    public void setElementAt(LoopNameListNode row, int index) {
        this.myRows.setElementAt(row, index);
        ((LoopNameListNode)this.myRows.elementAt(index)).setParent(this);
    }

    public void removeElementAt(int index) {
        ((LoopNameListNode)this.myRows.elementAt(index)).setParent(null);
        this.myRows.removeElementAt(index);
    }

    public void insertElementAt(LoopNameListNode row, int index) {
        this.myRows.insertElementAt(row, index);
        ((LoopNameListNode)this.myRows.elementAt(index)).setParent(this);
    }

    public void addElement(LoopNameListNode row) {
        this.myRows.addElement(row);
        ((LoopNameListNode)this.myRows.lastElement()).setParent(this);
    }

    public boolean removeElement(LoopNameListNode row) {
        row.setParent(null);
        return this.myRows.removeElement(row);
    }

    public String getLabel() {
        if (this.myRows.size() > 0) {
            return ((LoopNameListNode)this.myRows.elementAt(0)).getLabel();
        }
        return null;
    }

    public VectorCheckType searchByName(String searchFor) {
        VectorCheckType retVal = new VectorCheckType();
        try {
            retVal.addType(Class.forName(StarValidity.clsNameStarNode));
            retVal.freezeTypes();
            for (int i = 0; i < this.myRows.size(); ++i) {
                VectorCheckType tmpVect = ((LoopNameListNode)this.myRows.elementAt(i)).searchByName(searchFor);
                for (int j = 0; j < tmpVect.size(); ++j) {
                    retVal.addElement(tmpVect.elementAt(j));
                }
            }
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
            return null;
        }
        return retVal;
    }

    public VectorCheckType searchForType(Class type) {
        VectorCheckType retVal = new VectorCheckType();
        try {
            retVal.addType(Class.forName(StarValidity.clsNameStarNode));
            retVal.freezeTypes();
            if (type.isInstance(this)) {
                retVal.addElement(this);
            }
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
            return null;
        }
        return retVal;
    }

    public void tagPositionDeep(String tagName, RemoteInt nestLevel, RemoteInt column) {
        boolean foundIt = false;
        nestLevel.num = 0;
        while (nestLevel.num < this.myRows.size()) {
            LoopNameListNode curList = (LoopNameListNode)this.myRows.elementAt(nestLevel.num);
            column.num = -1;
            for (int i = 0; i < curList.size(); ++i) {
                if (!curList.elementAt(i).getLabel().equalsIgnoreCase(tagName)) continue;
                column.num = i;
                break;
            }
            if (column.num >= 0) {
                foundIt = true;
                break;
            }
            ++nestLevel.num;
        }
        if (!foundIt) {
            nestLevel.num = -1;
            column.num = -1;
        }
    }
}

